/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.util.DirectoryLoader;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class IfsContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private IActiveConnectionService activeConnectionService;
    @Inject
    @Named(value="miworkplace.ui.source.id")
    private Long sourceId;

    /*
     * Enabled aggressive block sorting
     */
    public Object[] getChildren(Object parent) {
        if (parent instanceof IConnectionManager) {
            List connections = this.connectionManager.list();
            Collections.sort(connections, new Comparator<IConnection>(){

                @Override
                public int compare(IConnection c1, IConnection c2) {
                    return c1.getName().compareTo(c2.getName());
                }
            });
            return connections.toArray(new IConnection[connections.size()]);
        }
        if (parent instanceof IConnection) {
            if (!((IConnection)parent).isConnected()) return NO_ELEMENTS;
            if (this.workspaceStore.get((IConnection)parent, "/dev") == null) {
                IEclipseContext additionalContext = EclipseContextFactory.create();
                IConnection connection = this.activeConnectionService.getLastUsedActiveConnection();
                additionalContext.set(IConnection.class, (Object)connection);
                additionalContext.set("miworkplace.ui.source.id", (Object)this.sourceId);
                DirectoryLoader loader = (DirectoryLoader)((Object)ContextInjectionFactory.make(DirectoryLoader.class, (IEclipseContext)this.eclipseContext, (IEclipseContext)additionalContext));
                loader.setRule(new ConnectionRule(this.activeConnectionService.getLastUsedActiveConnection().getName()));
                loader.schedule();
                return NO_ELEMENTS;
            }
            List<IRemoteObject> files = this.workspaceStore.getStreamFiles((IConnection)parent, "/");
            files = this.filter(files);
            return files.toArray(new IRemoteObject[files.size()]);
        }
        if (!(parent instanceof StreamFile)) return NO_ELEMENTS;
        StreamFile file = (StreamFile)parent;
        if (!file.isDirectory()) return NO_ELEMENTS;
        if (file.areChildrenLoaded()) {
            List files = this.workspaceStore.getStreamFiles(file.getConnection(), file.getPath());
            return files.toArray(new IRemoteObject[files.size()]);
        }
        IEclipseContext additionalContext = EclipseContextFactory.create();
        IConnection connection = this.activeConnectionService.getLastUsedActiveConnection();
        additionalContext.set(IConnection.class, (Object)connection);
        additionalContext.set(StreamFile.class, (Object)file);
        additionalContext.set("miworkplace.ui.source.id", (Object)this.sourceId);
        DirectoryLoader loader = (DirectoryLoader)((Object)ContextInjectionFactory.make(DirectoryLoader.class, (IEclipseContext)this.eclipseContext, (IEclipseContext)additionalContext));
        loader.setRule(new ConnectionRule(this.activeConnectionService.getLastUsedActiveConnection().getName()));
        loader.schedule();
        return NO_ELEMENTS;
    }

    private List<IRemoteObject> filter(List<IRemoteObject> files) {
        LinkedList<IRemoteObject> filtered = new LinkedList<IRemoteObject>();
        for (IRemoteObject file : files) {
            if (file.getPath().equalsIgnoreCase("/QSYS.LIB")) continue;
            filtered.add(file);
        }
        return filtered;
    }

    public Object getParent(Object element) {
        if (element instanceof IConnectionManager) {
            return null;
        }
        if (element instanceof IConnection) {
            return this.connectionManager;
        }
        if (element instanceof StreamFile) {
            StreamFile file = (StreamFile)element;
            if (StringUtils.countMatches((CharSequence)file.getPath(), (CharSequence)"/") == 1) {
                return file.getConnection();
            }
            return this.workspaceStore.getParentFile((IRemoteObject)file);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IConnection) {
            return ((IConnection)element).isConnected();
        }
        if (element instanceof StreamFile) {
            if (((StreamFile)element).isDirectory()) {
                StreamFile directory = (StreamFile)element;
                if (directory.areChildrenLoaded()) {
                    return this.getChildren(element).length > 0;
                }
                return true;
            }
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

