/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.service.log.LogService;

public class GotoLineHandler {
    private static final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    private LogService logger;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EPartService partService;
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IContentTypeRegistry contentTypeRegistry;

    @Execute
    public void execute(LogService logger, ESelectionService selectionServie) {
        IRemoteEditor editor;
        String ifsPath;
        this.logger = logger;
        IStructuredSelection selection = (IStructuredSelection)selectionServie.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (!(selection.getFirstElement() instanceof EventFileEntry)) {
            return;
        }
        EventFileEntry entry = (EventFileEntry)selection.getFirstElement();
        IConnection connection = entry.getEventFile().getConnection();
        IRemoteObject object = this.workspaceStore.get(connection, ifsPath = entry.getQsysPath());
        if (object == null) {
            QSYSObjectPathName pathName = new QSYSObjectPathName(ifsPath);
            QSYSObjectPathName filePathName = new QSYSObjectPathName(pathName.getLibraryName(), pathName.getObjectName(), "FILE");
            WorkspaceUtil.load(connection, filePathName.getPath());
            object = this.workspaceStore.get(connection, ifsPath);
        }
        if ((editor = this.getEditor(connection, object)) == null) {
            this.open(connection, object);
            editor = this.getEditor(connection, object);
        }
        if (editor != null) {
            this.highlight(entry, object, editor);
        }
    }

    private void open(IConnection connection, IRemoteObject source) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connection.getName());
        parameters.put("miworkplace.ui.editor.command.parameter.selection", source.getPath());
        ParameterizedCommand command = this.commandService.createCommand(OPEN_MEMBER_COMMAND_ID, parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command miworkplace.ui.command.openSourceMember is not available. Could not open member " + source.getPath() + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Member Handler cannot execute for member " + source.getPath() + ".");
        } else {
            IEclipseContext handlerContext = this.context.createChild(this.getClass().getName());
            handlerContext.set(IConnectionManager.class, (Object)this.connectionManager);
            handlerContext.set(IConnection.class, (Object)connection);
            handlerContext.set("memberPath", (Object)source.getPath());
            handlerContext.set(LogService.class, (Object)this.logger);
            handlerContext.set(EPartService.class, (Object)this.partService);
            this.handlerService.executeHandler(command, handlerContext);
            handlerContext.dispose();
        }
    }

    private IRemoteEditor getEditor(IConnection connection, IRemoteObject object) {
        MPart part = this.getPart(object);
        return part == null ? null : (IRemoteEditor)part.getObject();
    }

    private MPart getPart(IRemoteObject source) {
        String inputUri = EditorInputUriUtil.buildInputUri((String)source.getConnection().getName(), (String)source.getPath());
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor") || !part.getProperties().containsKey("miworkplace.editor.inputUri") || !((String)part.getProperties().get("miworkplace.editor.inputUri")).equals(inputUri) || part.getObject() == null || !(part.getObject() instanceof IRemoteEditor)) continue;
            return part;
        }
        return null;
    }

    private void highlight(EventFileEntry entry, IRemoteObject object, IRemoteEditor editor) {
        int line = entry.getLine();
        List contentTypes = this.contentTypeRegistry.getContentType(object);
        for (ContentType contentType : contentTypes) {
            if (!contentType.getId().equals("miworkplace.ui.editor.dds")) continue;
            line = entry.getLine() / 100;
            this.highlightLine(line, entry, editor);
            return;
        }
        this.highlightCodeRange(entry, editor);
    }

    private void highlightCodeRange(EventFileEntry entry, IRemoteEditor editor) {
        IDocument document = editor.getDocument();
        int line = entry.getLine();
        try {
            int offsetSelectionStart = document.getLineOffset(line - 1) + entry.getColumnStart() - 1;
            int selectionLength = document.getLineLength(line - 1) - entry.getColumnStart();
            if (entry.getColumnEnd() != 0) {
                selectionLength = entry.getColumnEnd() - entry.getColumnStart() + 1;
                editor.highlightCodeRange(offsetSelectionStart, selectionLength);
            } else {
                editor.highlightCodeRange(document.getLineOffset(line - 1), document.getLineLength(line - 1));
            }
        }
        catch (BadLocationException ble) {
            this.logger.log(1, "Could not show line " + line + ". Error: " + ble.getMessage());
        }
    }

    private void highlightLine(int line, EventFileEntry entry, IRemoteEditor editor) {
        IDocument document = editor.getDocument();
        try {
            editor.highlightCodeRange(document.getLineOffset(line - 1), document.getLineLength(line - 1));
        }
        catch (BadLocationException ble) {
            this.logger.log(1, "Could not show line " + line + ". Error: " + ble.getMessage());
        }
    }
}

