/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.api.ICompileResultService;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.compile.CompileResult;
import miworkplace.ui.compile.CompileResultSorter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;

public class CompileResultView
implements PropertyChangeListener {
    private static final String PREF_SORT_CRITERIA = "sortCriteria";
    private static final String PREF_SORT_DIRECTION = "sortDirection";
    private static final String PREF_FILTER_SHOW_INFORMATION_LEVEL = "filterShowInformationLevel";
    private static final String PREF_FILTER_SHOW_WARNING_LEVEL = "filterShowWarningLevel";
    private static final String PREF_FILTER_SHOW_ERROR_LEVEL = "filterShowErrorLevel";
    private static final String PREF_TABLE_COLUMN_TYPE = "tableColumnType";
    private static final String PREF_TABLE_COLUMN_SEVERITY = "tableColumnSeverity";
    private static final String PREF_TABLE_COLUMN_LINE = "tableColumnLine";
    private static final String PREF_TABLE_COLUMN_MESSAGE_ID = "tableColumnMessageId";
    private static final String PREF_TABLE_COLUMN_MESSAGE = "tableColumnMessage";
    private static final String PREF_TABLE_COLUMN_SOURCE_FILE = "tableColumnSourceFile";
    private static final int COMPILE_RESULT_COLUMN_TYPE = 0;
    private static final int COMPILE_RESULT_COLUMN_SEVERITY = 1;
    private static final int COMPILE_RESULT_COLUMN_LINE = 2;
    private static final int COMPILE_RESULT_COLUMN_MESSAGE_ID = 3;
    private static final int COMPILE_RESULT_COLUMN_MESSAGE = 4;
    private static final int COMPILE_RESULT_COLUMN_SOURCE_FILE = 5;
    private static final String POPUPMENU_ID = "miworkplace.ui.menu.popup.compile";
    public static final String ID = "miworkplace.ui.part.compileresult";
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private UISynchronize sync;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private ICompileResultService compileResultService;
    @Inject
    private EHelpService fHelpService;
    private StackLayout mainLayout;
    private TableViewer viewer;
    private Composite noEntriesLabel;
    private Composite noneAvailableLabel;
    private ViewerComparator defaultSorter = null;
    private boolean filterShowInformationLevel = true;
    private boolean filterShowWarningLevel = true;
    private boolean filterShowErrorLevel = true;
    private int tableColumnWidthType = 50;
    private int tableColumnWidthSeverity = 75;
    private int tableColumnWidthLine = 100;
    private int tableColumnWidthMessageId = 100;
    private int tableColumnWidthMessage = 600;
    private int tableColumnWidthSourceFile = 200;
    private ControlListener tableColumnControlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (e.getSource() instanceof TableColumn) {
                TableColumn column = (TableColumn)e.getSource();
                switch ((Integer)column.getData("index")) {
                    case 0: {
                        CompileResultView.this.tableColumnWidthType = column.getWidth();
                        break;
                    }
                    case 1: {
                        CompileResultView.this.tableColumnWidthSeverity = column.getWidth();
                        break;
                    }
                    case 2: {
                        CompileResultView.this.tableColumnWidthLine = column.getWidth();
                        break;
                    }
                    case 3: {
                        CompileResultView.this.tableColumnWidthMessageId = column.getWidth();
                        break;
                    }
                    case 4: {
                        CompileResultView.this.tableColumnWidthMessage = column.getWidth();
                        break;
                    }
                    case 5: {
                        CompileResultView.this.tableColumnWidthSourceFile = column.getWidth();
                    }
                }
            }
        }
    };
    ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean retVal = true;
            EventFileEntry entry = (EventFileEntry)element;
            if (!CompileResultView.this.filterShowInformationLevel && entry.getSeverityCode().equals("I")) {
                retVal = false;
            }
            if (!CompileResultView.this.filterShowWarningLevel && entry.getSeverityCode().equals("W")) {
                retVal = false;
            }
            if (!CompileResultView.this.filterShowErrorLevel && (entry.getSeverityCode().equals("E") || entry.getSeverityCode().equals("S") || entry.getSeverityCode().equals("T"))) {
                retVal = false;
            }
            return retVal;
        }
    };
    private Composite parentComposite;

    @Inject
    public CompileResultView(MPart part) {
        Map persistedState = part.getPersistedState();
        this.initCompileResultSorter(persistedState);
        this.loadTableColumnWidth(persistedState);
    }

    private void loadTableColumnWidth(Map<String, String> persistedState) {
        if (persistedState.containsKey(PREF_FILTER_SHOW_ERROR_LEVEL)) {
            this.filterShowErrorLevel = Boolean.parseBoolean(persistedState.get(PREF_FILTER_SHOW_ERROR_LEVEL));
        }
        if (persistedState.containsKey(PREF_FILTER_SHOW_INFORMATION_LEVEL)) {
            this.filterShowInformationLevel = Boolean.parseBoolean(persistedState.get(PREF_FILTER_SHOW_INFORMATION_LEVEL));
        }
        if (persistedState.containsKey(PREF_FILTER_SHOW_WARNING_LEVEL)) {
            this.filterShowWarningLevel = Boolean.parseBoolean(persistedState.get(PREF_FILTER_SHOW_WARNING_LEVEL));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_LINE)) {
            this.tableColumnWidthLine = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_LINE));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_MESSAGE)) {
            this.tableColumnWidthMessage = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_MESSAGE));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_MESSAGE_ID)) {
            this.tableColumnWidthMessageId = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_MESSAGE_ID));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_SEVERITY)) {
            this.tableColumnWidthSeverity = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_SEVERITY));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_SOURCE_FILE)) {
            this.tableColumnWidthSourceFile = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_SOURCE_FILE));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_TYPE)) {
            this.tableColumnWidthType = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_TYPE));
        }
    }

    private void initCompileResultSorter(Map<String, String> persistedState) {
        Integer sortCriteria = 2;
        Boolean sortDescending = true;
        if (persistedState.containsKey(PREF_SORT_CRITERIA)) {
            sortCriteria = Integer.valueOf(persistedState.get(PREF_SORT_CRITERIA));
        }
        if (persistedState.containsKey(PREF_SORT_DIRECTION)) {
            sortDescending = Boolean.parseBoolean(persistedState.get(PREF_SORT_DIRECTION));
        }
        this.defaultSorter = new CompileResultSorter(sortCriteria, sortDescending);
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService, final ESelectionService selectionService) {
        this.parentComposite = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.viewer = new TableViewer(parent, 66308);
        this.buildTable();
        this.noEntriesLabel = this.buildNoEntriesLabel(parent);
        this.noneAvailableLabel = this.buildNoneAvailableLabel(parent);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput(null);
        this.viewer.setFilters(new ViewerFilter[]{this.filter});
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    String commandId = "miworkplace.ui.command.compile.goto";
                    ParameterizedCommand command = CompileResultView.this.commandService.createCommand(commandId, null);
                    CompileResultView.this.handlerService.executeHandler(command);
                }
            }
        });
        menuService.registerContextMenu((Object)this.viewer.getControl(), POPUPMENU_ID);
        this.compileResultService.addCompileResultListener(this);
        this.fHelpService.setHelp((Object)parent, "miworkplace.help.MIW: Compile/Result");
        this.mainLayout.topControl = this.noneAvailableLabel;
    }

    private void buildTable() {
        Table table = this.viewer.getTable();
        TableColumn col1 = new TableColumn(table, 0x1000000);
        col1.setText(Messages.ui_compile_result_view_col_type);
        col1.setData("index", (Object)0);
        col1.setWidth(this.tableColumnWidthType);
        col1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 1));
        col1.addControlListener(this.tableColumnControlListener);
        TableColumn col2 = new TableColumn(table, 0x1000000);
        col2.setText(Messages.ui_compile_result_view_col_sev);
        col2.setData("index", (Object)1);
        col2.setWidth(this.tableColumnWidthSeverity);
        col2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 2));
        col2.addControlListener(this.tableColumnControlListener);
        TableColumn col3 = new TableColumn(table, 0x1000000);
        col3.setText(Messages.ui_compile_result_view_col_line);
        col3.setData("index", (Object)2);
        col3.setWidth(this.tableColumnWidthLine);
        col3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 6));
        col3.addControlListener(this.tableColumnControlListener);
        TableColumn col4 = new TableColumn(table, 16384);
        col4.setText(Messages.ui_compile_result_view_col_msgid);
        col4.setData("index", (Object)3);
        col4.setWidth(this.tableColumnWidthMessageId);
        col4.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 5));
        col4.addControlListener(this.tableColumnControlListener);
        TableColumn col5 = new TableColumn(table, 16384);
        col5.setText(Messages.ui_compile_result_view_col_text);
        col5.setData("index", (Object)4);
        col5.setWidth(this.tableColumnWidthMessage);
        col5.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 3));
        col5.addControlListener(this.tableColumnControlListener);
        TableColumn col6 = new TableColumn(table, 16384);
        col6.setText(Messages.ui_compile_result_view_col_srcfile);
        col6.setData("index", (Object)5);
        col6.setWidth(this.tableColumnWidthSourceFile);
        col6.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 4));
        col6.addControlListener(this.tableColumnControlListener);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setComparator(this.defaultSorter);
    }

    private Composite buildNoEntriesLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_compile_result_view_success);
        return form;
    }

    private Composite buildNoneAvailableLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_compile_result_view_noresult);
        return form;
    }

    @PreDestroy
    public void preDestroy() {
        BundleContext bc = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ICompileResultService service = (ICompileResultService)bc.getService(bc.getServiceReference(ICompileResultService.class.getName()));
        service.removeCompileResultListener(this);
    }

    @PersistState
    void persist(MPart part) {
        CompileResultSorter sorter = (CompileResultSorter)this.viewer.getComparator();
        Map persistedState = part.getPersistedState();
        persistedState.put(PREF_SORT_CRITERIA, String.valueOf(sorter.getCriteria()));
        persistedState.put(PREF_SORT_DIRECTION, String.valueOf(sorter.isSortDescending()));
        persistedState.put(PREF_FILTER_SHOW_INFORMATION_LEVEL, String.valueOf(this.filterShowInformationLevel));
        persistedState.put(PREF_FILTER_SHOW_WARNING_LEVEL, String.valueOf(this.filterShowWarningLevel));
        persistedState.put(PREF_FILTER_SHOW_ERROR_LEVEL, String.valueOf(this.filterShowErrorLevel));
        persistedState.put(PREF_TABLE_COLUMN_TYPE, String.valueOf(this.tableColumnWidthType));
        persistedState.put(PREF_TABLE_COLUMN_SEVERITY, String.valueOf(this.tableColumnWidthSeverity));
        persistedState.put(PREF_TABLE_COLUMN_LINE, String.valueOf(this.tableColumnWidthLine));
        persistedState.put(PREF_TABLE_COLUMN_MESSAGE_ID, String.valueOf(this.tableColumnWidthMessageId));
        persistedState.put(PREF_TABLE_COLUMN_MESSAGE, String.valueOf(this.tableColumnWidthMessage));
        persistedState.put(PREF_TABLE_COLUMN_SOURCE_FILE, String.valueOf(this.tableColumnWidthSourceFile));
    }

    @Override
    public void propertyChange(final PropertyChangeEvent event) {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CompileResultView.this.viewer == null) {
                    return;
                }
                if (event.getPropertyName().equals("new compile result")) {
                    CompileResultView.this.viewer.setInput(event.getNewValue());
                    CompileResultView.this.viewer.refresh();
                    CompileResult result = (CompileResult)event.getNewValue();
                    CompileResultView.this.setcontrol(result);
                    CompileResultView.this.parentComposite.layout();
                } else if (event.getPropertyName().equals("delete compile result") && CompileResultView.this.viewer.getInput().equals(event.getOldValue())) {
                    CompileResultView.this.viewer.setInput(null);
                    CompileResultView.this.viewer.refresh();
                    CompileResultView.this.mainLayout.topControl = CompileResultView.this.noneAvailableLabel;
                    CompileResultView.this.parentComposite.layout();
                }
            }
        });
    }

    private void setcontrol(CompileResult result) {
        this.mainLayout.topControl = result != null && result.hasErrors() ? this.viewer.getControl() : this.noEntriesLabel;
        this.mainLayout.topControl.getParent().layout();
    }

    public CompileResult getCurrentCompileResult() {
        if (this.viewer.getInput() == null) {
            return null;
        }
        if (this.viewer.getInput() instanceof CompileResult) {
            return (CompileResult)this.viewer.getInput();
        }
        return null;
    }

    @Inject
    public void selectionChanged(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection == null) {
            return;
        }
        Object element = selection.getFirstElement();
        if (this.viewer != null && element instanceof SourceMember || element instanceof StreamFile) {
            CompileResult result = this.compileResultService.getCompileResult(((IRemoteObject)element).getPath());
            this.viewer.setInput((Object)result);
            this.setcontrol(result);
        }
    }

    @Inject
    @Optional
    public void notifiedPartActivation(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event, @Named(value="e4ActivePart") MPart part) {
        if (this.viewer != null && part != null && part.getObject() instanceof IRemoteEditor) {
            String inputUri = ((IRemoteEditor)part.getObject()).getInputUri();
            String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
            CompileResult result = this.compileResultService.getCompileResult(memberPath);
            this.viewer.setInput((Object)result);
            this.setcontrol(result);
        }
    }

    @Inject
    @Optional
    public void notifiedPartBringToTop(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event, @Named(value="e4ActivePart") MPart part) {
        if (part == null) {
            return;
        }
        if (this.viewer != null && part.getObject() instanceof IRemoteEditor) {
            String inputUri = ((IRemoteEditor)part.getObject()).getInputUri();
            String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
            CompileResult result = this.compileResultService.getCompileResult(memberPath);
            this.viewer.setInput((Object)result);
            this.setcontrol(result);
        }
    }

    @Inject
    @Optional
    public void notifiedConnectionDisconnected(@UIEventTopic(value="miworkplace/connection/disconnected") Event event) {
        CompileResult compileResult;
        IConnection connection = (IConnection)event.getProperty("org.eclipse.e4.data");
        if (this.viewer != null && this.viewer.getInput() != null && (compileResult = (CompileResult)this.viewer.getInput()).getSource().getConnection().equals(connection)) {
            this.viewer.setInput(null);
            this.setcontrol(null);
        }
    }

    class ColumnSelectionAdapter
    extends SelectionAdapter {
        TableViewer viewer = null;
        int sortCriteria = -1;

        public ColumnSelectionAdapter(TableViewer viewer, int sortCriteria) {
            this.viewer = viewer;
            this.sortCriteria = sortCriteria;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.viewer.getComparator() instanceof CompileResultSorter) {
                CompileResultSorter sorter = (CompileResultSorter)this.viewer.getComparator();
                if (sorter.getCriteria() == this.sortCriteria) {
                    this.viewer.setComparator((ViewerComparator)new CompileResultSorter(this.sortCriteria, !sorter.isSortDescending()));
                } else {
                    this.viewer.setComparator((ViewerComparator)new CompileResultSorter(this.sortCriteria, false));
                }
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        private Object[] noObjects = new Object[0];

        ViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CompileResult) {
                Object[] entries = ((CompileResult)inputElement).getEntries();
                if (entries != null) {
                    return entries;
                }
                return this.noObjects;
            }
            return this.noObjects;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            EventFileEntry entry = (EventFileEntry)element;
            switch (columnIndex) {
                case 0: {
                    text = null;
                    break;
                }
                case 1: {
                    text = String.valueOf(entry.getSeverityLevel());
                    break;
                }
                case 3: {
                    text = entry.getMessageId();
                    break;
                }
                case 2: {
                    text = String.valueOf(entry.getLine());
                    break;
                }
                case 4: {
                    text = entry.getMessage();
                    break;
                }
                case 5: {
                    CompileResult result = (CompileResult)CompileResultView.this.viewer.getInput();
                    text = result != null ? result.getFile(entry.getFileId()) : null;
                }
            }
            return text;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof EventFileEntry && columnIndex == 0) {
                EventFileEntry entry = (EventFileEntry)element;
                if (entry.getSeverityCode() == null || entry.getSeverityCode().equals("")) {
                    return null;
                }
                if (entry.getSeverityCode().equals("I")) {
                    return CompileResultView.this.imagePool.getImageUnchecked("IMAGE_INFORMATION");
                }
                if (entry.getSeverityCode().equals("W")) {
                    return CompileResultView.this.imagePool.getImageUnchecked("IMAGE_WARNING");
                }
                return CompileResultView.this.imagePool.getImageUnchecked("IMAGE_ERROR");
            }
            return null;
        }
    }
}

