/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.ui.compile.CommandContentProposalProvider;
import miworkplace.ui.compile.CommandParameter;
import miworkplace.ui.compile.PlaceholderContentProposalListener;
import miworkplace.ui.compile.RemoteCommandParser;
import miworkplace.ui.compile.ReplacingTextContentAdapter;
import miworkplace.ui.util.Prompter;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CompileOptionsDialog
extends TrayDialog {
    private Debug logger = Debug.getInstance();
    private String fCompileCommand;
    private String fInitialValue;
    private String fDialogMessage;
    private Text fText;
    private String fResult = "";
    private IConnection fConnection;

    public CompileOptionsDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, String compileCommand, IConnection connection) {
        super(parentShell);
        this.fDialogMessage = dialogMessage;
        this.fInitialValue = initialValue;
        this.fCompileCommand = compileCommand;
        this.fConnection = connection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)dialogArea.getLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 10;
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_composite = new GridData(4, 4, true, true, 1, 1);
        gd_composite.horizontalIndent = 8;
        composite.setLayoutData((Object)gd_composite);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNewLabel.setText(this.fDialogMessage);
        Label label = new Label(composite, 0);
        label.setText(" ");
        this.fText = new Text(composite, 2114);
        GridData gd_Text = new GridData(4, 4, true, true, 1, 1);
        gd_Text.heightHint = 100;
        gd_Text.widthHint = 400;
        this.fText.setLayoutData((Object)gd_Text);
        this.fText.setText(this.fInitialValue);
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.fText, 16512);
        controlDecoration.setDescriptionText("ctrl+space");
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        controlDecoration.setImage(image);
        controlDecoration.show();
        this.setupContentAssist();
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite pParent) {
        this.createButton(pParent, 13, "Prompt", false);
        super.createButtonsForButtonBar(pParent);
    }

    protected void buttonPressed(int pButtonId) {
        if (pButtonId == 13) {
            String command = Prompter.prompt(this.fConnection, this.fCompileCommand + " " + this.fText.getText());
            if (command != null) {
                this.fText.setText(command.trim().replace(this.fCompileCommand, "").trim());
            }
        } else {
            super.buttonPressed(pButtonId);
        }
    }

    public String getValue() {
        return this.fResult;
    }

    protected void okPressed() {
        this.fResult = this.fText.getText();
        super.okPressed();
    }

    private void setupContentAssist() {
        try {
            List<CommandParameter> commandParameters = this.loadCommandParameters();
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ReplacingTextContentAdapter contentAdapter = new ReplacingTextContentAdapter();
            CommandContentProposalProvider provider = new CommandContentProposalProvider(contentAdapter);
            provider.setCommandParameters(commandParameters);
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.fText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)provider, keyStroke, null);
            contentProposalAdapter.addContentProposalListener((IContentProposalListener)new PlaceholderContentProposalListener(this.fText));
        }
        catch (Exception e) {
            this.logger.error("Could not setup content assist for compile command parameters.", (Throwable)e);
        }
    }

    private List<CommandParameter> loadCommandParameters() {
        return RemoteCommandParser.loadCommandParameters(this.fConnection, this.fCompileCommand);
    }

    protected boolean isResizable() {
        return true;
    }
}

