/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.api.ICompileCommandBuilder;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.compile.CompileJob;
import miworkplace.ui.compile.UnresolvedPlaceholderException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CompileHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private ICompileCommandBuilder compileCommandBuilder;
    @Inject
    private IEclipseContext context;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    private EPartService partService;

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Named(value="e4ActivePart") MPart part) {
        if (part != null && part.getObject() instanceof IRemoteEditor) {
            return true;
        }
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!(element instanceof SourceMember) && !(element instanceof StreamFile)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        IRemoteObject source = null;
        IConnection connection = null;
        if (part != null && part.getObject() instanceof IRemoteEditor) {
            String inputUri = ((IRemoteEditor)part.getObject()).getInputUri();
            String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
            connection = this.connectionManager.get(connectionName);
            String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
            source = this.workspaceStore.get(connection, memberPath);
            this.doCompile(source, connection);
        } else {
            if (selection == null) {
                Notifier.info((String)Messages.ui_compile_notify_title, (String)Messages.ui_compile_handler_noresource);
                return;
            }
            if (selection.isEmpty()) {
                Notifier.info((String)Messages.ui_compile_notify_title, (String)Messages.ui_compile_handler_empty);
                return;
            }
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IRemoteObject) {
                    source = (IRemoteObject)element;
                    connection = source.getConnection();
                    this.doCompile(source, connection);
                }
                ++n2;
            }
        }
    }

    private void doCompile(IRemoteObject source, IConnection connection) {
        String command;
        if (source instanceof SourceMember) {
            this.propertiesStore.get(source, true);
        } else if (!(source instanceof StreamFile)) {
            return;
        }
        MPart editorPart = this.getDirtyEditorPart(source);
        if (editorPart != null) {
            boolean saved = this.partService.savePart(editorPart, true);
            if (saved) {
                try {
                    Job.getJobManager().join((Object)connection, null);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.logger.info((Option)miworkplace.ui.debug.Option.compile, "Save was cancelled. Compile aborted.");
                    return;
                }
                catch (InterruptedException e) {
                    this.logger.error("Waiting for saving the editor content was interrupted.", (Throwable)e);
                    return;
                }
            } else {
                Notifier.info((String)Messages.ui_compile_notify_title, (String)Messages.ui_compile_handler_unsaved_content);
                return;
            }
        }
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "Compiling using connection " + connection.getName());
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "Compiling source " + source.getPath());
        try {
            command = this.compileCommandBuilder.buildCommand(source);
        }
        catch (UnresolvedPlaceholderException upe) {
            Notifier.warn((String)Messages.ui_compile_notify_title, (String)upe.getMessage());
            return;
        }
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "Using compile command: " + command);
        if (command.toUpperCase().startsWith("CRT") && !command.toUpperCase().contains("*EVENTF") && !command.toUpperCase().contains("*SRCDBG") && !this.applicationPreferences.getBoolean("miworkplace.ui.editor.ignore.no.eventfile", false)) {
            Notifier.info((String)Messages.ui_compile_notify_title, (String)(Messages.ui_compile_handler_noeventfile + System.lineSeparator() + Messages.ui_compile_handler_noeventfile2));
        }
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(IRemoteObject.class, (Object)source);
        additionalContext.set("compile.command", (Object)command);
        CompileJob job = (CompileJob)((Object)ContextInjectionFactory.make(CompileJob.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
        job.setRule(new ConnectionRule(connection.getName()));
        job.schedule();
    }

    private MPart getDirtyEditorPart(IRemoteObject source) {
        String inputUri = EditorInputUriUtil.buildInputUri((String)source.getConnection().getName(), (String)source.getPath());
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            IRemoteEditor editor;
            Object partObject = part.getObject();
            if (partObject == null || !(partObject instanceof IRemoteEditor) || !(editor = (IRemoteEditor)partObject).getInputUri().equals(inputUri) || !part.isDirty()) continue;
            return part;
        }
        return null;
    }
}

