/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.services.api.ICompileSettings;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.ui.compile.CommandContentProposalProvider;
import miworkplace.ui.compile.CommandParameter;
import miworkplace.ui.compile.PlaceholderContentProposalListener;
import miworkplace.ui.compile.RemoteCommandParser;
import miworkplace.ui.compile.ReplacingTextContentAdapter;
import miworkplace.ui.util.Prompter;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.floatingtext.FloatingText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CompileCommandDialog
extends TrayDialog {
    private Debug logger = Debug.getInstance();
    private String fCommandName;
    private String fDialogMessage;
    private Text fCommand;
    private String fResult = "";
    private IConnection fConnection;
    private ICompileSettingsProvider fSettings;
    private Button fIFS;
    private FloatingText fCommandDescription;
    private long fLastKeyPress;

    public CompileCommandDialog(Shell parentShell, String dialogTitle, String dialogMessage, IConnection connection, ICompileSettingsProvider provider) {
        super(parentShell);
        this.fDialogMessage = dialogMessage;
        this.fConnection = connection;
        this.fSettings = provider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)dialogArea.getLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.horizontalSpacing = 0;
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_composite = new GridData(4, 4, true, true, 1, 1);
        gd_composite.horizontalIndent = 8;
        composite.setLayoutData((Object)gd_composite);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNewLabel.setText(this.fDialogMessage);
        new Label(composite, 0).setText(" ");
        this.fCommandDescription = new FloatingText(composite, 2048);
        this.fCommandDescription.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.fCommandDescription.getText().setMessage("Description");
        this.fCommandDescription.getText().addListener(24, e -> this.check());
        this.fIFS = new Button(composite, 32);
        this.fIFS.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fIFS.setText("IFS Command");
        new Label(composite, 0).setText(" ");
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label2.setText("Compile command");
        this.fCommand = new Text(composite, 2114);
        GridData gd_Text = new GridData(4, 4, true, true, 1, 1);
        gd_Text.heightHint = 100;
        gd_Text.widthHint = 400;
        this.fCommand.setLayoutData((Object)gd_Text);
        this.fCommand.addListener(24, e -> this.check());
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.fCommand, 16512);
        controlDecoration.setDescriptionText("ctrl+space (type a $ and then ctrl+space for variables)");
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        controlDecoration.setImage(image);
        controlDecoration.show();
        this.setupContentAssist();
        return dialogArea;
    }

    protected void check() {
        long lastKeyPress = this.fLastKeyPress = System.currentTimeMillis();
        this.getShell().getDisplay().timerExec(1000, () -> {
            if (this.fLastKeyPress != lastKeyPress) {
                return;
            }
            boolean enabled = false;
            try {
                String[] cmd = this.fCommand.getText().trim().split("\\s");
                if (cmd.length == 0 || cmd[0].trim().isEmpty()) {
                    return;
                }
                if (this.fCommandDescription.getText().getText().trim().isEmpty()) {
                    return;
                }
                this.fCommandName = cmd[0];
                this.setupContentAssist();
                enabled = true;
            }
            finally {
                this.getButton(0).setEnabled(enabled);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite pParent) {
        this.createButton(pParent, 13, "Prompt", false);
        super.createButtonsForButtonBar(pParent);
        this.getButton(0).setText("Add");
        this.check();
        this.fCommandDescription.getText().setFocus();
    }

    protected void buttonPressed(int pButtonId) {
        if (pButtonId == 13) {
            String command = Prompter.prompt(this.fConnection, this.fCommand.getText());
            if (command != null) {
                this.fCommand.setText(command.trim());
            }
            this.getShell().forceActive();
        } else {
            super.buttonPressed(pButtonId);
        }
    }

    public String getResult() {
        return this.fResult;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        String[] cmd = this.fCommand.getText().trim().split("\\s");
        if (cmd.length == 0 || cmd[0].trim().isEmpty()) {
            return;
        }
        ICompileSettings compileSettings = this.fSettings.create();
        compileSettings.setName(this.fCommandDescription.getText().getText().trim());
        compileSettings.setIfs(this.fIFS.getSelection());
        compileSettings.setCompileCommand(cmd[0].trim());
        compileSettings.setArguments(this.fCommand.getText().replaceFirst(cmd[0], "").trim());
        this.fSettings.add(compileSettings);
        this.fResult = compileSettings.getId();
        super.okPressed();
    }

    private void setupContentAssist() {
        try {
            List<CommandParameter> commandParameters = this.loadCommandParameters();
            if (this.fCommand.getData("provider") != null) {
                ((CommandContentProposalProvider)this.fCommand.getData("provider")).setCommandParameters(commandParameters);
                return;
            }
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ReplacingTextContentAdapter contentAdapter = new ReplacingTextContentAdapter();
            CommandContentProposalProvider provider = new CommandContentProposalProvider(contentAdapter);
            provider.setCommandParameters(commandParameters);
            this.fCommand.setData("provider", (Object)provider);
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.fCommand, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)provider, keyStroke, null);
            PlaceholderContentProposalListener listener = new PlaceholderContentProposalListener(this.fCommand);
            contentProposalAdapter.addContentProposalListener((IContentProposalListener)listener);
        }
        catch (Exception e) {
            this.logger.error("Could not setup content assist for compile command parameters.", (Throwable)e);
        }
    }

    private List<CommandParameter> loadCommandParameters() {
        return RemoteCommandParser.loadCommandParameters(this.fConnection, this.fCommandName);
    }

    protected boolean isResizable() {
        return true;
    }
}

