/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.Collection;
import miworkplace.common.debug.Debug;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.IOutlinePageProvider;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.debug.Option;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OutlineView {
    private Debug logger = Debug.getInstance();
    private Composite compositeStack;
    private StackLayout stackLayout;
    private Composite noOutline;
    private String lastInputUri;

    @Inject
    public OutlineView(Composite parent, EHelpService helpService) {
        this.compositeStack = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.compositeStack.setLayout((Layout)this.stackLayout);
        this.noOutline = this.buildNoOutline(this.compositeStack);
        this.stackLayout.topControl = this.noOutline;
        helpService.setHelp((Object)parent, "miworkplace.help.MIW: Outline View");
        parent.layout();
    }

    private Composite buildNoOutline(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_outline_not_available);
        return form;
    }

    @Inject
    public void setActivePart(@Optional @Named(value="e4ActivePart") MPart activePart, EPartService partService) {
        if (this.compositeStack.isDisposed()) {
            return;
        }
        if (activePart != null) {
            if (activePart.getObject() instanceof IOutlinePageProvider) {
                IOutlinePageProvider outlinePageProvider = (IOutlinePageProvider)activePart.getObject();
                this.logger.debug((miworkplace.common.debug.Option)Option.editors, MessageFormat.format("Getting outline page for {0}", activePart.getObject()));
                this.stackLayout.topControl = outlinePageProvider.getOutlinePage(this.compositeStack);
                this.lastInputUri = outlinePageProvider.getInputUri();
            } else if (activePart.getObject() instanceof IRemoteEditor) {
                this.stackLayout.topControl = this.noOutline;
                this.lastInputUri = null;
            } else if (!this.editorOfCurrentOutlineActive(partService)) {
                this.stackLayout.topControl = this.noOutline;
                this.lastInputUri = null;
            }
            this.compositeStack.layout(true, true);
        }
    }

    private boolean editorOfCurrentOutlineActive(EPartService partService) {
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor.inputUri") || !((String)part.getProperties().get("miworkplace.editor.inputUri")).equals(this.lastInputUri)) continue;
            return part.getObject() != null;
        }
        return false;
    }
}

