/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.Library;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.common.ui.SelectionDialog;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class OpenSourceDialog
extends SelectionDialog {
    private static final String COMMA = ",";
    public static final String LIBRARIES = "miworkplace.ui.opensource.libraries";
    public static final String SOURCE_FILES = "miworkplace.ui.opensource.sourcefiles";
    public static final String MEMBERS = "miworkplace.ui.opensource.members";
    @Inject
    private IConnectionManager connectionManager;
    private Debug logger = Debug.getInstance();
    @Inject
    @Preference(nodePath="miworkplace.ui.opensource")
    private IEclipsePreferences preferences;
    private List<String> libraries = new LinkedList<String>();
    private List<String> sourcefiles = new LinkedList<String>();
    private List<String> members = new LinkedList<String>();
    private Combo cmbConnection;
    private Combo txtLibrary;
    private Combo txtFile;
    private Combo txtMember;
    private Label message;
    private QSYSObjectPathName path = null;
    private String selectedConnection = null;
    private IRemoteObject fSelectedRemoteObject;
    private IConnection fSelectedConnection;

    @Inject
    public OpenSourceDialog(Shell shell, @Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        super(shell);
        if (selection != null && selection.getFirstElement() instanceof IRemoteObject) {
            this.fSelectedRemoteObject = (IRemoteObject)selection.getFirstElement();
        } else if (selection != null && selection.getFirstElement() instanceof IConnection) {
            this.fSelectedConnection = (IConnection)selection.getFirstElement();
        }
        this.setTitle(Messages.OSD__openInEditor);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    @PostConstruct
    private void postConstruct() {
        this.loadSelection();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblConnection = new Label(composite, 0);
        lblConnection.setText(Messages.OSD__selectConn);
        LinkedList<String> connectionNames = new LinkedList<String>();
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            connectionNames.add(connection.getName());
        }
        String[] names = connectionNames.toArray(new String[connectionNames.size()]);
        this.cmbConnection = new Combo(composite, 8);
        GridData gd_cmbConnection = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbConnection.minimumWidth = 200;
        this.cmbConnection.setLayoutData((Object)gd_cmbConnection);
        this.cmbConnection.setItems(names);
        this.cmbConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OpenSourceDialog.this.cmbConnection.getSelectionIndex() != -1) {
                    OpenSourceDialog.this.selectedConnection = OpenSourceDialog.this.cmbConnection.getText();
                }
            }
        });
        this.cmbConnection.select(0);
        if (this.cmbConnection.getSelectionIndex() != -1) {
            this.selectedConnection = this.cmbConnection.getText();
        }
        Label lblLibrary = new Label(composite, 0);
        lblLibrary.setText(Messages.OSD__Library);
        this.txtLibrary = new Combo(composite, 2048);
        this.txtLibrary.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblFile = new Label(composite, 0);
        lblFile.setText(Messages.OSD__srcFile);
        this.txtFile = new Combo(composite, 2048);
        this.txtFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblMember = new Label(composite, 0);
        lblMember.setText(Messages.OSD__srcMbr);
        this.txtMember = new Combo(composite, 2048);
        this.txtMember.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.message = new Label(composite, 0);
        this.message.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.setValues();
        return composite;
    }

    private void setValues() {
        if (this.fSelectedRemoteObject instanceof Library) {
            this.libraries.remove(((Library)this.fSelectedRemoteObject).getName());
            this.libraries.add(0, ((Library)this.fSelectedRemoteObject).getName());
        } else if (this.fSelectedRemoteObject instanceof SourceFile) {
            this.libraries.remove(((SourceFile)this.fSelectedRemoteObject).getLibrary());
            this.libraries.add(0, ((SourceFile)this.fSelectedRemoteObject).getLibrary());
            this.sourcefiles.remove(((SourceFile)this.fSelectedRemoteObject).getName());
            this.sourcefiles.add(0, ((SourceFile)this.fSelectedRemoteObject).getName());
        } else if (this.fSelectedRemoteObject instanceof SourceMember) {
            this.libraries.remove(((SourceMember)this.fSelectedRemoteObject).getLibrary());
            this.libraries.add(0, ((SourceMember)this.fSelectedRemoteObject).getLibrary());
            this.sourcefiles.remove(((SourceMember)this.fSelectedRemoteObject).getSourceFile());
            this.sourcefiles.add(0, ((SourceMember)this.fSelectedRemoteObject).getSourceFile());
            this.members.remove(((SourceMember)this.fSelectedRemoteObject).getName());
            this.members.add(0, ((SourceMember)this.fSelectedRemoteObject).getName());
        }
        if (this.fSelectedRemoteObject != null) {
            this.cmbConnection.setText(this.fSelectedRemoteObject.getConnection().getName());
        }
        if (this.fSelectedConnection != null) {
            this.cmbConnection.setText(this.fSelectedConnection.getName());
        }
        if (!this.libraries.isEmpty()) {
            this.txtLibrary.setItems(this.libraries.toArray(new String[0]));
            this.txtLibrary.setText(this.libraries.get(0));
        }
        if (!this.sourcefiles.isEmpty()) {
            this.txtFile.setItems(this.sourcefiles.toArray(new String[0]));
            this.txtFile.setText(this.sourcefiles.get(0));
        }
        if (!this.members.isEmpty()) {
            this.txtMember.setItems(this.members.toArray(new String[0]));
            this.txtMember.setText(this.members.get(0));
        }
    }

    private boolean setPath() {
        boolean retVal = false;
        if (this.txtLibrary.getText().length() > 0 && this.txtFile.getText().length() > 0 && this.txtMember.getText().length() > 0) {
            try {
                this.path = new QSYSObjectPathName("/QSYS.LIB/" + this.txtLibrary.getText() + ".LIB/" + this.txtFile.getText() + ".FILE/" + this.txtMember.getText() + ".MBR");
                retVal = true;
            }
            catch (Exception exception) {
                retVal = false;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    public Object[] getResult() {
        if (this.path == null) {
            return null;
        }
        Object[] result = new Object[]{EditorInputUriUtil.buildInputUri((String)this.selectedConnection, (String)this.path.getPath())};
        return result;
    }

    protected void okPressed() {
        this.txtLibrary.setText(this.txtLibrary.getText().toUpperCase());
        this.txtFile.setText(this.txtFile.getText().toUpperCase());
        this.txtMember.setText(this.txtMember.getText().toUpperCase());
        if (this.setPath()) {
            this.addSelection();
            this.saveSelection();
            super.okPressed();
        } else {
            this.setErrorMessage(Messages.ui_open_dialog_invalid_path);
            this.path = null;
        }
    }

    private void setErrorMessage(String msg) {
        this.message.setText(msg);
        this.message.getParent().layout();
    }

    private void loadSelection() {
        String[] libraries = this.preferences.get(LIBRARIES, "QGPL").split(COMMA);
        this.libraries.addAll(Arrays.asList(libraries));
        String[] sourceFiles = this.preferences.get(SOURCE_FILES, "QRPGLESRC").split(COMMA);
        this.sourcefiles.addAll(Arrays.asList(sourceFiles));
        String[] members = this.preferences.get(MEMBERS, "").split(COMMA);
        if (members.length > 0) {
            this.members.addAll(Arrays.asList(members));
        }
    }

    private void saveSelection() {
        if (this.libraries.size() > 15) {
            this.libraries = this.libraries.subList(0, 15);
        }
        this.preferences.put(LIBRARIES, StringUtils.join(this.libraries, (String)COMMA));
        if (this.sourcefiles.size() > 15) {
            this.sourcefiles = this.sourcefiles.subList(0, 15);
        }
        this.preferences.put(SOURCE_FILES, StringUtils.join(this.sourcefiles, (String)COMMA));
        if (this.members.size() > 15) {
            this.members = this.members.subList(0, 15);
        }
        this.preferences.put(MEMBERS, StringUtils.join(this.members, (String)COMMA));
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException bse) {
            this.logger.error("Could not save preferences for open dialog.", (Throwable)bse);
        }
    }

    private void addSelection() {
        this.libraries.remove(this.txtLibrary.getText());
        this.libraries.add(0, this.txtLibrary.getText());
        this.sourcefiles.remove(this.txtFile.getText());
        this.sourcefiles.add(0, this.txtFile.getText());
        this.members.remove(this.txtMember.getText());
        this.members.add(0, this.txtMember.getText());
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }
}

