/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.ui.debug.Option;
import miworkplace.ui.explorer.filter.FilterManager;
import miworkplace.ui.handler.showview.ShowWelcomeHandler;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MiWorkplaceAddon {
    @Inject
    private IEclipseContext context;
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IEventBroker fEventBroker;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;

    @PostConstruct
    void postContextCreate(EPartService partService, ContextManager pContextManager) {
        IProject project = this.workspace.getRoot().getProject("RemoteFileSystem");
        if (!project.exists()) {
            try {
                project.create(null);
                this.workspace.save(false, null);
            }
            catch (CoreException e) {
                this.logger.error("The temp project RemoteFileSystem could not be created. This is a fatal error and the application cannot function without it.", (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Fatal Error", (String)("Could not write to the workspace folder. Error: " + e.getMessage()));
            }
        }
        ContextInjectionFactory.make(FilterManager.class, (IEclipseContext)this.context);
        try {
            project.open(null);
        }
        catch (CoreException e) {
            this.logger.error("Could not open RemoteFileSystem project.", (Throwable)e);
        }
        this.retargetBindingContexts(pContextManager);
    }

    private void retargetBindingContexts(ContextManager pContextManager) {
        this.logger.error((miworkplace.common.debug.Option)Option.lifeCycle, "Retargeting binding contexts - Start");
        Context[] contextArray = pContextManager.getDefinedContexts();
        int n = contextArray.length;
        int n2 = 0;
        while (n2 < n) {
            Context context = contextArray[n2];
            try {
                if (context.getId().startsWith("miw") && context.getParentId() == null) {
                    context.define(context.getName(), context.getDescription(), "org.eclipse.ui.contexts.window");
                    this.logger.info((miworkplace.common.debug.Option)Option.lifeCycle, context.getId() + " context reparented");
                }
            }
            catch (NotDefinedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        this.logger.error((miworkplace.common.debug.Option)Option.lifeCycle, "Retargeting binding contexts - End");
    }

    @Inject
    @Optional
    private void startupComplete(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Object fluff) {
        this.fEventBroker.post("miworkplace/ui/application/init", (Object)"fluff");
    }

    @Inject
    @Optional
    private void applicationInit(@UIEventTopic(value="miworkplace/ui/application/init") Object fluff, EPartService pPartService, MApplication pApplication) {
        this.showWelcomePage(pApplication);
        this.closeMessageViews(pPartService);
    }

    private void closeMessageViews(EPartService pPartService) {
        try {
            this.logger.info((miworkplace.common.debug.Option)Option.lifeCycle, "Closing parts.");
            pPartService.getParts().forEach(part -> {
                if ("miworkplace.ui.partdescriptor.message".equals(part.getElementId())) {
                    this.logger.info((miworkplace.common.debug.Option)Option.lifeCycle, "Closing miworkplace.ui.partdescriptor.message");
                    pPartService.hidePart(part);
                }
            });
        }
        catch (Exception e) {
            this.logger.warning("Could not access parts.", (Throwable)e);
        }
    }

    private void showWelcomePage(MApplication pApplication) {
        ShowWelcomeHandler welcomeHandler = (ShowWelcomeHandler)ContextInjectionFactory.make(ShowWelcomeHandler.class, (IEclipseContext)this.context);
        if (pApplication.getPersistedState().get("MiWelcome") == null) {
            pApplication.getPersistedState().put("MiWelcome", "welcomewasshown");
            welcomeHandler.execute();
        }
    }

    @Inject
    @Optional
    void preSave(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appShutdownStarted") Object fluff, IApplicationContext appContext, EPartService pPartService) {
        this.logger.info((miworkplace.common.debug.Option)Option.lifeCycle, "Ending MiWorkplace");
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            try {
                this.logger.info((miworkplace.common.debug.Option)Option.lifeCycle, MessageFormat.format("Closing connection {0}", connection.getName()));
                connection.disconnect();
                this.logger.info((miworkplace.common.debug.Option)Option.lifeCycle, MessageFormat.format("Connection {0} closed", connection.getName()));
            }
            catch (Exception e) {
                this.logger.error(MessageFormat.format("Error disconnecting connection {0}. Cause: {1}", connection.getName(), e.getMessage()), (Throwable)e);
            }
        }
        try {
            this.workspace.save(true, null);
        }
        catch (CoreException e) {
            this.logger.error("Could not sync the workspace with the filesystem.", (Throwable)e);
        }
    }
}

