/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.jackson.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.remainsoftware.common.util.NetUtils;
import com.remainsoftware.jackson.core.Root;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class Requester {
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String PATCH = "PATCH";
    private final Root root;
    private final List<Entry> args = new ArrayList<Entry>();
    private String method = "POST";
    private String contentType = "application/json";
    private InputStream body;

    public Requester(Root system) {
        this.root = system;
    }

    public Requester with(String key, int value) {
        return this._with(key, value);
    }

    public Requester with(String key, Integer value) {
        if (value != null) {
            this._with(key, (int)value);
        }
        return this;
    }

    public Requester with(String key, boolean value) {
        return this._with(key, value);
    }

    public Requester with(String key, String value) {
        return this._with(key, value);
    }

    public Requester with(String key, Collection<String> value) {
        return this._with(key, value);
    }

    public Requester with(String key, Map<String, String> value) {
        return this._with(key, value);
    }

    public Requester with(InputStream body) {
        this.body = body;
        return this;
    }

    public Requester _with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    private Requester method(String method) {
        this.method = method;
        return this;
    }

    public Requester patch() {
        this.method = PATCH;
        return this;
    }

    public Requester put() {
        this.method = PUT;
        return this;
    }

    public Requester post() {
        this.method = POST;
        return this;
    }

    public Requester get() {
        this.method = GET;
        return this;
    }

    public Requester contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, (Object)null);
    }

    public <T> T to(String tailApiUrl, Class<T> type, Object instance) throws IOException {
        return this._to(tailApiUrl, type, instance);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this._to(tailApiUrl, type);
    }

    public <T> T to(String tailApiUrl, T existingInstance) throws IOException {
        return this._to(tailApiUrl, null, existingInstance);
    }

    @Deprecated
    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        return (T)this.method(method).to(tailApiUrl, (T)type);
    }

    private <T> T _to(String tailApiUrl, Class<T> type) throws IOException {
        HttpURLConnection uc = null;
        while (true) {
            block11: {
                try {
                    uc = this.setupConnection(this.root.getApiURL(tailApiUrl));
                    if (this.method.equals(GET)) break block11;
                    uc.setDoOutput(true);
                    uc.setRequestProperty("Content-type", this.contentType);
                    if (this.body == null) {
                        HashMap<String, Object> json = new HashMap<String, Object>();
                        for (Entry e : this.args) {
                            json.put(e.key, e.value);
                        }
                        this.root.getMapper().writeValue(uc.getOutputStream(), json);
                        break block11;
                    }
                    try {
                        byte[] bytes = new byte[32768];
                        int read = 0;
                        while ((read = this.body.read(bytes)) != -1) {
                            uc.getOutputStream().write(bytes, 0, read);
                        }
                    }
                    finally {
                        this.body.close();
                    }
                }
                catch (IOException e) {
                    System.out.println("An I/O exception occurred while processing a request for Url: '" + this.root.getApiURL(tailApiUrl) + "', msg = " + e.getMessage());
                    throw e;
                }
            }
            try {
                return this.parse(uc, type);
            }
            catch (IOException e) {
                System.out.println("An I/O exception occurred while processing a request for Url: '" + this.root.getApiURL(tailApiUrl) + "', msg = " + e.getMessage());
                this.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    private <T> T _to(String tailApiUrl, Class<T> type, Object instance) throws IOException {
        HttpURLConnection uc = null;
        while (true) {
            block10: {
                try {
                    uc = this.setupConnection(this.root.getApiURL(tailApiUrl));
                    if (this.method.equals(GET)) break block10;
                    uc.setDoOutput(true);
                    uc.setRequestProperty("Content-type", this.contentType);
                    if (this.body == null) {
                        this.root.getMapper().writeValue(uc.getOutputStream(), instance);
                        break block10;
                    }
                    try {
                        byte[] bytes = new byte[32768];
                        int read = 0;
                        while ((read = this.body.read(bytes)) != -1) {
                            uc.getOutputStream().write(bytes, 0, read);
                        }
                    }
                    finally {
                        this.body.close();
                    }
                }
                catch (IOException e) {
                    System.out.println("An I/O exception occurred while processing a request for Url: '" + this.root.getApiURL(tailApiUrl) + "', msg = " + e.getMessage());
                    throw e;
                }
            }
            try {
                return this.parse(uc, type);
            }
            catch (IOException e) {
                System.out.println("An I/O exception occurred while processing a request for Url: '" + this.root.getApiURL(tailApiUrl) + "', msg = " + e.getMessage());
                this.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    <T> Iterator<T> asIterator(String tailApiUrl, final Class<T> type) {
        this.method(GET);
        if (!this.args.isEmpty()) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(tailApiUrl){
            T next;
            URL url;
            {
                try {
                    this.url = Requester.this.root.getApiURL(string);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object r = this.next;
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this.next != null) {
                    return;
                }
                if (this.url == null) {
                    return;
                }
                try {
                    while (true) {
                        HttpURLConnection uc = Requester.this.setupConnection(this.url);
                        try {
                            this.next = Requester.this.parse(uc, type, null);
                            if (!$assertionsDisabled && this.next == null) {
                                throw new AssertionError();
                            }
                            this.findNextURL(uc);
                            return;
                        }
                        catch (IOException e) {
                            Requester.this.handleApiError(e, uc);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private void findNextURL(HttpURLConnection uc) throws MalformedURLException {
                this.url = null;
                String link = uc.getHeaderField("Link");
                if (link == null) {
                    return;
                }
                String[] stringArray = link.split(", ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (token.endsWith("rel=\"next\"")) {
                        int idx = token.indexOf(62);
                        this.url = new URL(token.substring(1, idx));
                        return;
                    }
                    ++n2;
                }
            }
        };
    }

    protected HttpURLConnection setupConnection(URL url) throws IOException {
        HttpURLConnection httpConn = null;
        try {
            httpConn = NetUtils.openHttpConnection((URL)url);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (this.root.getEncodedAuthorization() != null) {
            httpConn.setRequestProperty("Authorization", this.root.getEncodedAuthorization());
        }
        try {
            httpConn.setRequestMethod(this.method);
        }
        catch (ProtocolException protocolException) {
            try {
                Field $method = HttpURLConnection.class.getDeclaredField("method");
                $method.setAccessible(true);
                $method.set(httpConn, this.method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        httpConn.setRequestProperty("Accept-Encoding", "gzip");
        return httpConn;
    }

    private <T> T parse(HttpURLConnection uc, Class<T> type, T instance) throws IOException {
        InputStreamReader r;
        block4: {
            String data;
            block3: {
                Object object;
                r = null;
                try {
                    r = new InputStreamReader(this.wrapStream(uc, uc.getInputStream()), "UTF-8");
                    data = IOUtils.toString((Reader)r);
                    if (type == null) break block3;
                    object = this.root.getMapper().readValue(data, type);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(r);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)r);
                return (T)object;
            }
            if (instance == null) break block4;
            Object object = this.root.getMapper().readerForUpdating(instance).readValue(data);
            IOUtils.closeQuietly((Reader)r);
            return (T)object;
        }
        IOUtils.closeQuietly((Reader)r);
        return null;
    }

    private <T> T parse(HttpURLConnection uc, Class<T> type) throws IOException {
        return this.parse(uc, type, null);
    }

    private InputStream wrapStream(HttpURLConnection uc, InputStream in) throws IOException {
        String encoding = uc.getContentEncoding();
        if (encoding == null || in == null) {
            return in;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    void handleApiError(IOException e, HttpURLConnection uc) throws IOException {
        if ("0".equals(uc.getHeaderField("X-RateLimit-Remaining"))) {
            try {
                Thread.sleep(10000L);
                return;
            }
            catch (InterruptedException interruptedException) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        if (e instanceof FileNotFoundException) {
            throw e;
        }
        InputStream es = this.wrapStream(uc, uc.getErrorStream());
        try {
            if (es != null) {
                throw (IOException)new IOException(IOUtils.toString((InputStream)es, (String)"UTF-8")).initCause(e);
            }
            throw e;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    public Root getRoot() {
        return this.root;
    }

    public Requester with(Object object) {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            HashMap o = (HashMap)this.getRoot().getMapper().readValue(this.root.getMapper().writeValueAsBytes(object), (TypeReference)typeRef);
            for (Map.Entry entry : o.entrySet()) {
                if (entry.getValue() == null) continue;
                this.with((String)entry.getKey(), entry.getValue().toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private static class Entry {
        String key;
        Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

