/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.markdown.parser;

import java.io.Reader;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import miworkplace.ui.editor.markdown.parser.Header;
import miworkplace.ui.editor.markdown.parser.HeaderHierarchy;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class MarkdownTocParser {
    public HeaderHierarchy parse(Reader in) throws Exception {
        HeaderHierarchy headerHierarchy = new HeaderHierarchy();
        Header lastHeader = null;
        boolean inCodeBlock = false;
        List lines = IOUtils.readLines((Reader)in);
        AtomicInteger i = new AtomicInteger(0);
        while (i.get() < lines.size()) {
            String line = (String)lines.get(i.get());
            if (!inCodeBlock && this.isHeader(lines, i)) {
                int level = this.getHeaderLevel(line, lines, i);
                Header header = new Header(null, level, i.get() + 1, this.getHeaderValue(line));
                header.parent = this.findParentHeader(header, lastHeader);
                if (header.parent == null) {
                    headerHierarchy.headers.add(header);
                } else {
                    header.parent.subHeaders.add(header);
                }
                lastHeader = header;
            }
            if (line.startsWith("```")) {
                inCodeBlock = !inCodeBlock;
            }
            i.incrementAndGet();
        }
        return headerHierarchy;
    }

    private String getHeaderValue(String line) {
        return StringUtils.strip((String)line, (String)" #");
    }

    private Header findParentHeader(Header header, Header lastHeader) {
        if (lastHeader == null) {
            return null;
        }
        if (header.level == lastHeader.level) {
            return lastHeader.parent;
        }
        if (header.level > lastHeader.level) {
            return lastHeader;
        }
        Header parent = lastHeader.parent;
        while (parent != null) {
            if (parent.level < header.level) {
                return parent;
            }
            parent = parent.parent;
        }
        return null;
    }

    private int getHeaderLevel(String line, List<String> lines, AtomicInteger i) {
        if (line.trim().startsWith("#")) {
            int index = StringUtils.indexOfAnyBut((CharSequence)line, (CharSequence)"# ");
            if (index == -1) {
                return -1;
            }
            return line.substring(0, index).trim().length();
        }
        if (lines.size() > i.get() + 1) {
            String nextLine = lines.get(i.get() + 1);
            if (nextLine.startsWith("==")) {
                return 1;
            }
            if (nextLine.startsWith("--")) {
                return 2;
            }
        }
        return -1;
    }

    private boolean isHeader(List<String> lines, AtomicInteger i) {
        String line = lines.get(i.get());
        if (line.startsWith("    ")) {
            return false;
        }
        if (line.startsWith("\t")) {
            return false;
        }
        if (line.trim().startsWith("#")) {
            return true;
        }
        if (lines.size() > i.get() + 1) {
            String nextLine = lines.get(i.get() + 1);
            if (nextLine.startsWith("==")) {
                return true;
            }
            if (nextLine.startsWith("--")) {
                return true;
            }
        }
        return false;
    }
}

