/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.markdown;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IUrlService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CheatSheet {
    @Inject
    private IUrlService urlService;

    @PostConstruct
    public void createControls(Composite parent) {
        this.buildContentComposite(parent);
    }

    private Composite buildContentComposite(Composite parent) {
        FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = formToolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        form.getBody().setLayout((Layout)layout);
        FormText formText = formToolkit.createFormText(form.getBody(), true);
        formText.setText(Messages.markdown_cheatsheet_desc, false, true);
        formText.setLayoutData((Object)new TableWrapData());
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String url = "http://daringfireball.net/projects/markdown/syntax";
                CheatSheet.this.urlService.open(url);
            }
        });
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "# " + Messages.markdown_cheatsheet_topheader);
        formToolkit.createLabel(form.getBody(), "## " + Messages.markdown_cheatsheet_subheader);
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), Messages.markdown_cheatsheet_topheader + "\n==========");
        formToolkit.createLabel(form.getBody(), Messages.markdown_cheatsheet_subheader + "\n---------------");
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "*italic*  " + Messages.markdown_cheatsheet_or + "  _italic_");
        formToolkit.createLabel(form.getBody(), "**bold**  " + Messages.markdown_cheatsheet_or + " __bold__");
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "> block\n> quote");
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "* " + Messages.markdown_cheatsheet_listentrystyle + " 1");
        formToolkit.createLabel(form.getBody(), "- " + Messages.markdown_cheatsheet_listentrystyle + " 2");
        formToolkit.createLabel(form.getBody(), "+ " + Messages.markdown_cheatsheet_listentrystyle + " 3");
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "`" + Messages.markdown_cheatsheet_inline + "`");
        formToolkit.createLabel(form.getBody(), "```\n" + Messages.markdown_cheatsheet_block + "\n```");
        formToolkit.createLabel(form.getBody(), "    " + Messages.markdown_cheatsheet_indented);
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), Messages.markdown_cheatsheet_line + ":\n---\n- - -\n***\n* * *");
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "[link " + Messages.markdown_cheatsheet_title + "](http://url)");
        formToolkit.createLabel(form.getBody(), "");
        formToolkit.createLabel(form.getBody(), "\\*" + Messages.markdown_cheatsheet_escaped + "\\*");
        return form;
    }
}

