/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.ui.SWTFontUtils;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.search.EventFileEntryMatch;
import miworkplace.ui.search.Match;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultPart;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;

public class PrintSearchResultHandler {
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    private IWorkspaceStore workspaceStore;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        Object object = part.getObject();
        if (object instanceof SearchResultPart) {
            SearchResult searchResult = ((SearchResultPart)object).getCurrentSearchResult();
            if (searchResult == null) {
                return;
            }
            List<String> ifsPaths = searchResult.getIfsPaths();
            LinkedList<EventFileEntry> entries = new LinkedList<EventFileEntry>();
            for (String path : ifsPaths) {
                Match[] matches;
                Match[] matchArray = matches = searchResult.getMatches(path);
                int n = matches.length;
                int n2 = 0;
                while (n2 < n) {
                    Match m = matchArray[n2];
                    entries.add(((EventFileEntryMatch)m).getEntry());
                    ++n2;
                }
            }
            Print print = this.prepareSearchResultData(searchResult.getLabel(), entries, searchResult.getConnection());
            PrintDialog dialog = new PrintDialog(shell, 0);
            PrinterData printerData = dialog.open();
            if (printerData != null) {
                PrintJob job = new PrintJob("Source code search result", print);
                job = job.setMargins(40);
                PaperClips.print((PrintJob)job, (PrinterData)printerData);
            }
        }
    }

    private Print prepareSearchResultData(String title, List<EventFileEntry> entries, IConnection connection) {
        GridPrint print = new GridPrint("p, l:10, d:g");
        String lastPath = "";
        Collections.sort(entries);
        for (EventFileEntry entry : entries) {
            Font monospacedFont = SWTFontUtils.getMonospacedFont();
            FontData[] printFontData = monospacedFont.getFontData();
            String qsysPath = entry.getQsysPath();
            if (!qsysPath.equals(lastPath)) {
                String description;
                if (entry != entries.get(0)) {
                    print.add((Print)new EmptyPrint(1, printFontData[0].getHeight()));
                    print.add((Print)new EmptyPrint(1, printFontData[0].getHeight()));
                    print.add((Print)new EmptyPrint(1, printFontData[0].getHeight()));
                }
                if (StringUtils.isBlank((CharSequence)(description = this.getMemberDescription(connection, qsysPath)))) {
                    print.add((Print)new TextPrint(qsysPath, printFontData[0]), -1);
                } else {
                    print.add((Print)new TextPrint(qsysPath + " : " + description, printFontData[0]), -1);
                }
                lastPath = qsysPath;
            }
            String line = String.valueOf(entry.getLine());
            line = StringUtils.leftPad((String)line, (int)5);
            print.add((Print)new TextPrint(line, printFontData[0]));
            print.add((Print)new EmptyPrint(1, printFontData[0].getHeight()));
            print.add((Print)new TextPrint(entry.getMessage(), printFontData[0]));
        }
        return print;
    }

    private String getMemberDescription(IConnection connection, String ifsPath) {
        Map properties;
        IRemoteObject member = this.workspaceStore.get(connection, ifsPath);
        if (member != null && (properties = this.propertiesStore.get(member)) != null) {
            return properties.get(ObjectProperty.textdescription).toString();
        }
        return null;
    }
}

