/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultPart;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class AddMemberDescriptionHandler {
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEclipseContext context;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        Object object = part.getObject();
        if (object instanceof SearchResultPart) {
            SearchResult searchResult = ((SearchResultPart)object).getCurrentSearchResult();
            return searchResult != null;
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        Object object = part.getObject();
        if (object instanceof SearchResultPart) {
            SearchResultPart searchResultPart = (SearchResultPart)object;
            SearchResult searchResult = searchResultPart.getCurrentSearchResult();
            List<String> ifsPaths = searchResult.getIfsPaths();
            for (String ifsPath : ifsPaths) {
                IRemoteObject member = this.workspaceStore.get(searchResult.getConnection(), ifsPath);
                if (member == null) {
                    this.loadPath(searchResult.getConnection(), ifsPath);
                    member = this.workspaceStore.get(searchResult.getConnection(), ifsPath);
                }
                if (member == null) continue;
                this.propertiesStore.get(member, false);
            }
            searchResultPart.refresh();
        }
    }

    private void loadPath(IConnection connection, String memberPath) {
        String filePath;
        IRemoteObject sourceFile;
        if (this.workspaceStore.get(connection, memberPath) != null) {
            return;
        }
        QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
        String libraryPath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB";
        IRemoteObject library = this.workspaceStore.get(connection, libraryPath);
        if (library == null) {
            List libraries = this.workspaceStore.getLibraries(connection);
            for (IRemoteObject l : libraries) {
                if (!l.getName().equals(path.getLibraryName())) continue;
                this.workspaceStore.remove(library);
                break;
            }
            this.workspaceStore.addLibrary(connection, path.getLibraryName());
            library = this.workspaceStore.getLibrary(connection, path.getLibraryName());
        }
        if ((sourceFile = this.workspaceStore.get(connection, filePath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB/" + path.getObjectName() + ".FILE")) == null || !library.areChildrenLoaded()) {
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.library", (Object)library);
            ObjectLoader loader = (ObjectLoader)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException("Could not load source file " + path.getObjectName() + ": " + status.getMessage());
            }
        }
        if (this.workspaceStore.get(connection, memberPath) == null) {
            IRemoteObject file = this.workspaceStore.get(connection, filePath);
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.file", (Object)file);
            MemberLoader loader = (MemberLoader)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException("Could not load members of source file " + path.getObjectName() + ": " + status.getMessage());
            }
        }
    }
}

