/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.Library;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.common.ui.NumericVerifyListener;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.images.service.Factory;
import miworkplace.notifications.Notifier;
import miworkplace.ui.search.ColumnRangeToVerifyListener;
import miworkplace.ui.search.RemoteSearchQuery;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RemoteSearchDialog
extends TitleAreaDialog {
    private static final int ENGINE_FNDSTRPDM = 1;
    private static final int ENGINE_OLD_GREP = 2;
    private static final int ENGINE_NEW_GREP = 3;
    private static final String COL_100 = "100";
    private static final String COL_1 = "1";
    private static final String EMPTY = "";
    private static final String ALL = "*ALL";
    private static final String DIALOG_SETTINGS_CONNECTION_NAME = "miworkplace.ui.search.remote.connection";
    private static final String DIALOG_SETTINGS_SEARCH_DIR = "miworkplace.ui.search.remote.directory";
    private static final String DIALOG_SETTINGS_SEARCH_DEPTH = "miworkplace.ui.search.remote.depth";
    private static final String DIALOG_SETTINGS_SEARCH_LIBRARY = "miworkplace.ui.search.remote.txtSearchLibrary";
    private static final String DIALOG_SETTINGS_SEARCH_SOURCE_FILE = "miworkplace.ui.search.remote.txtSearchSourceFile";
    private static final String DIALOG_SETTINGS_SEARCH_MEMBER = "miworkplace.ui.search.remote.txtSearchMember";
    private static final String DIALOG_SETTINGS_CASE_SENSITIVE = "miworkplace.ui.search.remote.caseSensitive";
    private static final String DIALOG_SETTINGS_SEARCH_ENGINE = "miworkplace.ui.search.remote.searchengine";
    private static final String DIALOG_SETTINGS_COLUMNS_ALL = "miworkplace.ui.search.remote.columns.all";
    private static final String DIALOG_SETTINGS_COLUMNS_RANGE = "miworkplace.ui.search.remote.columns.range";
    private static final String DIALOG_SETTINGS_COLUMNS_RANGE_FROM = "miworkplace.ui.search.remote.columns.range.from";
    private static final String DIALOG_SETTINGS_COLUMNS_RANGE_TO = "miworkplace.ui.search.remote.columns.range.to";
    static final String SEARCH_UNTIL_RECORD_LENGTH = "*END";
    static final int SEARCH_UNTIL_RECORD_LENGTH_VALUE = 100;
    private Composite container;
    private Combo cmbConnection;
    private Button fEngineOldGrep;
    private Button fEnginePDM;
    private Combo cmbSearchString;
    private Text fSearchDirectory;
    private Text txtSearchLibrary;
    private Text txtSearchSourceFile;
    private Text txtSearchMember;
    private Button chkCaseSensitive;
    private Button radioColumnScopeAll;
    private Button radioColumnScopeUserDefined;
    private Text columnRangeFrom;
    private Combo columnRangeTo;
    private boolean valueCaseSensitive = false;
    private String valueConnectionName = "";
    private int valueSearchEngine = 1;
    private String valueDirectory = "";
    private int valueDepth = 0;
    private String valueLibrary = "";
    private String valueSourceFile = "*ALL";
    private String valueMember = "*ALL";
    private boolean valueColumnsAll = true;
    private boolean valueColumnsUserDef = false;
    private String valueColumnFrom = "1";
    private String valueColumnTo = String.valueOf(100);
    private final String tooltipConnection = Messages.search_choose_conn;
    private final String tooltipLibrary = Messages.search_lib_ttt;
    private final String tooltipFile = Messages.search_file_ttt;
    private final String tooltipMember = Messages.search_member_ttt;
    private static List<String> fpreviousSearches = new ArrayList<String>();
    private RemoteSearchQuery query;
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private EHelpService fHelpService;
    private MPart part;
    private Button okButton;
    private IRemoteObject fSelectedRemoteObject;
    private Label flabel;
    private Spinner fDepthSpinner;
    private Label flabel_1;
    private IConnection fSelectedConnection;
    private Button fEngineNewGrep;

    @Inject
    public RemoteSearchDialog(@Named(value="activeShell") Shell shell, @Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        super(shell);
        if (selection != null && selection.getFirstElement() instanceof IRemoteObject) {
            this.fSelectedRemoteObject = (IRemoteObject)selection.getFirstElement();
        } else if (selection != null && selection.getFirstElement() instanceof IConnection) {
            this.fSelectedConnection = (IConnection)selection.getFirstElement();
        }
    }

    @PostConstruct
    private void postConstruct(MPart part) {
        this.part = part;
        Map persistedState = part.getPersistedState();
        this.loadSettings(persistedState);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.search_dialog_title);
        this.setMessage(Messages.search_dialog_desc);
        this.setTitleImage(Factory.create((Widget)parent, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/icons/search-wizard.png")));
        parent.getShell().setText(Messages.search_dialog_title);
        Composite p = (Composite)super.createDialogArea(parent);
        this.container = new Composite(p, 0);
        this.container.setLayout((Layout)new GridLayout(2, false));
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblSearchString = new Label(this.container, 0);
        lblSearchString.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblSearchString.setText(Messages.search_dialog_searchexp);
        new Label(this.container, 0);
        this.cmbSearchString = new Combo(this.container, 2048);
        this.cmbSearchString.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbSearchString.setTextLimit(50);
        if (!fpreviousSearches.isEmpty()) {
            this.cmbSearchString.setItems(fpreviousSearches.toArray(new String[0]));
            this.cmbSearchString.setText(this.cmbSearchString.getItem(0));
        }
        this.cmbSearchString.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                RemoteSearchDialog.this.okButton.setEnabled(!RemoteSearchDialog.this.cmbSearchString.getText().trim().isEmpty());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.chkCaseSensitive = new Button(this.container, 32);
        this.chkCaseSensitive.setText(Messages.search_dialog_case);
        this.chkCaseSensitive.setSelection(false);
        this.chkCaseSensitive.setSelection(this.valueCaseSensitive);
        Label lblConnection = new Label(this.container, 0);
        lblConnection.setText(Messages.search_dialog_conn);
        lblConnection.setToolTipText(this.tooltipConnection);
        new Label(this.container, 0);
        this.cmbConnection = new Combo(this.container, 8);
        this.cmbConnection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbConnection.setItems(this.getConnectionNames());
        this.cmbConnection.setToolTipText(this.tooltipConnection);
        this.createEngineGroupd((Control)this.cmbConnection);
        Group searchGroup = this.createSearchGroups((Control)this.cmbConnection);
        this.createColumnGroup((Control)searchGroup);
        if (this.cmbConnection.indexOf(this.valueConnectionName) >= 0) {
            this.cmbConnection.select(this.cmbConnection.indexOf(this.valueConnectionName));
        } else {
            this.cmbConnection.select(0);
        }
        this.fEnginePDM.setSelection(this.valueSearchEngine == 1);
        this.fEnginePDM.addListener(13, e -> this.setEnabled());
        this.fEngineOldGrep.setSelection(this.valueSearchEngine == 2);
        this.fEngineOldGrep.addListener(13, e -> this.setEnabled());
        this.fEngineNewGrep.setSelection(this.valueSearchEngine == 3);
        this.fEngineNewGrep.addListener(13, e -> this.setEnabled());
        this.fSearchDirectory.setText(this.valueDirectory);
        this.fDepthSpinner.setSelection(this.valueDepth);
        this.txtSearchLibrary.setText(this.valueLibrary);
        this.txtSearchSourceFile.setText(this.valueSourceFile);
        this.txtSearchMember.setText(this.valueMember);
        if (this.valueColumnsAll || this.valueColumnsUserDef) {
            this.radioColumnScopeAll.setSelection(this.valueColumnsAll);
            this.radioColumnScopeUserDefined.setSelection(this.valueColumnsUserDef);
        } else {
            this.radioColumnScopeAll.setSelection(true);
        }
        this.columnRangeFrom.setText(this.valueColumnFrom);
        this.columnRangeTo.setText(this.valueColumnTo);
        this.cmbSearchString.setFocus();
        this.setEnabled();
        this.fHelpService.setHelp((Object)p, "miworkplace.help.MIW: Remote Search");
        return p;
    }

    private String[] getConnectionNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            names.add(connection.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    private Group createSearchGroups(Control control) {
        Group searchGroupDir = new Group(control.getParent(), 32);
        searchGroupDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        searchGroupDir.setText(Messages.search_dialog_search_dir);
        searchGroupDir.setLayout((Layout)new GridLayout(3, false));
        Label lblDirectory = new Label((Composite)searchGroupDir, 0);
        lblDirectory.setText(Messages.search_dialog_dir);
        this.fSearchDirectory = new Text((Composite)searchGroupDir, 2048);
        this.fSearchDirectory.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fSearchDirectory.addModifyListener(e -> this.setEnabled());
        this.flabel = new Label((Composite)searchGroupDir, 0);
        this.flabel.setText(Messages.search_dialog_depth);
        this.fDepthSpinner = new Spinner((Composite)searchGroupDir, 2048);
        this.fDepthSpinner.setMaximum(99);
        this.fDepthSpinner.setMinimum(-1);
        this.fDepthSpinner.setSelection(1);
        this.flabel_1 = new Label((Composite)searchGroupDir, 0);
        this.flabel_1.setText(Messages.search_dialog_depth_help);
        Group searchGroupSrcf = new Group(control.getParent(), 32);
        searchGroupSrcf.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        searchGroupSrcf.setText(Messages.search_dialog_search_srcf);
        searchGroupSrcf.setLayout((Layout)new GridLayout(3, false));
        Label lblSearchLibrary = new Label((Composite)searchGroupSrcf, 0);
        lblSearchLibrary.setText(Messages.search_dialog_lib);
        lblSearchLibrary.setToolTipText(this.tooltipLibrary);
        this.txtSearchLibrary = new Text((Composite)searchGroupSrcf, 2048);
        this.txtSearchLibrary.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtSearchLibrary.setTextLimit(10);
        this.txtSearchLibrary.setToolTipText(this.tooltipLibrary);
        this.txtSearchLibrary.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        Label lblSearchFile = new Label((Composite)searchGroupSrcf, 0);
        lblSearchFile.setText(Messages.search_dialog_file);
        lblSearchFile.setToolTipText(this.tooltipFile);
        this.txtSearchSourceFile = new Text((Composite)searchGroupSrcf, 2048);
        this.txtSearchSourceFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtSearchSourceFile.setTextLimit(10);
        this.txtSearchSourceFile.setToolTipText(this.tooltipFile);
        this.txtSearchSourceFile.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        Label lblSearchMember = new Label((Composite)searchGroupSrcf, 0);
        lblSearchMember.setText(Messages.search_dialog_member);
        lblSearchMember.setToolTipText(this.tooltipMember);
        this.txtSearchMember = new Text((Composite)searchGroupSrcf, 2048);
        this.txtSearchMember.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtSearchMember.setTextLimit(10);
        this.txtSearchMember.setToolTipText(this.tooltipMember);
        this.txtSearchMember.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        return searchGroupSrcf;
    }

    private void setEnabled() {
        this.fSearchDirectory.setEnabled(!this.fEnginePDM.getSelection());
        this.fDepthSpinner.setEnabled(!this.fSearchDirectory.getText().isEmpty());
        this.txtSearchLibrary.setEnabled(this.fSearchDirectory.getText().isEmpty() && (this.fEnginePDM.getSelection() || this.fEngineOldGrep.getSelection()));
        this.txtSearchSourceFile.setEnabled(this.fSearchDirectory.getText().isEmpty() && (this.fEnginePDM.getSelection() || this.fEngineOldGrep.getSelection()));
        this.txtSearchMember.setEnabled(this.fSearchDirectory.getText().isEmpty() && (this.fEnginePDM.getSelection() || this.fEngineOldGrep.getSelection()));
        this.radioColumnScopeAll.setEnabled(this.fEnginePDM.getSelection());
        this.radioColumnScopeUserDefined.setEnabled(this.fEnginePDM.getSelection());
        this.enableColumnrange(this.radioColumnScopeUserDefined.getSelection() && this.fEnginePDM.getSelection());
    }

    private void enableColumnrange(boolean pEnabled) {
        this.columnRangeFrom.setEnabled(pEnabled);
        this.columnRangeTo.setEnabled(pEnabled);
    }

    private Group createEngineGroupd(Control control) {
        Group engineGroup = new Group(control.getParent(), 32);
        engineGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        engineGroup.setText(Messages.search_dialog_engine);
        engineGroup.setLayout((Layout)new GridLayout(5, false));
        this.fEnginePDM = new Button((Composite)engineGroup, 16);
        this.fEnginePDM.setText("FNDSTRPDM");
        this.fEnginePDM.addListener(13, e -> this.setEnabled());
        new Label((Composite)engineGroup, 0);
        this.fEngineOldGrep = new Button((Composite)engineGroup, 16);
        this.fEngineOldGrep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.fEngineOldGrep.setText("/usr/bin/grep");
        new Label((Composite)engineGroup, 0);
        this.fEngineNewGrep = new Button((Composite)engineGroup, 16);
        this.fEngineNewGrep.setText("/QOpenSys/pkgs/bin/grep");
        return engineGroup;
    }

    private Group createColumnGroup(Control previousControl) {
        Group columnGroup = new Group(previousControl.getParent(), 32);
        columnGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        columnGroup.setText(Messages.search_dialog_scope);
        columnGroup.setLayout((Layout)new GridLayout(5, false));
        this.radioColumnScopeAll = new Button((Composite)columnGroup, 16);
        this.radioColumnScopeAll.setSelection(true);
        this.radioColumnScopeAll.addListener(13, e -> this.enableColumnrange(!this.radioColumnScopeAll.getSelection()));
        this.radioColumnScopeAll.setText(Messages.search_dialog_allcols);
        this.radioColumnScopeUserDefined = new Button((Composite)columnGroup, 16);
        this.radioColumnScopeUserDefined.setText(Messages.search_dialog_from);
        this.columnRangeFrom = new Text((Composite)columnGroup, 2048);
        GridData gd_columnRangeFrom = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_columnRangeFrom.widthHint = 50;
        this.columnRangeFrom.setLayoutData((Object)gd_columnRangeFrom);
        this.columnRangeFrom.setText(COL_1);
        this.columnRangeFrom.addVerifyListener((VerifyListener)new NumericVerifyListener());
        Label to = new Label((Composite)columnGroup, 0);
        to.setText(Messages.search_dialog_to);
        this.columnRangeTo = new Combo((Composite)columnGroup, 64);
        this.columnRangeTo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 2));
        this.columnRangeTo.setItems(new String[]{SEARCH_UNTIL_RECORD_LENGTH});
        this.columnRangeTo.select(0);
        this.columnRangeTo.addVerifyListener((VerifyListener)new ColumnRangeToVerifyListener());
        new Label((Composite)columnGroup, 0);
        new Label((Composite)columnGroup, 0);
        new Label((Composite)columnGroup, 0);
        new Label((Composite)columnGroup, 0);
        return columnGroup;
    }

    public RemoteSearchQuery getQuery() {
        return this.query;
    }

    private RemoteSearchQuery buildQuery() {
        RemoteSearchQuery query = this.radioColumnScopeAll.getSelection() ? new RemoteSearchQuery(this.connectionManager.get(this.cmbConnection.getText()), this.cmbSearchString.getText(), this.getEngineValue(), this.fSearchDirectory.getText(), this.fDepthSpinner.getSelection(), this.txtSearchLibrary.getText(), this.txtSearchSourceFile.getText(), this.txtSearchMember.getText(), this.chkCaseSensitive.getSelection()) : new RemoteSearchQuery(this.connectionManager.get(this.cmbConnection.getText()), this.cmbSearchString.getText(), this.getEngineValue(), this.fSearchDirectory.getText(), this.fDepthSpinner.getSelection(), this.txtSearchLibrary.getText(), this.txtSearchSourceFile.getText(), this.txtSearchMember.getText(), this.chkCaseSensitive.getSelection(), Integer.valueOf(this.columnRangeFrom.getText()), Integer.valueOf(this.columnRangeTo.getText()));
        ContextInjectionFactory.inject((Object)query, (IEclipseContext)this.context);
        return query;
    }

    private int getEngineValue() {
        return this.fEnginePDM.getSelection() ? 1 : (this.fEngineOldGrep.getSelection() ? 2 : 3);
    }

    private void loadSettings(Map<String, String> persistedState) {
        this.valueCaseSensitive = Boolean.parseBoolean(persistedState.get(DIALOG_SETTINGS_CASE_SENSITIVE));
        this.valueSearchEngine = Integer.parseInt(persistedState.getOrDefault(DIALOG_SETTINGS_SEARCH_ENGINE, COL_1));
        this.valueColumnFrom = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_COLUMNS_RANGE_FROM), (String)COL_1);
        this.valueColumnTo = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_COLUMNS_RANGE_TO), (String)COL_100);
        this.valueColumnsAll = Boolean.parseBoolean(persistedState.get(DIALOG_SETTINGS_COLUMNS_ALL));
        this.valueColumnsUserDef = Boolean.parseBoolean(persistedState.get(DIALOG_SETTINGS_COLUMNS_RANGE));
        this.valueConnectionName = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_CONNECTION_NAME));
        this.valueDirectory = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_SEARCH_DIR), (String)EMPTY);
        this.valueDepth = Integer.parseInt(persistedState.getOrDefault(DIALOG_SETTINGS_SEARCH_DEPTH, COL_1));
        this.valueLibrary = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_SEARCH_LIBRARY), (String)EMPTY);
        this.valueSourceFile = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_SEARCH_SOURCE_FILE), (String)ALL);
        this.valueMember = StringUtils.defaultString((String)persistedState.get(DIALOG_SETTINGS_SEARCH_MEMBER), (String)ALL);
        if (this.fSelectedRemoteObject instanceof Library) {
            this.valueSearchEngine = this.valueSearchEngine == 3 ? 2 : this.valueSearchEngine;
            this.valueDirectory = EMPTY;
            this.valueLibrary = this.fSelectedRemoteObject.getName();
            this.valueSourceFile = ALL;
            this.valueMember = ALL;
        } else if (this.fSelectedRemoteObject instanceof SourceMember) {
            this.valueSearchEngine = this.valueSearchEngine == 3 ? 2 : this.valueSearchEngine;
            SourceMember mbr = (SourceMember)this.fSelectedRemoteObject;
            this.valueDirectory = EMPTY;
            this.valueLibrary = mbr.getLibrary();
            this.valueSourceFile = mbr.getSourceFile();
            this.valueMember = mbr.getName();
        } else if (this.fSelectedRemoteObject instanceof SourceFile) {
            this.valueSearchEngine = this.valueSearchEngine == 3 ? 2 : this.valueSearchEngine;
            SourceFile sf = (SourceFile)this.fSelectedRemoteObject;
            this.valueDirectory = EMPTY;
            this.valueLibrary = sf.getLibrary();
            this.valueSourceFile = sf.getName();
            this.valueMember = ALL;
        } else if (this.fSelectedRemoteObject instanceof StreamFile) {
            this.valueSearchEngine = this.valueSearchEngine == 1 ? 3 : this.valueSearchEngine;
            StreamFile sf = (StreamFile)this.fSelectedRemoteObject;
            this.valueDirectory = sf.getPath();
            this.valueLibrary = EMPTY;
            this.valueSourceFile = EMPTY;
            this.valueMember = EMPTY;
        } else if (this.fSelectedConnection != null) {
            this.valueDirectory = EMPTY;
            this.valueLibrary = ALL;
            this.valueSourceFile = ALL;
            this.valueMember = ALL;
            this.valueConnectionName = this.fSelectedConnection.getName();
        }
    }

    private void saveSettings(Map<String, String> persistedState) {
        persistedState.put(DIALOG_SETTINGS_SEARCH_ENGINE, EMPTY + this.getEngineValue());
        persistedState.put(DIALOG_SETTINGS_COLUMNS_ALL, Boolean.valueOf(this.radioColumnScopeAll.getSelection()).toString());
        persistedState.put(DIALOG_SETTINGS_COLUMNS_RANGE, Boolean.valueOf(this.radioColumnScopeUserDefined.getSelection()).toString());
        persistedState.put(DIALOG_SETTINGS_COLUMNS_RANGE_FROM, StringUtils.defaultString((String)this.columnRangeFrom.getText()));
        persistedState.put(DIALOG_SETTINGS_COLUMNS_RANGE_TO, StringUtils.defaultString((String)this.columnRangeTo.getText()));
        persistedState.put(DIALOG_SETTINGS_CASE_SENSITIVE, Boolean.valueOf(this.chkCaseSensitive.getSelection()).toString());
        persistedState.put(DIALOG_SETTINGS_CONNECTION_NAME, StringUtils.defaultString((String)this.cmbConnection.getText()));
        persistedState.put(DIALOG_SETTINGS_SEARCH_DIR, StringUtils.defaultString((String)this.fSearchDirectory.getText()));
        persistedState.put(DIALOG_SETTINGS_SEARCH_DEPTH, EMPTY + this.fDepthSpinner.getSelection());
        persistedState.put(DIALOG_SETTINGS_SEARCH_LIBRARY, StringUtils.defaultString((String)this.txtSearchLibrary.getText()));
        persistedState.put(DIALOG_SETTINGS_SEARCH_MEMBER, StringUtils.defaultString((String)this.txtSearchMember.getText()));
        persistedState.put(DIALOG_SETTINGS_SEARCH_SOURCE_FILE, StringUtils.defaultString((String)this.txtSearchSourceFile.getText()));
    }

    protected void okPressed() {
        if (this.cmbConnection.getSelectionIndex() == -1) {
            Notifier.warn((String)Messages.search_dialog_title, (String)Messages.search_dialog_error_noopenconn);
            return;
        }
        fpreviousSearches.remove(this.cmbSearchString.getText());
        fpreviousSearches.add(0, this.cmbSearchString.getText());
        this.query = this.buildQuery();
        this.saveSettings(this.part.getPersistedState());
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            this.okButton = super.createButton(parent, id, label, defaultButton);
            this.okButton.setEnabled(!fpreviousSearches.isEmpty());
            return this.okButton;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }
}

