/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ui.util;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultipleSelectionCombo
extends Composite {
    private Shell floatShell = null;
    private Text displayText = null;
    private List list = null;
    private String[] comboItems = null;
    private int[] comboSelection = null;

    public MultipleSelectionCombo(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void setEnabled(boolean enabled) {
        this.displayText.setEnabled(enabled);
    }

    public Text getTextWidget() {
        return this.displayText;
    }

    public void setText(String text) {
        this.displayText.setText(text);
    }

    public String getText() {
        return this.displayText.getText();
    }

    public void setItems(String[] items) {
        this.setItems(items, new int[0]);
    }

    public void setItems(String[] items, int[] selected) {
        this.comboItems = items;
        this.comboSelection = selected;
        this.displayText();
    }

    private void init() {
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.displayText = new Text((Composite)this, 2048);
        this.displayText.setLayoutData((Object)new GridData(768));
        this.displayText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                super.mouseDown(event);
                MultipleSelectionCombo.this.initFloatShell();
            }
        });
    }

    private void initFloatShell() {
        Point p = this.displayText.getParent().toDisplay(this.displayText.getLocation());
        Point size = this.displayText.getSize();
        Rectangle shellRect = new Rectangle(p.x, p.y + size.y, size.x, 0);
        this.floatShell = new Shell(this.getShell(), 8);
        GridLayout gl = new GridLayout();
        gl.marginBottom = 2;
        gl.marginTop = 2;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.floatShell.setLayout((Layout)gl);
        this.list = new List((Composite)this.floatShell, 2818);
        String[] stringArray = this.comboItems;
        int n = this.comboItems.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.list.add(value);
            ++n2;
        }
        this.list.setSelection(this.comboSelection);
        GridData gd = new GridData(4, 4, true, true);
        this.list.setLayoutData((Object)gd);
        int height = this.list.getItemCount() * 30;
        this.floatShell.setSize(shellRect.width, height <= 150 ? height : 110);
        this.floatShell.setLocation(shellRect.x, shellRect.y);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                MultipleSelectionCombo.this.comboSelection = MultipleSelectionCombo.this.list.getSelectionIndices();
                if ((e.stateMask & 0x40000) == 0) {
                    MultipleSelectionCombo.this.floatShell.dispose();
                    MultipleSelectionCombo.this.displayText();
                }
            }
        });
        this.floatShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                if (MultipleSelectionCombo.this.floatShell != null && !MultipleSelectionCombo.this.floatShell.isDisposed()) {
                    MultipleSelectionCombo.this.comboSelection = MultipleSelectionCombo.this.list.getSelectionIndices();
                    MultipleSelectionCombo.this.displayText();
                    MultipleSelectionCombo.this.floatShell.dispose();
                }
            }
        });
        this.floatShell.open();
    }

    private void displayText() {
        if (this.comboSelection != null && this.comboSelection.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.comboSelection.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.comboItems[this.comboSelection[i]]);
                ++i;
            }
            this.displayText.setText(sb.toString());
        } else {
            this.displayText.setText("");
        }
    }
}

