/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.text;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import miworkplace.common.Constants;
import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.cl.text.BifCompletionProposal;
import miworkplace.ui.editor.cl.text.KeywordCompletionProposal;
import org.osgi.service.log.LogService;

public class CompletionProposalFactory {
    private final LogService logger;
    private Constants.ContentAssistCase caCase;
    private List<AbstractCompletionProposal> bifs = new ArrayList<AbstractCompletionProposal>();
    private List<AbstractCompletionProposal> keywords = new ArrayList<AbstractCompletionProposal>();

    public CompletionProposalFactory(LogService logger, Constants.ContentAssistCase caCase) {
        this.logger = logger;
        this.caCase = caCase;
        this.loadCompletionProposals();
    }

    public List<AbstractCompletionProposal> getCompletionProposals() {
        ArrayList<AbstractCompletionProposal> proposals = new ArrayList<AbstractCompletionProposal>();
        proposals.addAll(this.bifs);
        proposals.addAll(this.keywords);
        return proposals;
    }

    private void loadCompletionProposals() {
        this.loadBifsCompletionProposals();
        this.loadKeywordCompletionProposals();
    }

    private void loadBifsCompletionProposals() {
        this.bifs.clear();
        InputStream in = this.getClass().getResourceAsStream("syntax_highlighting.properties");
        Properties properties = new Properties();
        try {
            String[] bifNames;
            properties.load(in);
            String property = properties.getProperty("miworkplace.ui.editor.cl.bifs");
            String[] stringArray = bifNames = property.split(",");
            int n = bifNames.length;
            int n2 = 0;
            while (n2 < n) {
                String bif = stringArray[n2];
                if (this.caCase != null) {
                    bif = this.caCase == Constants.ContentAssistCase.uppercase ? bif.toUpperCase() : bif.toLowerCase();
                }
                this.bifs.add(new BifCompletionProposal(bif.trim()));
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadKeywordCompletionProposals() {
        this.keywords.clear();
        InputStream in = this.getClass().getResourceAsStream("syntax_highlighting.properties");
        Properties properties = new Properties();
        try {
            String k;
            String[] keywords;
            properties.load(in);
            String property = properties.getProperty("miworkplace.ui.editor.cl.keywords");
            String[] stringArray = keywords = property.split(",");
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                k = stringArray[n2];
                if (this.caCase != null) {
                    k = this.caCase == Constants.ContentAssistCase.uppercase ? k.toUpperCase() : k.toLowerCase();
                }
                this.keywords.add(new KeywordCompletionProposal(k.trim()));
                ++n2;
            }
            property = properties.getProperty("miworkplace.ui.editor.cl.logic");
            stringArray = keywords = property.split(",");
            n = keywords.length;
            n2 = 0;
            while (n2 < n) {
                k = stringArray[n2];
                if (this.caCase != null) {
                    k = this.caCase == Constants.ContentAssistCase.uppercase ? k.toUpperCase() : k.toLowerCase();
                }
                this.keywords.add(new KeywordCompletionProposal(k.trim()));
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

