/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.Task;
import miworkplace.common.model.Tasklist;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Ast;
import miworkplace.ui.editor.cl.ast.Comment;
import miworkplace.ui.editor.cl.ast.Statement;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.service.event.Event;

public class TasklistAdapter
implements IAdaptable {
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    @Preference(nodePath="miworkplace.application")
    protected IEclipsePreferences applicationPreferences;
    private String memberPath;
    private Ast ast;

    @PostConstruct
    private void postConstruct() {
        this.memberPath = EditorInputUriUtil.getMemberPath((String)this.inputUri);
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        if (event.containsProperty("inputUri")) {
            String astInputUri = event.getProperty("inputUri").toString();
            Object eventData = event.getProperty("org.eclipse.e4.data");
            if (this.inputUri.equals(astInputUri)) {
                this.ast = eventData != null && eventData instanceof Ast ? (Ast)eventData : null;
            }
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Tasklist.class && this.ast != null) {
            Tasklist tasklist = new Tasklist();
            tasklist.editorUri = this.inputUri;
            tasklist.tasks = this.buildTasks(this.ast);
            return tasklist;
        }
        return null;
    }

    private Task[] buildTasks(Ast ast) {
        boolean caseSensitive = this.applicationPreferences.getBoolean("miworkplace.ui.editor.tasktags.casesensitive", false);
        String taskTags = this.applicationPreferences.get("miworkplace.ui.editor.tasktags", "TODO,FIXME");
        if (StringUtils.isBlank((CharSequence)taskTags)) {
            return new Task[0];
        }
        LinkedList<Task> tasks = new LinkedList<Task>();
        ArrayList<String> quotedTags = new ArrayList<String>();
        String[] stringArray = taskTags.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String taskTag = stringArray[n2];
            quotedTags.add(Pattern.quote(taskTag));
            ++n2;
        }
        Pattern pattern = caseSensitive ? Pattern.compile("\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 64) : Pattern.compile("\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 66);
        List comments = ast.listComments();
        if (comments != null) {
            for (Comment comment : comments) {
                List<String> commentLines = this.buildCommentLines(comment);
                int i = 0;
                for (String line : commentLines) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        int end = matcher.end(1);
                        if (line.length() == end) {
                            tasks.add(new Task(line.substring(end).trim(), this.memberPath, this.inputUri, comment.getStart().line + 1 + i));
                        } else {
                            char followingChar = line.charAt(end);
                            if (followingChar == ' ' || followingChar == ':') {
                                Task task = new Task(line.substring(end).trim(), this.memberPath, this.inputUri, comment.getStart().line + 1 + i);
                                tasks.add(task);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return tasks.toArray(new Task[tasks.size()]);
    }

    private List<String> buildCommentLines(Comment comment) {
        if (comment.getStart().line == comment.getEnd().line) {
            return Arrays.asList(comment.toString());
        }
        ArrayList<String> lines = new ArrayList<String>();
        Statement statement = comment.getStatement();
        if (statement.list().isEmpty()) {
            return lines;
        }
        int line = comment.getStart().line;
        StringBuilder sb = new StringBuilder();
        for (AbstractToken token : statement.list()) {
            if (token.line != line) {
                lines.add(StringUtils.stripEnd((String)sb.toString(), (String)" +"));
                sb.setLength(0);
                line = token.line;
            }
            sb.append(token.value);
            sb.append(" ");
        }
        return lines;
    }
}

