/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.openssl.PEMWriter;

public class RsaSignAndVerifyText {
    private static final String RSA = "RSA";

    public static byte[] rsaEncrypt(String plainText, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, privateKey);
        return cipher.doFinal(plainText.getBytes());
    }

    public static byte[] rsaEncrypt(byte[] plainText, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, privateKey);
        return cipher.doFinal(plainText);
    }

    public static String rsaDecrypt(byte[] cipherText, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, publicKey);
        byte[] result = cipher.doFinal(cipherText);
        return new String(result);
    }

    public static String rsaDecrypt(byte[] cipherText, PublicKey publicKey, Charset charSet) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, publicKey);
        byte[] result = cipher.doFinal(cipherText);
        if (charSet != null) {
            return new String(result, charSet);
        }
        return new String(result);
    }

    private static KeyPair generateRSAKkeyPair(int keySize) throws NoSuchAlgorithmException {
        SecureRandom secureRandom = new SecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(keySize, secureRandom);
        return keyPairGenerator.generateKeyPair();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(2048, new SecureRandom());
        PrivateKey privateKey = keyPairGenerator.genKeyPair().getPrivate();
        StringWriter writer = new StringWriter();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PEMWriter pemWriter = new PEMWriter((Writer)writer);){
            pemWriter.writeObject((Object)privateKey);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String privateKeyStr = writer.toString();
        System.out.println(privateKeyStr);
        com.jcraft.jsch.KeyPair.load(null, (byte[])privateKeyStr.getBytes("US-ASCII"), null);
        KeyPair keypair = RsaSignAndVerifyText.generateRSAKkeyPair(2048);
        String plainText = "PlainText encrypted using RSA private key.";
        System.out.print("Text to encrypt: " + plainText);
        byte[] cipherText = RsaSignAndVerifyText.rsaEncrypt(plainText, keypair.getPrivate());
        String decryptedText = RsaSignAndVerifyText.rsaDecrypt(cipherText, keypair.getPublic());
        System.out.println("Decrypted text: " + decryptedText);
    }
}

