/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;

public class JreSignDataFile {
    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("generate digital signature.");
            System.err.println("usage: java algo pvtKeyFile dataFile signFile");
            System.exit(1);
        }
        int index = 0;
        String cfr_ignored_0 = args[index];
        String keyFile = args[++index];
        String dataFile = args[++index];
        String signFile = args[++index];
        ++index;
        Path path = Paths.get(keyFile, new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey pvt = kf.generatePrivate(ks);
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initSign(pvt);
        try (FileInputStream in = null;){
            int len;
            in = new FileInputStream(dataFile);
            byte[] buf = new byte[2048];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                sign.update(buf, 0, len);
            }
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(signFile);
            byte[] signature = sign.sign();
            ((OutputStream)out).write(signature);
        }
    }
}

