/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.ssl.X509Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JDKDSAPublicKey;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateInfo {
    private static final Logger logger = LoggerFactory.getLogger(CertificateInfo.class);
    public static final int DIGITALSIGNATURE = 0;
    public static final int NONREPUDIATION = 1;
    public static final int KEYENCIPHERMENT = 2;
    public static final int DATAENCIPHERMENT = 3;
    public static final int KEYAGREEMENT = 4;
    public static final int KEYCERTSIGN = 5;
    public static final int CRLSIGN = 6;
    public static final int ENCIPHERONLY = 7;
    public static final int DECIPHERONLY = 8;
    public static final String[] KEYUSAGETEXTS = new String[]{"DIGITALSIGNATURE", "NONREPUDIATION", "KEYENCIPHERMENT", "DATAENCIPHERMENT", "KEYAGREEMENT", "KEYCERTSIGN", "CRLSIGN", "ENCIPHERONLY", "DECIPHERONLY"};
    public static final int ANYEXTENDEDKEYUSAGE = 0;
    public static final int SERVERAUTH = 1;
    public static final int CLIENTAUTH = 2;
    public static final int CODESIGNING = 3;
    public static final int EMAILPROTECTION = 4;
    public static final int IPSECENDSYSTEM = 5;
    public static final int IPSECTUNNEL = 6;
    public static final int IPSECUSER = 7;
    public static final int TIMESTAMPING = 8;
    public static final int SMARTCARDLOGON = 9;
    public static final int OCSPSIGNING = 10;
    public static final String[] EXTENDEDKEYUSAGEOIDSTRINGS = new String[]{"1.3.6.1.5.5.7.3.0", "1.3.6.1.5.5.7.3.1", "1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.3", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.5", "1.3.6.1.5.5.7.3.6", "1.3.6.1.5.5.7.3.7", "1.3.6.1.5.5.7.3.8", "1.3.6.1.4.1.311.20.2.2", "1.3.6.1.5.5.7.3.9"};
    public static final String[] EXTENDEDKEYUSAGETEXTS = new String[]{"ANYEXTENDEDKEYUSAGE", "SERVERAUTH", "CLIENTAUTH", "CODESIGNING", "EMAILPROTECTION", "IPSECENDSYSTEM", "IPSECTUNNEL", "IPSECUSER", "TIMESTAMPING", "SMARTCARDLOGON", "OCSPSIGNER"};
    private static final int SUBALTNAME_OTHERNAME = 0;
    private static final int SUBALTNAME_RFC822NAME = 1;
    private static final int SUBALTNAME_DNSNAME = 2;
    private static final int SUBALTNAME_X400ADDRESS = 3;
    private static final int SUBALTNAME_DIRECTORYNAME = 4;
    private static final int SUBALTNAME_EDIPARTYNAME = 5;
    private static final int SUBALTNAME_URI = 6;
    private static final int SUBALTNAME_IPADDRESS = 7;
    private static final int SUBALTNAME_REGISTREDID = 8;
    public static final String UPN = "upn";
    public static final String UPN_OBJECTID = "1.3.6.1.4.1.311.20.2.3";
    public static final String GUID = "guid";
    public static final String GUID_OBJECTID = "1.3.6.1.4.1.311.25.1";
    private static DateFormat completedateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static DateFormat simpledateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private X509Certificate certificate;
    private X509Principal subjectdnfieldextractor;
    private X509Principal issuerdnfieldextractor;
    private String subjectaltnamestring;
    private String subjectdirattrstring;
    private static HashMap<String, String> extendedkeyusageoidtotextmap;

    public CertificateInfo(X509Certificate x509Cert) {
        this.certificate = x509Cert;
        this.subjectdnfieldextractor = new X509Principal(x509Cert.getSubjectDN().getName());
        this.issuerdnfieldextractor = new X509Principal(x509Cert.getIssuerDN().getName());
        if (extendedkeyusageoidtotextmap == null) {
            extendedkeyusageoidtotextmap = new HashMap();
            int i = 0;
            while (i < EXTENDEDKEYUSAGETEXTS.length) {
                extendedkeyusageoidtotextmap.put(EXTENDEDKEYUSAGEOIDSTRINGS[i], EXTENDEDKEYUSAGETEXTS[i]);
                ++i;
            }
        }
    }

    public String getSubjectAltName() {
        block21: {
            if (this.subjectaltnamestring == null) {
                try {
                    if (this.certificate.getSubjectAlternativeNames() == null) break block21;
                    this.subjectaltnamestring = "";
                    String separator = "";
                    String guid = null;
                    try {
                        guid = CertificateInfo.getGuidAltName(this.certificate);
                    }
                    catch (Exception e) {
                        this.subjectaltnamestring = e.getMessage();
                    }
                    if (guid != null) {
                        this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "GUID=" + guid;
                        separator = ", ";
                    }
                    String upn = null;
                    try {
                        upn = CertificateInfo.getUPNAltName(this.certificate);
                    }
                    catch (Exception e) {
                        this.subjectaltnamestring = e.getMessage();
                    }
                    if (upn != null) {
                        this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "UPN=" + upn;
                        separator = ", ";
                    }
                    for (List<?> next : this.certificate.getSubjectAlternativeNames()) {
                        int OID = (Integer)next.get(0);
                        switch (OID) {
                            case 0: {
                                Object obj = next.get(1);
                                if (obj == null) break;
                                this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "OtherName=" + obj.toString();
                                separator = ", ";
                                break;
                            }
                            case 1: {
                                this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "RFC822Name=" + (String)next.get(1);
                                separator = ", ";
                                break;
                            }
                            case 2: {
                                this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "DNSName=" + (String)next.get(1);
                                separator = ", ";
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 4: {
                                break;
                            }
                            case 6: {
                                if (!this.subjectaltnamestring.equals("")) {
                                    this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + ", ";
                                }
                                this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "URI=" + (String)next.get(1);
                                separator = ", ";
                                break;
                            }
                            case 7: {
                                this.subjectaltnamestring = String.valueOf(this.subjectaltnamestring) + separator + "IPAddress=" + (String)next.get(1);
                                separator = ", ";
                                break;
                            }
                        }
                    }
                }
                catch (CertificateParsingException e) {
                    this.subjectaltnamestring = e.getMessage();
                }
            }
        }
        return this.subjectaltnamestring;
    }

    public static String getGuidAltName(X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null) {
            Iterator<List<?>> i = altNames.iterator();
            while (i.hasNext()) {
                ASN1ObjectIdentifier id;
                ASN1Sequence seq = CertificateInfo.getAltnameSequence(i.next());
                if (seq == null || !(id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(GUID_OBJECTID)) continue;
                ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(1);
                ASN1OctetString str = ASN1OctetString.getInstance((Object)obj.getObject());
                return new String(Hex.encode((byte[])str.getOctets()));
            }
        }
        return null;
    }

    public static String getUPNAltName(X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null) {
            Iterator<List<?>> i = altNames.iterator();
            while (i.hasNext()) {
                ASN1Sequence seq = CertificateInfo.getAltnameSequence(i.next());
                String ret = CertificateInfo.getUPNStringFromSequence(seq);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private static String getUPNStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(UPN_OBJECTID)) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(1);
            DERUTF8String str = DERUTF8String.getInstance((Object)obj.getObject());
            return str.getString();
        }
        return null;
    }

    private static ASN1Sequence getAltnameSequence(List listitem) {
        Integer no = (Integer)listitem.get(0);
        if (no == 0) {
            byte[] altName = (byte[])listitem.get(1);
            return CertificateInfo.getAltnameSequence(altName);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ASN1Sequence getAltnameSequence(byte[] value) {
        ASN1Primitive oct = null;
        ByteArrayInputStream bais = null;
        bais = new ByteArrayInputStream(value);
        oct = new ASN1InputStream((InputStream)bais).readObject();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)oct);
        bais.close();
        ASN1Sequence aSN1Sequence = seq;
        if (bais == null) return aSN1Sequence;
        try {
            bais.close();
            return aSN1Sequence;
        }
        catch (IOException iOException) {}
        return aSN1Sequence;
        catch (IOException e) {
            try {
                logger.error("Error on getting Alt Name as a DERSEquence : " + e.getLocalizedMessage(), (Throwable)e);
                if (bais == null) return null;
            }
            catch (Throwable throwable) {
                if (bais == null) throw throwable;
                try {
                    bais.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                bais.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static String getKeyUsageAsText(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        String kuText = "";
        boolean[] keyusage = certificate.getKeyUsage();
        if (keyusage == null) {
            return "";
        }
        if (keyusage[0]) {
            kuText = String.valueOf(kuText) + "digitalSignature";
        }
        if (keyusage[1]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "nonRepudiation";
        }
        if (keyusage[2]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "keyEncipherment";
        }
        if (keyusage[3]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "dataEncipherment";
        }
        if (keyusage[4]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "keyAgreement";
        }
        if (keyusage[5]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "keyCertSign";
        }
        if (keyusage[6]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "cRLSign";
        }
        if (keyusage[7]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "encipherOnly";
        }
        if (keyusage[8]) {
            kuText = String.valueOf(kuText) + (kuText.equals("") ? "" : ", ") + "decipherOnly";
        }
        return kuText;
    }

    public static String getNSCertTypeAsText(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        byte[] nct = certificate.getExtensionValue(MiscObjectIdentifiers.netscapeCertType.getId());
        if (nct == null) {
            return "";
        }
        String nctText = "";
        if (nct[0] == 0) {
            nctText = String.valueOf(nctText) + "SSLClient";
        }
        if (nct[1] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "SSLServer";
        }
        if (nct[2] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "S/MIME";
        }
        if (nct[3] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "Object Signing";
        }
        if (nct[4] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "Reserved";
        }
        if (nct[5] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "SSL CA";
        }
        if (nct[6] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "S/MIME CA";
        }
        if (nct[7] == 0) {
            nctText = String.valueOf(nctText) + (nctText.equals("") ? "" : ", ") + "Object Signing CA";
        }
        return nctText;
    }

    public static String getExtendedKeyUsageAsText(X509Certificate certificate) {
        List<String> extendedkeyusage = null;
        HashMap<String, String> extendedkeyusageoidtotextmap = null;
        String[] EXTENDEDKEYUSAGEOIDSTRINGS = new String[]{"2.5.29.37.0", "1.3.6.1.5.5.7.3.0", "1.3.6.1.5.5.7.3.1", "1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.3", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.5", "1.3.6.1.5.5.7.3.6", "1.3.6.1.5.5.7.3.7", "1.3.6.1.5.5.7.3.8", "1.3.6.1.4.1.311.20.2.2", "1.3.6.1.5.5.7.3.9"};
        String[] EXTENDEDKEYUSAGETEXTS = new String[]{"All usages", "All usages", "Server authentication", "Client authentication", "Code signing", "Email protection", "IPSec end system", "IPSec tunnel", "IPSec user", "Timestamping", "Smartcard Logon", "OCSP signer"};
        extendedkeyusageoidtotextmap = new HashMap<String, String>();
        int i = 0;
        while (i < EXTENDEDKEYUSAGETEXTS.length) {
            extendedkeyusageoidtotextmap.put(EXTENDEDKEYUSAGEOIDSTRINGS[i], EXTENDEDKEYUSAGETEXTS[i]);
            ++i;
        }
        try {
            extendedkeyusage = certificate.getExtendedKeyUsage();
        }
        catch (CertificateParsingException e) {
            logger.error("certificate parsing exception" + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        if (extendedkeyusage == null) {
            extendedkeyusage = new ArrayList<String>();
        }
        String returnval = "";
        for (String element : extendedkeyusage) {
            returnval = String.valueOf(returnval) + (returnval.equals("") ? "" : ", ") + (String)extendedkeyusageoidtotextmap.get(element);
        }
        return returnval;
    }

    public static String getSubjectAsShortText(X509Certificate certificate) {
        certificate = X509Util.getBCCertificate(certificate);
        return CertificateInfo.getDNAsShortText(certificate.getSubjectDN());
    }

    public static String getIssuerAsShortText(X509Certificate certificate) {
        certificate = X509Util.getBCCertificate(certificate);
        return CertificateInfo.getDNAsShortText(certificate.getIssuerDN());
    }

    public static String getDNAsShortText(Principal dn) {
        X509Principal X509dn = new X509Principal(dn.getName());
        if (X509dn != null && X509dn.getValues(X509Name.CN).size() > 0) {
            return X509dn.getValues(X509Name.CN).get(0).toString();
        }
        String str_dn = dn.getName();
        int last_equal = str_dn.lastIndexOf("=");
        if (last_equal >= 0) {
            return str_dn.substring(last_equal + 1, str_dn.length());
        }
        return str_dn;
    }

    public static String getNotBeforeAsText(X509Certificate certificate) {
        return simpledateFormat.format(certificate.getNotBefore());
    }

    public static String getNotBeforeAsFullText(X509Certificate certificate) {
        return completedateFormat.format(certificate.getNotBefore());
    }

    public static String getNotAfterAsText(X509Certificate certificate) {
        return simpledateFormat.format(certificate.getNotAfter());
    }

    public static String getNotAfterAsFullText(X509Certificate certificate) {
        return completedateFormat.format(certificate.getNotAfter());
    }

    public static String getPublicKeyInfo(PublicKey pk) {
        int keysize = 0;
        String format = pk.getAlgorithm();
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapk = (RSAPublicKey)pk;
            keysize = (rsapk.getModulus().toByteArray().length - 1) * 8;
        }
        if (pk instanceof JCEECPublicKey) {
            JCEECPublicKey ecpubkey = (JCEECPublicKey)pk;
            keysize = ecpubkey.getQ().getXCoord().getFieldSize();
            format = "ECDSA";
        }
        if (pk instanceof JDKDSAPublicKey) {
            JDKDSAPublicKey dsapubkey = (JDKDSAPublicKey)pk;
            keysize = dsapubkey.getY().bitLength();
        }
        return String.valueOf(format) + " " + keysize + "bits";
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> getSubjectAlternativeNames(X509Certificate certificate) {
        identities = new ArrayList<String>();
        try {
            altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
            for (List<?> item : altNames) {
                block22: {
                    type = (Integer)item.get(0);
                    if (type == 0) {
                        decoder = null;
                        try {
                            decoder = new ASN1InputStream((byte[])item.toArray()[1]);
                            encoded = decoder.readObject();
                            encoded = ((DERSequence)encoded).getObjectAt(1);
                            encoded = ((DERTaggedObject)encoded).getObject();
                            encoded = ((DERTaggedObject)encoded).getObject();
                            identity = ((DERUTF8String)encoded).getString();
                            identities.add(identity);
                        }
                        catch (UnsupportedEncodingException e) {
                            CertificateInfo.logger.error("Error decoding subjectAltName" + e.getLocalizedMessage(), (Throwable)e);
                            if (decoder != null) {
                                try {
                                    decoder.close();
                                }
                                catch (IOException v0) {}
                            }
                            break block22;
                        }
                        catch (Exception e) {
                            try {
                                CertificateInfo.logger.error("Error decoding subjectAltName" + e.getLocalizedMessage(), (Throwable)e);
                                ** if (decoder == null) goto lbl-1000
                            }
                            catch (Throwable var9_12) {
                                if (decoder != null) {
                                    try {
                                        decoder.close();
                                    }
                                    catch (IOException v2) {}
                                }
                                throw var9_12;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    decoder.close();
                                }
                                catch (IOException v1) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block22;
                            }
                        }
                        if (decoder == null) break block22;
                        try {
                            decoder.close();
                        }
                        catch (IOException v3) {}
                    }
                }
                CertificateInfo.logger.warn("SubjectAltName of invalid type found: " + certificate);
            }
        }
        catch (CertificateParsingException e) {
            CertificateInfo.logger.error("Error parsing SubjectAltName in certificate: " + certificate + "\r\nerror:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return identities;
    }

    public String getCDPAsText() {
        DistributionPoint[] cdp = null;
        try {
            cdp = X509Util.getCrlDistributionPoint(this.certificate);
        }
        catch (CertificateParsingException certificateParsingException) {
            logger.error("Error while parsing CDP");
        }
        String returnvalue = "";
        if (cdp != null) {
            DistributionPoint[] distributionPointArray = cdp;
            int n = cdp.length;
            int n2 = 0;
            while (n2 < n) {
                GeneralName[] cdpgn;
                DistributionPoint distributionPoint = distributionPointArray[n2];
                if (!returnvalue.equals("")) {
                    returnvalue = String.valueOf(returnvalue) + System.getProperty("line.separator");
                }
                if (distributionPoint.getCRLIssuer() != null) {
                    returnvalue = String.valueOf(returnvalue) + distributionPoint.getCRLIssuer() + "=";
                }
                GeneralNames cdpgns = GeneralNames.getInstance((Object)distributionPoint.getDistributionPoint().getName());
                GeneralName[] generalNameArray = cdpgn = cdpgns.getNames();
                int n3 = cdpgn.length;
                int n4 = 0;
                while (n4 < n3) {
                    GeneralName element = generalNameArray[n4];
                    returnvalue = String.valueOf(returnvalue) + CertificateInfo.GeneralNameAsText(element);
                    ++n4;
                }
                ++n2;
            }
        }
        return returnvalue;
    }

    public static String GeneralNameAsText(GeneralName gn) {
        StringBuffer buf = new StringBuffer();
        int tag = gn.getTagNo();
        ASN1Encodable obj = gn.getName();
        switch (tag) {
            case 1: {
                buf.append("rfc822Name=");
                buf.append(DERIA5String.getInstance((Object)obj).getString());
                break;
            }
            case 2: {
                buf.append("dNSName=");
                buf.append(DERIA5String.getInstance((Object)obj).getString());
                break;
            }
            case 6: {
                buf.append("URI=");
                buf.append(DERIA5String.getInstance((Object)obj).getString());
                break;
            }
            case 4: {
                buf.append("directoryName=");
                buf.append(X509Name.getInstance((Object)obj).toString());
                break;
            }
            case 5: {
                buf.append("ediPartyName=");
                buf.append(obj.toString());
                break;
            }
            case 7: {
                buf.append("IP=");
                buf.append(obj.toString());
                break;
            }
            case 0: {
                buf.append("otherName=");
                buf.append(obj.toString());
                break;
            }
            case 8: {
                buf.append("registeredID=");
                buf.append(obj.toString());
                break;
            }
            case 3: {
                buf.append("x400Address=");
                buf.append(obj.toString());
                break;
            }
            default: {
                buf.append(String.valueOf(gn.getTagNo()) + "=");
            }
        }
        return buf.toString();
    }
}

