/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.connection.job;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.log.LogService;

public class CloseConnectionJob
extends Job {
    @Inject
    private LogService logger;
    @Inject
    private IConnection connection;

    public CloseConnectionJob() {
        super("Closing Connection");
        this.setPriority(20);
        this.setSystem(false);
        this.setUser(true);
    }

    public CloseConnectionJob(LogService logger, IConnection connection) {
        super(String.format(Messages.closeconn_job_name, connection.getName()));
        this.logger = logger;
        this.connection = connection;
        this.setSystem(false);
        this.setUser(true);
    }

    @PostConstruct
    public void postConstruct() {
        this.setName(String.format(Messages.closeconn_job_name, this.connection.getName()));
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.log(4, "Closing connection " + this.connection.getName());
        Job[] jobs = CloseConnectionJob.getJobManager().find((Object)this.connection.getName());
        if (jobs.length == 0) {
            this.logger.log(4, "No jobs to wait for. Close connection immediately.");
        } else {
            this.cancelKeepAliveJob(this.connection);
            int counter = 0;
            while (this.areJobsActive(jobs) && counter++ < 10) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.log(1, "Waiting for job finishing of active jobs interrupted. Error: " + e.getMessage());
                }
            }
        }
        try {
            this.connection.disconnect();
        }
        catch (Exception e) {
            this.logger.log(1, "Could not disconnect connection " + this.connection.getName() + ". Cause: " + e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private void cancelKeepAliveJob(IConnection connection) {
        this.logger.log(4, "Canceling keep alive jobs for " + connection.getName());
        Job[] jobs = CloseConnectionJob.getJobManager().find((Object)connection.getName());
        QualifiedName keepAliveQualifier = new QualifiedName("miworkplace://miworkplace.services.alive", "function");
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            Object property = job.getProperty(keepAliveQualifier);
            if ("keep.alive".equals(property)) {
                job.cancel();
                job.getThread().interrupt();
                break;
            }
            ++n2;
        }
    }

    boolean areJobsActive(Job[] jobs) {
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            this.logger.log(3, "Waiting for job " + job.getName() + " to finish.");
            int state = job.getState();
            switch (state) {
                case 1: 
                case 2: 
                case 4: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean belongsTo(Object family) {
        if (family == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass().equals(family);
    }
}

