/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import com.ibm.as400.access.list.SpooledFileListItem;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Iterator;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.ModelUtil;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class OpenSpoolHandler {
    public static final String ID = "miworkplace.spools.command.open";
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IActiveConnectionService activeConnectionService;

    @Execute
    public void run(@Named(value="activeShell") Shell shell, ESelectionService selectionService) {
        IStructuredSelection ss;
        Iterator iterator;
        Object selection = selectionService.getSelection();
        if (selection != null && (iterator = (ss = (IStructuredSelection)selection).iterator()).hasNext()) {
            SpooledFileListItem file = (SpooledFileListItem)iterator.next();
            try {
                if (file.getTotalPages() > 500) {
                    if (MessageDialog.openConfirm((Shell)shell, (String)Messages.spools_large_title, (String)Messages.spools_large)) {
                        this.open(file);
                    }
                } else {
                    this.open(file);
                }
            }
            catch (Exception exception) {
                this.open(file);
            }
        }
    }

    private void open(SpooledFileListItem file) {
        String uri = this.composeInputUri(file);
        String name = this.getName(file);
        MPart part = this.partService.createPart("miworkplace.ui.editor.partdescriptor.default");
        part.setLabel(file.getName());
        part.setTooltip(name);
        part.setCloseable(true);
        part.setContributionURI("bundleclass://miworkplace.spools/miworkplace.spools.editor.SpooledFileEditor");
        part.getPersistedState().put("miworkplace.editor.inputUri", uri);
        part.getPersistedState().put("miworkplace.editor.connection", this.activeConnectionService.getLastUsedActiveConnection().getName());
        part.getTags().add("removeOnHide");
        part.getProperties().put("miworkplace.editor", Boolean.TRUE.toString());
        part.getProperties().put("miworkplace.editor.inputUri", uri);
        MPartStack editorPartStack = ModelUtil.getSharedPartstack((EModelService)this.modelService, (MApplication)this.application);
        if (editorPartStack != null) {
            editorPartStack.getChildren().add(part);
        }
        this.partService.showPart(part, EPartService.PartState.ACTIVATE);
        this.partService.bringToTop(part);
    }

    private String composeInputUri(SpooledFileListItem file) {
        return "spooledfile://" + this.activeConnectionService.getLastUsedActiveConnection().getSystemName() + "/" + file.getName() + "/" + String.valueOf(file.getNumber()) + "/" + file.getJobName() + "/" + file.getJobNumber() + "/" + file.getJobUser();
    }

    private String getName(SpooledFileListItem spooledFile) {
        return spooledFile.getName() + " (" + spooledFile.getJobName() + "/" + spooledFile.getJobNumber() + "/" + spooledFile.getJobUser() + ")";
    }
}

