/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools;

import com.ibm.as400.access.list.SpooledFileListItem;
import miworkplace.common.debug.Debug;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

class SpooledFileComparator
extends ViewerComparator {
    public static final boolean SORT_ASCENDING = false;
    public static final boolean SORT_DESCENDING = true;
    public static final int SORT_FILENAME = 1;
    public static final int SORT_USER = 2;
    public static final int SORT_OUTQ = 3;
    public static final int SORT_USERDATA = 4;
    public static final int SORT_STATUS = 5;
    public static final int SORT_FORM = 6;
    public static final int SORT_FILENUMBER = 7;
    public static final int SORT_PAGES = 8;
    public static final int SORT_CREATED = 9;
    private int criteria = 1;
    private boolean sortDirection = true;
    private Debug fLogger;

    public SpooledFileComparator(Debug logger) {
        this.fLogger = logger;
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        SpooledFileListItem file1 = (SpooledFileListItem)obj1;
        SpooledFileListItem file2 = (SpooledFileListItem)obj2;
        int retVal = 1;
        try {
            switch (this.getCriteria()) {
                case 1: {
                    retVal = file1.getName().compareTo(file2.getName());
                    break;
                }
                case 2: {
                    retVal = file1.getJobUser().compareTo(file2.getJobUser());
                    break;
                }
                case 3: {
                    retVal = file1.getOutputQueueName().compareTo(file2.getOutputQueueName());
                    break;
                }
                case 4: {
                    retVal = file1.getUserData().compareTo(file2.getUserData());
                    break;
                }
                case 5: {
                    retVal = file1.getStatus().compareTo(file2.getStatus());
                    break;
                }
                case 6: {
                    retVal = file1.getFormType().compareTo(file2.getFormType());
                    break;
                }
                case 7: {
                    retVal = Integer.compare(file1.getNumber(), file2.getNumber());
                    break;
                }
                case 8: {
                    retVal = Integer.compare(file1.getTotalPages(), file2.getTotalPages());
                    break;
                }
                case 9: {
                    retVal = this.compareByCreationDate(file1, file2);
                    break;
                }
                default: {
                    retVal = 1;
                }
            }
            retVal = retVal == 0 ? this.compareByCreationDate(file1, file2) : retVal;
        }
        catch (Exception e) {
            this.fLogger.error("Could not compare spooled files for sorting. Falling back to default (file 1 equals file 2).", (Throwable)e);
            return 0;
        }
        if (this.isSortDescending()) {
            retVal *= -1;
        }
        return retVal;
    }

    boolean isSortDescending() {
        return this.sortDirection;
    }

    private int compareByCreationDate(SpooledFileListItem pFile1, SpooledFileListItem pFile2) {
        return pFile1.getCreationDate().compareTo(pFile2.getCreationDate());
    }

    public int getCriteria() {
        return this.criteria;
    }

    public SpooledFileComparator setCriteria(int criteria) {
        this.criteria = criteria;
        return this;
    }

    public boolean isSortDirection() {
        return this.sortDirection;
    }

    public SpooledFileComparator setSortDirection(boolean sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    public String toString() {
        return "SpooledFileSorter [criteria=" + this.criteria + ", sortDirection=" + this.sortDirection + "]";
    }
}

