/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs.test;

import java.util.List;
import miworkplace.iledocs.cl.ClIledocsRetriever;
import org.junit.Assert;
import org.junit.Test;

public class ClIledocsRetrieverTest {
    private final ClIledocsRetriever docsRetriever = new ClIledocsRetriever();

    @Test
    public void test_uncontinuedLines() {
        String code = "/** \\title Test                                        */\n/** This program is just for testing the documentation */\n/** plugin.                                            */\n/**                                                    */\n/** This is a multiple line description test.          */\n/**                                                    */\n/** \\author Mihael Schmidt                             */\n/** \\date 01.01.2011                                   */\n/**                                                    */\n/** \\deprecated This will not be used anymore.         */\n/**                                                    */\n/** \\info Use if wisely.                               */";
        List<String> lines = this.docsRetriever.retrieve(code);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)12L, (long)lines.size());
        Assert.assertEquals((Object)"\\title Test", (Object)lines.get(0));
        Assert.assertEquals((Object)"\\info Use if wisely.", (Object)lines.get(11));
    }

    @Test
    public void test_continuedLines() {
        String code = "/** \\title Test                                   +\nThis program is just for testing the documentation +\nplugin.                                            +\n                                                   +\nThis is a multiple line description test.          +\n                                                   +\n\\author Mihael Schmidt                            +\n\\date 01.01.2011                                  +\n                                                   +\n\\deprecated This will not be used anymore.        +\n                                                   +\n\\info Use if wisely. */";
        List<String> lines = this.docsRetriever.retrieve(code);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)12L, (long)lines.size());
        Assert.assertEquals((Object)"\\title Test", (Object)lines.get(0));
        Assert.assertEquals((Object)"\\info Use if wisely.", (Object)lines.get(11));
    }

    @Test
    public void test_mixedLines() {
        String code = "/** \\title Test                                        */\n/** This program is just for testing the documentation +\n/** plugin.                                            +\n/**                                                    +\n/** This is a multiple line description test.          +\n/**                                                    */\n/** \\author Mihael Schmidt                             */\n/** \\date 01.01.2011                                   */\n/**                                                    */\n/** \\deprecated This will not be used anymore.         */\n/**                                                    */\n/** \\info Use if wisely.                               */";
        List<String> lines = this.docsRetriever.retrieve(code);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)12L, (long)lines.size());
        Assert.assertEquals((Object)"\\title Test", (Object)lines.get(0));
        Assert.assertEquals((Object)"\\info Use if wisely.", (Object)lines.get(11));
    }

    @Test
    public void test_precedingComment() {
        String code = "/* Normal comment. */\n\n/** \\title Test                                       +\n/** This program is just for testing the documentation +\n/** plugin.                                            +\n/**                                                    +\n/** This is a multiple line description test.          +\n/**                                                    */\n/** \\author Mihael Schmidt                             */\n/** \\date 01.01.2011                                   */\n/**                                                    */\n/** \\deprecated This will not be used anymore.         */\n/**                                                    */\n/** \\info Use if wisely.                               */";
        List<String> lines = this.docsRetriever.retrieve(code);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)12L, (long)lines.size());
        Assert.assertEquals((Object)"\\title Test", (Object)lines.get(0));
        Assert.assertEquals((Object)"\\info Use if wisely.", (Object)lines.get(11));
    }

    @Test
    public void test_precedingProgramStart() {
        String code = "PGM\n\n/** \\title Test                                       +\n/** This program is just for testing the documentation +\n/** plugin.                                            +\n/**                                                    +\n/** This is a multiple line description test.          +\n/**                                                    */\n/** \\author Mihael Schmidt                             */\n/** \\date 01.01.2011                                   */\n/**                                                    */\n/** \\deprecated This will not be used anymore.         */\n/**                                                    */\n/** \\info Use if wisely.                               */";
        List<String> lines = this.docsRetriever.retrieve(code);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)12L, (long)lines.size());
        Assert.assertEquals((Object)"\\title Test", (Object)lines.get(0));
        Assert.assertEquals((Object)"\\info Use if wisely.", (Object)lines.get(11));
    }

    @Test
    public void test_precedingLabel() {
        String code = "PGM\nSTART:\n\n/** \\title Test                                       +\n/** This program is just for testing the documentation +\n/** plugin.                                            +\n/**                                                    +\n/** This is a multiple line description test.          +\n/**                                                    */\n/** \\author Mihael Schmidt                             */\n/** \\date 01.01.2011                                   */\n/**                                                    */\n/** \\deprecated This will not be used anymore.         */\n/**                                                    */\n/** \\info Use if wisely.                               */";
        List<String> lines = this.docsRetriever.retrieve(code);
        Assert.assertNotNull(lines);
        Assert.assertEquals((long)12L, (long)lines.size());
        Assert.assertEquals((Object)"\\title Test", (Object)lines.get(0));
        Assert.assertEquals((Object)"\\info Use if wisely.", (Object)lines.get(11));
    }
}

