/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs.rpg;

import com.ibm.as400.access.ObjectDescription;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.iledocs.IledocsBuilder;
import miworkplace.iledocs.Parser;
import miworkplace.iledocs.model.Constant;
import miworkplace.iledocs.model.Parameter;
import miworkplace.iledocs.model.Program;
import miworkplace.iledocs.model.ReturnValue;
import miworkplace.iledocs.model.Variable;
import miworkplace.iledocs.rpg.RpgIledocsRetriever;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.DataStructureParameter;
import miworkplace.ui.editor.rpg.ast.Element;
import miworkplace.ui.editor.rpg.ast.File;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Module;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.ast.VariableParameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;

public class FreeRpgIledocsBuilder
implements IledocsBuilder {
    private Debug logger = Debug.getInstance();
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    private String iledocsPrefix = "@";
    private Boolean iledocsIncludeCopyBooks = Boolean.FALSE;
    private Boolean iledocsIncludeFiles = Boolean.FALSE;
    private final miworkplace.ui.editor.rpg.ast.Parser parser = new miworkplace.ui.editor.rpg.ast.Parser();
    private final RpgIledocsRetriever retriever = new RpgIledocsRetriever();

    @PostConstruct
    public void postConstruct() {
        this.iledocsPrefix = this.applicationPreferences.get("miworkplace.iledocs.pref.prefix", "@");
        this.iledocsIncludeCopyBooks = this.applicationPreferences.getBoolean("miworkplace.iledocs.pref.include.copybooks", Boolean.FALSE.booleanValue());
        this.iledocsIncludeFiles = this.applicationPreferences.getBoolean("miworkplace.iledocs.pref.include.files", Boolean.FALSE.booleanValue());
    }

    @Override
    public Program build(IConnection connection, String code) throws Exception {
        if (code == null || connection == null) {
            return null;
        }
        Program program = new Program();
        Parser iledocsParser = new Parser(this.iledocsPrefix);
        Module ast = (Module)this.parser.parse(code, (Ast)new Module(new ArrayList()));
        String[] codeLines = code.split("\\n");
        Map<Integer, List<String>> iledocsBlockMap = this.retriever.retrieve(code);
        for (Map.Entry<Integer, List<String>> entry : iledocsBlockMap.entrySet()) {
            Variable iledocsVariable;
            miworkplace.iledocs.model.Procedure iledocsProcedure;
            int i = entry.getKey();
            while (i < codeLines.length - 1 && StringUtils.isBlank((CharSequence)codeLines[++i])) {
            }
            Object symbol = this.getDefinedSymbol(ast, i);
            if (symbol == null) {
                iledocsParser.parse(entry.getValue(), program);
                continue;
            }
            if (symbol instanceof Procedure) {
                iledocsProcedure = new miworkplace.iledocs.model.Procedure();
                iledocsParser.parse(entry.getValue(), iledocsProcedure);
                Procedure procedure = (Procedure)symbol;
                iledocsProcedure.setName(procedure.getName());
                this.fillReturnValue(iledocsProcedure, procedure, ast);
                this.fillParameters(iledocsProcedure, procedure.getProcedureInterface().getParameters());
                program.getProcedures().add(iledocsProcedure);
                continue;
            }
            if (symbol instanceof Prototype) {
                iledocsProcedure = new miworkplace.iledocs.model.Procedure();
                iledocsParser.parse(entry.getValue(), iledocsProcedure);
                Prototype prototype = (Prototype)symbol;
                iledocsProcedure.setName(prototype.getName());
                this.fillReturnValue(iledocsProcedure, prototype, ast);
                this.fillParameters(iledocsProcedure, prototype.getParameters());
                program.getProcedures().add(iledocsProcedure);
                continue;
            }
            if (symbol instanceof miworkplace.ui.editor.rpg.ast.Variable) {
                miworkplace.ui.editor.rpg.ast.Variable var = (miworkplace.ui.editor.rpg.ast.Variable)symbol;
                iledocsVariable = new Variable();
                iledocsParser.parse(entry.getValue(), iledocsVariable);
                iledocsVariable.setArraySize(this.toInteger(var.getArraySize()));
                iledocsVariable.setDecimalPositions(this.toInteger(var.getDecimalPositions()));
                iledocsVariable.setExported(var.getExported());
                iledocsVariable.setImported(var.getImported());
                iledocsVariable.setLength(this.toInteger(var.getLength()));
                iledocsVariable.setLike(var.getLike());
                iledocsVariable.setName(var.getName());
                iledocsVariable.setType(this.mapType(var.getType()));
                iledocsVariable.setKeywords(this.buildKeywords(var));
                if (StringUtils.isNotBlank((CharSequence)var.getExternalName()) && !var.getExternalName().equalsIgnoreCase("*dclcase")) {
                    iledocsVariable.setName(StringUtils.strip((String)var.getExternalName(), (String)"'"));
                }
                program.getVariables().add(iledocsVariable);
                continue;
            }
            if (symbol instanceof DataStructure) {
                DataStructure ds = (DataStructure)symbol;
                iledocsVariable = new Variable();
                iledocsParser.parse(entry.getValue(), iledocsVariable);
                iledocsVariable.setArraySize(this.toInteger(ds.getArraySize()));
                iledocsVariable.setExported(ds.getExported());
                iledocsVariable.setImported(ds.getImported());
                iledocsVariable.setLength(this.toInteger(ds.getLength()));
                iledocsVariable.setLike(ds.getLike());
                iledocsVariable.setName(ds.getName());
                iledocsVariable.setType(Variable.Type.DataStructure);
                if (StringUtils.isNotBlank((CharSequence)ds.getExternalName()) && !ds.getExternalName().equalsIgnoreCase("*dclcase")) {
                    iledocsVariable.setName(StringUtils.strip((String)ds.getExternalName(), (String)"'"));
                }
                program.getVariables().add(iledocsVariable);
                continue;
            }
            if (symbol instanceof miworkplace.ui.editor.rpg.ast.Constant) {
                miworkplace.ui.editor.rpg.ast.Constant constant = (miworkplace.ui.editor.rpg.ast.Constant)symbol;
                Constant iledocsConstant = new Constant();
                iledocsParser.parse(entry.getValue(), iledocsConstant);
                iledocsConstant.setName(constant.name.value);
                program.getConstants().add(iledocsConstant);
                continue;
            }
            this.logger.info((Option)miworkplace.iledocs.debug.Option.iledocs, "ILEDocs block ending at line " + (entry.getKey() + 1) + " is not supported.");
        }
        if (this.iledocsIncludeCopyBooks.booleanValue()) {
            for (Include include : ast.listIncludes()) {
                program.getIncludes().add(include.getFileUnquoted());
            }
        }
        if (this.iledocsIncludeFiles.booleanValue()) {
            for (File file : ast.listFiles()) {
                miworkplace.iledocs.model.File f = new miworkplace.iledocs.model.File();
                f.setName(file.getFilename());
                f.setDescription(this.getFileDescription(connection, file));
                program.getFiles().add(f);
            }
        }
        return program;
    }

    private void fillParameters(miworkplace.iledocs.model.Procedure iledocsProcedure, List<miworkplace.ui.editor.rpg.ast.Parameter> parameters) {
        if (iledocsProcedure.getParameters() == null) {
            iledocsProcedure.setParameters(new ArrayList<Parameter>());
        }
        if (parameters == null) {
            return;
        }
        List<Parameter> iledocsParameters = iledocsProcedure.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            miworkplace.ui.editor.rpg.ast.Parameter parameter = parameters.get(i);
            Parameter iledocsParameter = null;
            iledocsParameter = iledocsParameters.size() <= i ? new Parameter() : iledocsParameters.get(i);
            if (parameter instanceof VariableParameter) {
                parm = (VariableParameter)parameter;
                iledocsParameter.setName(parm.getName());
                iledocsParameter.setDecimalPositions(this.toInteger(parm.getDecimalPositions()));
                iledocsParameter.setKeywords(this.buildKeywords(parameter));
                iledocsParameter.setLength(this.toInteger(parm.getLength()));
                iledocsParameter.setLike(parm.getLike());
                iledocsParameter.setType(this.mapType(parm.getType()));
            } else if (parameter instanceof DataStructureParameter) {
                parm = (DataStructureParameter)parameter;
                iledocsParameter.setName(parm.getName());
                iledocsParameter.setKeywords(this.buildKeywords(parameter));
                iledocsParameter.setLength(this.toInteger(parm.getLength()));
                iledocsParameter.setLike(parm.getLike());
                iledocsParameter.setType(Variable.Type.DataStructure);
            }
            ++i;
        }
    }

    private List<String> buildKeywords(miworkplace.ui.editor.rpg.ast.Parameter parameter) {
        ArrayList<String> keywords = new ArrayList<String>();
        if (parameter.isPassedByRef()) {
            keywords.add("const");
        }
        if (parameter.isPassedByValue()) {
            keywords.add("value");
        }
        if (parameter.getOptions() != null) {
            List options = parameter.getOptions();
            for (Parameter.Option option : options) {
                keywords.add(option.name());
            }
        }
        return keywords;
    }

    private List<String> buildKeywords(miworkplace.ui.editor.rpg.ast.Variable variable) {
        ArrayList<String> keywords = new ArrayList<String>();
        return keywords;
    }

    private Integer toInteger(String decimalPositions) {
        if (NumberUtils.isNumber((String)decimalPositions)) {
            return Integer.valueOf(decimalPositions);
        }
        return null;
    }

    private String getFileDescription(IConnection connection, File file) throws Exception {
        String filename = file.getFilename();
        if (file.getExternalDescriptionFile() != null) {
            filename = file.getExternalDescriptionFile();
        }
        String libraryName = "*LIBL";
        if (file.getExternalDescriptionLibrary() != null && !"*LIBL".equalsIgnoreCase(file.getExternalDescriptionLibrary())) {
            libraryName = file.getExternalDescriptionLibrary();
        }
        ObjectDescription description = new ObjectDescription(connection.getSystem(), libraryName, filename, "FILE");
        try {
            String text = description.getValueAsString(203);
            return text;
        }
        catch (Exception e) {
            this.logger.error("Could not get file description for " + file.getFilename() + ". Error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void fillReturnValue(miworkplace.iledocs.model.Procedure iledocsProcedure, Procedure procedure, Module ast) {
        if (iledocsProcedure.getReturnValue() == null) {
            iledocsProcedure.setReturnValue(new ReturnValue());
        }
        ReturnValue returnValue = iledocsProcedure.getReturnValue();
        if (procedure.getProcedureInterface().getReturnValue() != null) {
            AbstractVariable v = (AbstractVariable)procedure.getProcedureInterface().getReturnValue();
            if (v.getLike() == null) {
                this.fillReturnValueData(returnValue, v);
            } else {
                Object templateVariable = ast.getSymbol(v.getLike());
                if (templateVariable != null && templateVariable instanceof AbstractVariable) {
                    returnValue.setLike(v.getLike());
                    this.fillReturnValueData(returnValue, (AbstractVariable)templateVariable);
                }
            }
        }
    }

    private void fillReturnValue(miworkplace.iledocs.model.Procedure iledocsProcedure, Prototype prototype, Module ast) {
        if (iledocsProcedure.getReturnValue() == null) {
            iledocsProcedure.setReturnValue(new ReturnValue());
        }
        ReturnValue returnValue = iledocsProcedure.getReturnValue();
        if (prototype.getReturnValue() != null) {
            AbstractVariable v = (AbstractVariable)prototype.getReturnValue();
            if (v.getLike() == null) {
                this.fillReturnValueData(returnValue, v);
            } else {
                Object templateVariable = ast.getSymbol(v.getLike());
                if (templateVariable != null && templateVariable instanceof AbstractVariable) {
                    returnValue.setLike(v.getLike());
                    this.fillReturnValueData(returnValue, (AbstractVariable)templateVariable);
                }
            }
        }
    }

    private void fillReturnValueData(ReturnValue returnValue, AbstractVariable v) {
        if (StringUtils.isNumeric((CharSequence)v.getLength())) {
            returnValue.setLength(Integer.valueOf(v.getLength()));
        }
        if (v instanceof miworkplace.ui.editor.rpg.ast.Variable) {
            String decimalPositions = ((miworkplace.ui.editor.rpg.ast.Variable)v).getDecimalPositions();
            if (StringUtils.isNumeric((CharSequence)decimalPositions)) {
                returnValue.setDecimalPositions(Integer.valueOf(decimalPositions));
            }
            returnValue.setType(this.mapType(((miworkplace.ui.editor.rpg.ast.Variable)v).getType()));
        } else if (v instanceof DataStructure) {
            returnValue.setType(Variable.Type.DataStructure);
        }
    }

    private Variable.Type mapType(Variable.Type type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case BinaryDecimal: {
                return Variable.Type.Binary;
            }
            case Boolean: {
                return Variable.Type.Boolean;
            }
            case Character: {
                return Variable.Type.Char;
            }
            case Date: {
                return Variable.Type.Date;
            }
            case Float: {
                return Variable.Type.Float;
            }
            case Graph: {
                return Variable.Type.Graph;
            }
            case Integer: {
                return Variable.Type.Integer;
            }
            case Object: {
                return Variable.Type.Object;
            }
            case Packed: {
                return Variable.Type.PackedDecimal;
            }
            case Pointer: {
                return Variable.Type.Pointer;
            }
            case Time: {
                return Variable.Type.Time;
            }
            case Timestamp: {
                return Variable.Type.Timestamp;
            }
            case UCS2: {
                return Variable.Type.UCS2;
            }
            case UnsignedInteger: {
                return Variable.Type.UnsignedInteger;
            }
            case Varchar: {
                return Variable.Type.Varchar;
            }
            case Zoned: {
                return Variable.Type.ZonedDecimal;
            }
        }
        return null;
    }

    private Object getDefinedSymbol(Module ast, int i) {
        for (Element prototype : ast.listPrototypes()) {
            if (((Statement)prototype.getStatements().get(0)).getFirstLine() != i) continue;
            return prototype;
        }
        for (Procedure procedure : ast.listProcedures()) {
            if (procedure.getFirst().getFirstLine() != i) continue;
            return procedure;
        }
        for (AbstractVariable variable : ast.listVariables()) {
            DataStructure ds;
            if (variable instanceof miworkplace.ui.editor.rpg.ast.Variable) {
                miworkplace.ui.editor.rpg.ast.Variable v = (miworkplace.ui.editor.rpg.ast.Variable)variable;
                if (v.getStatement().getFirstLine() != i) continue;
                return v;
            }
            if (!(variable instanceof DataStructure) || ((Statement)(ds = (DataStructure)variable).getStatements().get(0)).getFirstLine() != i) continue;
            return ds;
        }
        for (miworkplace.ui.editor.rpg.ast.Constant constant : ast.listConstants()) {
            if (constant.getFirst().getFirstLine() != i) continue;
            return constant;
        }
        return null;
    }

    public void setIledocsPrefix(String prefix) {
        this.iledocsPrefix = prefix;
    }
}

