/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.dds;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import miworkplace.common.model.LineType;
import miworkplace.ui.editor.FormatLine;
import miworkplace.ui.editor.FormatLineListener;
import miworkplace.ui.editor.FormatLineProvider;
import miworkplace.ui.editor.ISourceViewerExtension;
import miworkplace.ui.editor.dds.ast.Ast;
import miworkplace.ui.editor.dds.ast.RecordFormat;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class DdsFormatLineListener
extends FormatLineListener {
    @Inject
    private LogService logger;
    @Inject
    private FormatLineProvider formatLineProvider;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    private ISourceViewerExtension editorExtension;
    private FormatLine formatLine;
    private Ast ast;

    @Inject
    public DdsFormatLineListener(ISourceViewerExtension editorExtension, FormatLine formatLine) {
        this.editorExtension = editorExtension;
        this.formatLine = formatLine;
    }

    public void updateFormatLine() {
        if (!this.formatLine.isVisible()) {
            this.formatLine.setVisible(true);
        }
        if (this.editorExtension.getSelectionProvider() == null || this.editorExtension.getSelectionProvider().getSelection() == null) {
            return;
        }
        ISelection selection = this.editorExtension.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            AbstractDocument document = (AbstractDocument)this.editorExtension.getDocument();
            try {
                int lineOffset = document.getLineOffset(textSelection.getStartLine());
                int relativePosition = textSelection.getOffset() - lineOffset;
                this.formatLine.updateFormatLabel(this.formatLineProvider.getFormatLine(this.determineLineType(document, textSelection.getStartLine())), relativePosition);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not update formate line for line " + textSelection.getStartLine(), (Throwable)e);
            }
        }
    }

    private LineType determineLineType(AbstractDocument document, int lineNumber) throws Exception {
        IRegion lineInformation = document.getLineInformation(lineNumber);
        if (lineInformation.getLength() < 7) {
            return LineType.Empty;
        }
        String line = document.get(lineInformation.getOffset(), lineInformation.getLength());
        if (line.charAt(6) == '*') {
            return LineType.Comment;
        }
        if (line.length() >= 17 && (line.charAt(16) == 'R' || line.charAt(16) == 'r')) {
            return LineType.Record;
        }
        if (line.charAt(5) == 'A' || line.charAt(5) == 'a') {
            int firstRecordLine = this.determineFirstRecordLine();
            return firstRecordLine < lineNumber ? LineType.RecordEntry : LineType.FileLevel;
        }
        return LineType.Empty;
    }

    private int determineFirstRecordLine() {
        if (this.ast == null) {
            return Integer.MAX_VALUE;
        }
        List<RecordFormat> recordFormats = this.ast.listRecordFormats();
        if (recordFormats.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int firstRecordFormatLine = Integer.MAX_VALUE;
        for (RecordFormat recordFormat : recordFormats) {
            if (recordFormat.line >= firstRecordFormatLine) continue;
            firstRecordFormatLine = recordFormat.line;
        }
        return firstRecordFormatLine;
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        String astInputUri = event.getProperty("inputUri").toString();
        Object eventData = event.getProperty("org.eclipse.e4.data");
        if (this.inputUri.equals(astInputUri)) {
            this.ast = eventData != null && eventData instanceof Ast ? (Ast)eventData : null;
        }
    }
}

