/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.Program;
import com.ibm.jtopenlite.command.program.CallServiceProgramParameterFormat;

public class CallServiceProgramProcedure
implements Program {
    public static final int RETURN_VALUE_FORMAT_NONE = 0;
    public static final int RETURN_VALUE_FORMAT_INTEGER = 1;
    public static final int RETURN_VALUE_FORMAT_POINTER = 2;
    public static final int RETURN_VALUE_FORMAT_INTEGER_AND_ERROR_NUMBER = 3;
    private static final byte[] ZERO = new byte[8];
    private String serviceProgramName_;
    private String serviceProgramLibrary_;
    private String exportName_;
    private int returnValueFormat_;
    private CallServiceProgramParameterFormat parameterFormat_;
    private byte[] tempData_;
    private int returnValueInteger_;
    private byte[] returnValuePointer_;
    private int returnValueErrno_;

    public CallServiceProgramProcedure() {
    }

    public CallServiceProgramProcedure(String string, String string2, String string3, int n) {
        this.serviceProgramName_ = string;
        this.serviceProgramLibrary_ = string2;
        this.exportName_ = string3;
        this.returnValueFormat_ = n;
    }

    public String getServiceProgramName() {
        return this.serviceProgramName_;
    }

    public void setServiceProgramName(String string) {
        this.serviceProgramName_ = string;
    }

    public String getServiceProgramLibrary() {
        return this.serviceProgramLibrary_;
    }

    public void setServiceProgramLibrary(String string) {
        this.serviceProgramLibrary_ = string;
    }

    public String getExportName() {
        return this.exportName_;
    }

    public void setExportName(String string) {
        this.exportName_ = string;
    }

    public int getReturnValueFormat() {
        return this.returnValueFormat_;
    }

    public void setReturnValueFormat(int n) {
        this.returnValueFormat_ = n;
    }

    public CallServiceProgramParameterFormat getParameterFormat() {
        return this.parameterFormat_;
    }

    public void setParameterFormat(CallServiceProgramParameterFormat callServiceProgramParameterFormat) {
        this.parameterFormat_ = callServiceProgramParameterFormat;
    }

    public String getProgramName() {
        return "QZRUCLSP";
    }

    public String getProgramLibrary() {
        return "QSYS";
    }

    public int getNumberOfParameters() {
        return 7 + this.parameterFormat_.getParameterCount();
    }

    public final byte[] getTempDataBuffer() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfParameters(); ++i) {
            int n2 = this.getParameterOutputLength(i);
            if (n2 > n) {
                n = n2;
            }
            if ((n2 = this.getParameterInputLength(i)) <= n) continue;
            n = n2;
        }
        if (this.tempData_ == null || this.tempData_.length < n) {
            this.tempData_ = new byte[n];
        }
        return this.tempData_;
    }

    public void newCall() {
        this.returnValueInteger_ = 0;
        this.returnValuePointer_ = null;
        this.returnValueErrno_ = 0;
    }

    public int getReturnValueInteger() {
        return this.returnValueInteger_;
    }

    public int getReturnValueErrorNumber() {
        return this.returnValueErrno_;
    }

    public byte[] getReturnValuePointer() {
        return this.returnValuePointer_;
    }

    public int getParameterInputLength(int n) {
        switch (n) {
            case 0: {
                return 20;
            }
            case 1: {
                return this.exportName_.length() + 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return this.parameterFormat_.getParameterCount() * 4;
            }
            case 4: {
                return 4;
            }
            case 5: {
                int n2 = 20;
                n2 += this.exportName_.length() + 1;
                n2 += 4;
                n2 += this.parameterFormat_.getParameterCount() * 4;
                n2 += 4;
                n2 += ZERO.length;
                int n3 = 0;
                switch (this.returnValueFormat_) {
                    case 0: {
                        n3 = 4;
                        break;
                    }
                    case 1: {
                        n3 = 4;
                        break;
                    }
                    case 2: {
                        n3 = 16;
                        break;
                    }
                    case 3: {
                        n3 = 8;
                    }
                }
                int n4 = (n2 += n3) % 16;
                int n5 = n4 == 0 ? 0 : 16 - n4;
                return ZERO.length + n5;
            }
            case 7: {
                return this.parameterFormat_.getParameterLength(0);
            }
            case 8: {
                return this.parameterFormat_.getParameterLength(1);
            }
            case 9: {
                return this.parameterFormat_.getParameterLength(2);
            }
            case 10: {
                return this.parameterFormat_.getParameterLength(3);
            }
            case 11: {
                return this.parameterFormat_.getParameterLength(4);
            }
            case 12: {
                return this.parameterFormat_.getParameterLength(5);
            }
            case 13: {
                return this.parameterFormat_.getParameterLength(6);
            }
        }
        return 0;
    }

    public int getParameterOutputLength(int n) {
        switch (n) {
            case 5: {
                return this.getParameterInputLength(n);
            }
            case 6: {
                switch (this.returnValueFormat_) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 16;
                    }
                    case 3: {
                        return 8;
                    }
                }
            }
            case 7: {
                return this.parameterFormat_.getParameterLength(0);
            }
            case 8: {
                return this.parameterFormat_.getParameterLength(1);
            }
            case 9: {
                return this.parameterFormat_.getParameterLength(2);
            }
            case 10: {
                return this.parameterFormat_.getParameterLength(3);
            }
            case 11: {
                return this.parameterFormat_.getParameterLength(4);
            }
            case 12: {
                return this.parameterFormat_.getParameterLength(5);
            }
            case 13: {
                return this.parameterFormat_.getParameterLength(6);
            }
        }
        return 0;
    }

    public int getParameterType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        return 3;
    }

    public byte[] getParameterInputData(int n) {
        byte[] byArray = this.getTempDataBuffer();
        switch (n) {
            case 0: {
                Conv.stringToBlankPadEBCDICByteArray(this.serviceProgramName_, byArray, 0, 10);
                Conv.stringToBlankPadEBCDICByteArray(this.serviceProgramLibrary_, byArray, 10, 10);
                break;
            }
            case 1: {
                int n2 = Conv.stringToEBCDICByteArray37(this.exportName_, byArray, 0);
                byArray[n2] = 0;
                break;
            }
            case 2: {
                Conv.intToByteArray(this.returnValueFormat_, byArray, 0);
                break;
            }
            case 3: {
                for (int i = 0; i < this.parameterFormat_.getParameterCount(); ++i) {
                    Conv.intToByteArray(this.parameterFormat_.getParameterFormat(i), byArray, i * 4);
                }
                break;
            }
            case 4: {
                Conv.intToByteArray(this.parameterFormat_.getParameterCount(), byArray, 0);
                break;
            }
            case 5: {
                for (int i = 0; i < 16; ++i) {
                    byArray[i] = 0;
                }
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.parameterFormat_.fillInputData(n - 7, byArray, 0);
            }
        }
        return byArray;
    }

    public void setParameterOutputData(int n, byte[] byArray, int n2) {
        switch (n) {
            case 6: {
                switch (this.returnValueFormat_) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.returnValueInteger_ = Conv.byteArrayToInt(byArray, 0);
                        break;
                    }
                    case 2: {
                        this.returnValuePointer_ = new byte[16];
                        System.arraycopy(byArray, 0, this.returnValuePointer_, 0, 16);
                        break;
                    }
                    case 3: {
                        this.returnValueInteger_ = Conv.byteArrayToInt(byArray, 0);
                        this.returnValueErrno_ = Conv.byteArrayToInt(byArray, 4);
                    }
                }
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.parameterFormat_.setOutputData(n - 7, byArray, 0);
            }
        }
    }
}

