/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.ccsidConversion.CcsidConversion;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public final class Conv {
    private static Hashtable localeNlvMap_;
    private static final char[] NUM;
    private static final byte[] CHAR_HIGH;
    private static final byte[] CHAR_LOW;
    private static final byte[] CONV_TO_37;
    private static final byte[] INIT_TO_37;
    private static final char[] CONV_FROM_37;
    private static final String[] CACHE_FROM_37;
    private static final boolean cacheFrom37Init_;
    private static final HashMap encodingCcsid_;
    private static final HashMap ccsidEncoding_;
    private static final String[] encodings_;
    private static final int DEC_FLOAT_16_BIAS = 398;
    private static final long DEC_FLOAT_16_SIGNAL_MASK = 0x200000000000000L;
    private static final long DEC_FLOAT_16_SIGN_MASK = Long.MIN_VALUE;
    private static final long DEC_FLOAT_16_COMBINATION_MASK = 0x7C00000000000000L;
    private static final long DEC_FLOAT_16_EXPONENT_CONTINUATION_MASK = 287104476244869120L;
    private static final long DEC_FLOAT_16_COEFFICIENT_CONTINUATION_MASK = 0x3FFFFFFFFFFFFL;
    private static final int DEC_FLOAT_34_BIAS = 6176;
    private static final long DEC_FLOAT_34_SIGNAL_MASK = 0x200000000000000L;
    private static final long DEC_FLOAT_34_SIGN_MASK = Long.MIN_VALUE;
    private static final long DEC_FLOAT_34_COMBINATION_MASK = 0x7C00000000000000L;
    private static final long DEC_FLOAT_34_EXPONENT_CONTINUATION_MASK = 288160007407534080L;
    private static final int[][] TEN_RADIX_MAGNITUDE;

    private Conv() {
    }

    public static final String bytesToHexString(byte[] byArray, int n, int n2) {
        return Conv.bytesToHexString(byArray, n, n2, new char[n2 * 2]);
    }

    public static final String bytesToHexString(byte[] byArray, int n, int n2, char[] cArray) {
        int n3;
        int n4 = n3 = n2 * 2;
        for (int i = n + n2 - 1; i >= n; --i) {
            int n5 = byArray[i] & 0xF;
            int n6 = byArray[i] >> 4 & 0xF;
            cArray[--n4] = NUM[n5];
            cArray[--n4] = NUM[n6];
        }
        return new String(cArray, 0, n3);
    }

    public static final byte[] hexStringToBytes(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            ++n;
        }
        byte[] byArray = new byte[n >> 1];
        Conv.hexStringToBytes(string, byArray, 0);
        return byArray;
    }

    public static final int hexStringToBytes(String string, byte[] byArray, int n) {
        int n2;
        int n3 = string.length();
        int n4 = n3 % 2;
        if (n4 == 1) {
            byArray[n] = 0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string.charAt(n2);
            int n5 = 0;
            if (c >= '0' && c <= '9') {
                n5 = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                n5 = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                n5 = c - 97 + 10;
            }
            int n6 = n + (n2 + n4 >> 1);
            byArray[n6] = n2 % 2 == n4 ? (byte)(n5 << 4) : (byte)(byArray[n6] | n5);
        }
        n2 = n3 >> 1;
        return n4 == 0 ? n2 : n2 + 1;
    }

    public static final byte[] stringToEBCDICByteArray37(String string) {
        byte[] byArray = new byte[string.length()];
        Conv.stringToEBCDICByteArray37(string, byArray, 0);
        return byArray;
    }

    public static final int stringToEBCDICByteArray37(String string, byte[] byArray, int n) {
        return Conv.stringToEBCDICByteArray37(string, string.length(), byArray, n);
    }

    public static final int stringToEBCDICByteArray37(String string, int n, byte[] byArray, int n2) {
        int n3 = string.length();
        if (n3 < n) {
            n = n3;
        }
        int n4 = n2 + n;
        for (int i = n2; i < n4; ++i) {
            byArray[i] = CONV_TO_37[string.charAt(i - n2)];
        }
        return n;
    }

    public static final byte[] stringToEBCDICByteArray(String string, int n) throws UnsupportedEncodingException {
        int n2 = n & 0xFFFF;
        if (n2 == 37) {
            return Conv.stringToEBCDICByteArray37(string);
        }
        String string2 = encodings_[n2];
        if (string2 != null) {
            try {
                return string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Conv.encodings_[n2] = null;
            }
        }
        return CcsidConversion.stringToEBCDICByteArray(string, n2);
    }

    public static final int stringToEBCDICByteArray(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        int n3 = n2 & 0xFFFF;
        if (n3 == 37) {
            return Conv.stringToEBCDICByteArray37(string, byArray, n);
        }
        String string2 = encodings_[n3];
        if (string2 != null) {
            try {
                byte[] byArray2 = string.getBytes(string2);
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Conv.encodings_[n3] = null;
            }
        }
        return CcsidConversion.stringToEBCDICByteArray(string, byArray, n, n3);
    }

    public static final int stringToEBCDICByteArray(String string, int n, byte[] byArray, int n2, int n3) throws UnsupportedEncodingException {
        int n4;
        int n5 = string.length();
        if (n > n5) {
            n = n5;
        }
        if ((n4 = n3 & 0xFFFF) == 37) {
            return Conv.stringToEBCDICByteArray37(string, n, byArray, n2);
        }
        String string2 = encodings_[n4];
        if (string2 != null) {
            try {
                byte[] byArray2 = string.substring(0, n).getBytes(string2);
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                return byArray2.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Conv.encodings_[n4] = null;
            }
        }
        return CcsidConversion.stringToEBCDICByteArray(string, n, byArray, n2, n4);
    }

    public static final byte[] stringToUnicodeByteArray(String string) {
        byte[] byArray = new byte[string.length() * 2];
        Conv.stringToUnicodeByteArray(string, byArray, 0);
        return byArray;
    }

    public static final int stringToUnicodeByteArray(String string, byte[] byArray, int n) {
        return Conv.stringToUnicodeByteArray(string, string.length(), byArray, n);
    }

    public static final int stringToUnicodeByteArray(String string, int n, byte[] byArray, int n2) {
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c >> 8);
            byte by2 = (byte)c;
            byArray[n2 + i * 2] = by;
            byArray[n2 + i * 2 + 1] = by2;
        }
        return n * 2;
    }

    public static void stringToUnicodeByteArray(String string, byte[] byArray, int n, int n2) {
        int n3 = string.length();
        for (int i = 0; i < n2 / 2; ++i) {
            int n4 = i < n3 ? (int)string.charAt(i) : 32;
            byte by = (byte)(n4 >> 8);
            byte by2 = (byte)n4;
            byArray[n + i * 2] = by;
            byArray[n + i * 2 + 1] = by2;
        }
    }

    public static final int stringToUtf8ByteArray(String string, int n, byte[] byArray, int n2) {
        int n3 = string.length();
        if (n > n3) {
            n = n3;
        }
        try {
            byte[] byArray2 = string.substring(0, n).getBytes("UTF-8");
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            return byArray2.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
    }

    public static final void stringToBlankPadUnicodeByteArray(String string, byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (string != null) {
            for (int i = 0; i < string.length() && n3 + 2 <= n2; ++i) {
                byte by = (byte)(string.charAt(i) >> 8);
                byte by2 = (byte)string.charAt(i);
                byArray[n + n3] = by;
                byArray[n + ++n3] = by2;
                ++n3;
            }
        }
        while (n3 + 2 <= n2) {
            byArray[n + n3] = 0;
            byArray[n + ++n3] = 32;
            ++n3;
        }
    }

    public static final String unicodeByteArrayToString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        return Conv.unicodeByteArrayToString(byArray, n, n2, cArray);
    }

    public static final String unicodeByteArrayToString(byte[] byArray, int n, int n2, char[] cArray) {
        int n3;
        int n4 = n3 = n2 / 2;
        for (int i = n + n2 - 1; i >= n; i -= 2) {
            int n5 = byArray[i] & 0xFF;
            int n6 = byArray[i - 1] & 0xFF;
            char c = (char)(n6 << 8 | n5);
            cArray[--n4] = c;
        }
        return new String(cArray, 0, n3);
    }

    public static final void stringToBlankPadEBCDICByteArray(String string, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < string.length() && n3 < n2; ++n3) {
            byArray[n + n3] = CONV_TO_37[string.charAt(n3)];
        }
        for (n3 = string.length(); n3 < n2; ++n3) {
            byArray[n + n3] = 64;
        }
    }

    public static final void stringToBlankPadEBCDICByteArray(String string, byte[] byArray, int n, int n2, int n3) throws UnsupportedEncodingException {
        int n4 = n3 & 0xFFFF;
        if (n4 == 37) {
            Conv.stringToBlankPadEBCDICByteArray(string, byArray, n, n2);
        } else {
            String string2 = encodings_[n4];
            if (string2 != null) {
                int n5;
                byte[] byArray2 = string.getBytes(string2);
                int n6 = byArray2.length;
                int n7 = n6 < n2 ? n6 : n2;
                System.arraycopy(byArray2, 0, byArray, n, n7);
                if (n5 > 0) {
                    byte[] byArray3 = " ".getBytes(string2);
                    for (n5 = n2 - n6; n5 > 0; n5 -= byArray3.length) {
                        System.arraycopy(byArray3, 0, byArray, n + n7, byArray3.length);
                        n7 += byArray3.length;
                    }
                }
            } else {
                throw new UnsupportedEncodingException("CCSID " + n4);
            }
        }
    }

    public static final char ebcdicByteToChar(byte by) {
        return CONV_FROM_37[by & 0xFF];
    }

    public static final String ebcdicByteArrayToString(byte[] byArray, int n, int n2) {
        if (n2 == 1 && cacheFrom37Init_) {
            return CACHE_FROM_37[byArray[n] & 0xFF];
        }
        return Conv.ebcdicByteArrayToString(byArray, n, n2, new char[n2]);
    }

    public static final String ebcdicByteArrayToString(byte[] byArray, char[] cArray) {
        int n = 0;
        int n2 = byArray.length;
        return Conv.ebcdicByteArrayToString(byArray, n, n2, cArray);
    }

    public static final String ebcdicByteArrayToString(byte[] byArray, int n, int n2, char[] cArray) {
        if (n2 == 1 && cacheFrom37Init_) {
            return CACHE_FROM_37[byArray[n] & 0xFF];
        }
        int n3 = n2;
        for (int i = n + n2 - 1; i >= n; --i) {
            cArray[--n3] = CONV_FROM_37[byArray[i] & 0xFF];
        }
        return new String(cArray, 0, n2);
    }

    public static final String ebcdicByteArrayToString(byte[] byArray, int n, int n2, int n3) throws UnsupportedEncodingException {
        int n4 = n3 & 0xFFFF;
        if (n4 == 37) {
            return Conv.ebcdicByteArrayToString(byArray, n, n2);
        }
        String string = encodings_[n4];
        if (string != null) {
            return new String(byArray, n, n2, string);
        }
        throw new UnsupportedEncodingException("CCSID " + n4);
    }

    public static final String ebcdicByteArrayToString(byte[] byArray, int n, int n2, char[] cArray, int n3) throws UnsupportedEncodingException {
        int n4 = n3 & 0xFFFF;
        if (n4 == 37) {
            return Conv.ebcdicByteArrayToString(byArray, n, n2, cArray);
        }
        String string = encodings_[n4];
        if (string != null) {
            try {
                return new String(byArray, n, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Conv.encodings_[n4] = null;
                string = null;
            }
        }
        return CcsidConversion.createString(byArray, n, n2, n4);
    }

    public static boolean isSupported(int n) {
        if (n < 0 || n > 65535) {
            return false;
        }
        return n == 37 || encodings_[n] != null;
    }

    public static final long byteArrayToLong(byte[] byArray, int n) {
        int n2 = (0xFF & byArray[n]) << 24;
        int n3 = (0xFF & byArray[n + 1]) << 16;
        int n4 = (0xFF & byArray[n + 2]) << 8;
        int n5 = 0xFF & byArray[n + 3];
        int n6 = (0xFF & byArray[n + 4]) << 24;
        int n7 = (0xFF & byArray[n + 5]) << 16;
        int n8 = (0xFF & byArray[n + 6]) << 8;
        int n9 = 0xFF & byArray[n + 7];
        long l = n2 | n3 | n4 | n5;
        long l2 = n6 | n7 | n8 | n9;
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public static final int byteArrayToInt(byte[] byArray, int n) {
        int n2 = (0xFF & byArray[n]) << 24;
        int n3 = (0xFF & byArray[n + 1]) << 16;
        int n4 = (0xFF & byArray[n + 2]) << 8;
        int n5 = 0xFF & byArray[n + 3];
        return n2 | n3 | n4 | n5;
    }

    public static final short byteArrayToShort(byte[] byArray, int n) {
        short s = (short)((0xFF & byArray[n]) << 8);
        short s2 = (short)(0xFF & byArray[n + 1]);
        return (short)(s | s2);
    }

    public static final void shortToByteArray(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static final byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        Conv.intToByteArray(n, byArray, 0);
        return byArray;
    }

    public static final void intToByteArray(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static final byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        Conv.longToByteArray(l, byArray, 0);
        return byArray;
    }

    public static final void longToByteArray(long l, byte[] byArray, int n) {
        int n2 = (int)(l >> 32);
        int n3 = (int)l;
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
        byArray[n + 4] = (byte)(n3 >> 24);
        byArray[n + 5] = (byte)(n3 >> 16);
        byArray[n + 6] = (byte)(n3 >> 8);
        byArray[n + 7] = (byte)n3;
    }

    static final void writeStringToUnicodeBytes(String string, HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            hostOutputStream.writeShort(string.charAt(i));
        }
    }

    static final void writePadEBCDIC(String string, int n, HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        for (int i = 0; i < n; ++i) {
            if (string == null || string.length() <= i) {
                hostOutputStream.write(64);
                continue;
            }
            hostOutputStream.write(CONV_TO_37[string.charAt(i)]);
        }
    }

    static final void writePadEBCDIC10(String string, HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        Conv.writePadEBCDIC(string, 10, hostOutputStream);
    }

    public static final byte[] blankPadEBCDIC10(String string) {
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (string != null) {
            for (int i = 0; i < string.length() && i < 10; ++i) {
                byArray[i] = CONV_TO_37[string.charAt(i)];
            }
        }
        return byArray;
    }

    public static final float byteArrayToFloat(byte[] byArray, int n) {
        int n2 = Conv.byteArrayToInt(byArray, n);
        return Float.intBitsToFloat(n2);
    }

    public static final void floatToByteArray(float f, byte[] byArray, int n) {
        int n2 = Float.floatToIntBits(f);
        Conv.intToByteArray(n2, byArray, n);
    }

    public static final byte[] floatToByteArray(float f) {
        int n = Float.floatToIntBits(f);
        return Conv.intToByteArray(n);
    }

    public static final double byteArrayToDouble(byte[] byArray, int n) {
        long l = Conv.byteArrayToLong(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static final void doubleToByteArray(double d, byte[] byArray, int n) {
        long l = Double.doubleToLongBits(d);
        Conv.longToByteArray(l, byArray, n);
    }

    public static final byte[] doubleToByteArray(double d) {
        long l = Double.doubleToLongBits(d);
        return Conv.longToByteArray(l);
    }

    public static final String decfloat16ByteArrayToString(byte[] byArray, int n) {
        long l;
        int n2;
        int n3;
        long l2 = Conv.byteArrayToLong(byArray, n);
        long l3 = (l2 & 0x7C00000000000000L) >> 58;
        int n4 = n3 = (l2 & Long.MIN_VALUE) == Long.MIN_VALUE ? -1 : 1;
        if (l3 == 31L && n3 == 1) {
            long l4 = (l2 & 0x200000000000000L) >> 57;
            return l4 == 1L ? "SNaN" : "NaN";
        }
        if (l3 == 31L && n3 == -1) {
            long l5 = (l2 & 0x200000000000000L) >> 57;
            return l5 == 1L ? "-SNaN" : "-NaN";
        }
        if (l3 == 30L && n3 == 1) {
            return "Infinity";
        }
        if (l3 == 30L && n3 == -1) {
            return "-Infinity";
        }
        if ((l3 & 0x18L) == 24L) {
            n2 = (int)((l3 & 6L) >> 1);
            l = 8L + (l3 & 1L);
        } else {
            n2 = (int)((l3 & 0x18L) >> 3);
            l = l3 & 7L;
        }
        int n5 = (int)((l2 & 0x3FC000000000000L) >> 50);
        n5 |= n2 << 8;
        n5 -= 398;
        long l6 = l2 & 0x3FFFFFFFFFFFFL;
        int n6 = Conv.decFloatBitsToDigits((int)(l6 & 0x3FFFFFFFL));
        int n7 = Conv.decFloatBitsToDigits((int)(l6 >> 30 & 0xFFFFFL));
        n7 = (int)((long)n7 + l * 1000000L);
        int[] nArray = Conv.computeMagnitude(new int[]{n7, n6});
        byte[] byArray2 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1]};
        BigInteger bigInteger = new BigInteger(n3, byArray2);
        BigDecimal bigDecimal = new BigDecimal(bigInteger, -n5);
        return bigDecimal.toString();
    }

    public static final String decfloat34ByteArrayToString(byte[] byArray, int n) {
        long l;
        int n2;
        int n3;
        long l2 = Conv.byteArrayToLong(byArray, n);
        long l3 = Conv.byteArrayToLong(byArray, n + 8);
        long l4 = (l2 & 0x7C00000000000000L) >> 58;
        int n4 = n3 = (l2 & Long.MIN_VALUE) == Long.MIN_VALUE ? -1 : 1;
        if (l4 == 31L && n3 == 1) {
            long l5 = (l2 & 0x200000000000000L) >> 57;
            return l5 == 1L ? "SNaN" : "NaN";
        }
        if (l4 == 31L && n3 == -1) {
            long l6 = (l2 & 0x200000000000000L) >> 57;
            return l6 == 1L ? "-SNaN" : "-NaN";
        }
        if (l4 == 30L && n3 == 1) {
            return "Infinity";
        }
        if (l4 == 30L && n3 == -1) {
            return "-Infinity";
        }
        if ((l4 & 0x18L) == 24L) {
            n2 = (int)((l4 & 6L) >> 1);
            l = 8L + (l4 & 1L);
        } else {
            n2 = (int)((l4 & 0x18L) >> 3);
            l = l4 & 7L;
        }
        int n5 = (int)((l2 & 0x3FFC00000000000L) >> 46);
        n5 |= n2 << 12;
        n5 -= 6176;
        int n6 = Conv.decFloatBitsToDigits((int)(l3 & 0x3FFFFFFFL));
        int n7 = Conv.decFloatBitsToDigits((int)(l3 >> 30 & 0x3FFFFFFFL));
        int n8 = Conv.decFloatBitsToDigits((int)((l2 & 0x3FFFFFFL) << 4 | l3 >> 60 & 0xFL));
        int n9 = Conv.decFloatBitsToDigits((int)(l2 >> 26 & 0xFFFFFL));
        n9 = (int)((long)n9 + l * 1000000L);
        int[] nArray = Conv.computeMagnitude(new int[]{n9, n8, n7, n6});
        byte[] byArray2 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2], (byte)(nArray[3] >>> 24), (byte)(nArray[3] >>> 16), (byte)(nArray[3] >>> 8), (byte)nArray[3]};
        BigInteger bigInteger = new BigInteger(n3, byArray2);
        BigDecimal bigDecimal = new BigDecimal(bigInteger, -n5);
        return bigDecimal.toString();
    }

    private static final int[] computeMagnitude(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = n - 1;
        nArray2[n2] = nArray[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            int n4 = TEN_RADIX_MAGNITUDE[i].length - 1;
            int n5 = n - 1;
            while (n4 >= 0) {
                long l = ((long)nArray[n - 2 - i] & 0xFFFFFFFFL) * ((long)TEN_RADIX_MAGNITUDE[i][n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL);
                n3 = (int)(l >>> 32);
                nArray2[n5] = (int)(l & 0xFFFFFFFFL);
                --n4;
                --n5;
            }
            nArray2[n5] = n3;
        }
        return nArray2;
    }

    private static final int decFloatBitsToDigits(int n) {
        int n2 = 0;
        for (int i = 2; i >= 0; --i) {
            n2 *= 1000;
            n2 += Conv.unpackDenselyPackedDecimal((int)((long)(n >> i * 10) & 0x3FFL));
        }
        return n2;
    }

    private static int unpackDenselyPackedDecimal(int n) {
        int n2 = (n & 0xE) == 14 ? (n & 0x60) >> 5 | 4 : ((n & 8) == 8 ? (~n & 6) >> 1 : 0);
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = (n & 0x380) << 1 | n & 0x77;
                break;
            }
            case 1: {
                n3 = (n & 0x80) << 1 | n & 0x71 | (n & 0x300) >> 7 | 0x800;
                break;
            }
            case 2: {
                n3 = (n & 0x380) << 1 | n & 0x11 | (n & 0x60) >> 4 | 0x80;
                break;
            }
            case 3: {
                n3 = (n & 0x380) << 1 | n & 0x71 | 8;
                break;
            }
            case 4: {
                n3 = (n & 0x80) << 1 | n & 0x11 | (n & 0x300) >> 7 | 0x880;
                break;
            }
            case 5: {
                n3 = (n & 0x80) << 1 | n & 0x11 | (n & 0x300) >> 3 | 0x808;
                break;
            }
            case 6: {
                n3 = (n & 0x380) << 1 | n & 0x11 | 0x88;
                break;
            }
            case 7: {
                n3 = (n & 0x80) << 1 | n & 0x11 | 0x888;
            }
        }
        return ((n3 & 0xF00) >> 8) * 100 + ((n3 & 0xF0) >> 4) * 10 + (n3 & 0xF);
    }

    public static final String packedDecimalToString(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 / 2 + 1;
        int n5 = byArray[n + n4 - 1] & 0xF;
        boolean bl = n5 == 11 || n5 == 13;
        char[] cArray = new char[n2 + (n3 > 0 ? 1 : 0) + (bl ? 1 : 0)];
        return Conv.packedDecimalToString(byArray, n, n2, n3, cArray);
    }

    public static final String packedDecimalToString(byte[] byArray, int n, int n2, int n3, char[] cArray) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 % 2 == 0) {
            ++n2;
        }
        boolean bl = (n7 = byArray[n + (n6 = n2 / 2 + 1) - 1] & 0xF) == 11 || n7 == 13;
        int n8 = 0;
        if (bl) {
            cArray[n8++] = 45;
        }
        boolean bl2 = n2 % 2 != 0;
        int n9 = n2 - n3;
        boolean bl3 = false;
        for (n5 = 0; n5 < n9; ++n5) {
            n4 = (bl2 ? byArray[n] >> 4 : byArray[n]) & 0xF;
            if (bl3 || n4 != 0) {
                cArray[n8++] = NUM[n4];
                bl3 = true;
            }
            if (!bl2) {
                bl2 = true;
                ++n;
                continue;
            }
            bl2 = false;
        }
        if (n8 == 0 || bl && n8 == 1) {
            cArray[n8++] = 48;
        }
        if (n3 > 0) {
            cArray[n8++] = 46;
        }
        for (n5 = n9; n5 < n2; ++n5) {
            n4 = (bl2 ? byArray[n] >> 4 : byArray[n]) & 0xF;
            cArray[n8++] = NUM[n4];
            if (!bl2) {
                bl2 = true;
                ++n;
                continue;
            }
            bl2 = false;
        }
        return new String(cArray, 0, n8);
    }

    public static final double packedDecimalToDouble(byte[] byArray, int n, int n2, int n3) {
        double d = 0.0;
        double d2 = Math.pow(10.0, -n3);
        int n4 = n + n2 / 2;
        boolean bl = true;
        int n5 = n4;
        while (n5 >= n) {
            if (bl) {
                d += (double)((byte)((byArray[n5] & 0xF0) >> 4)) * d2;
                --n5;
            } else {
                d += (double)((byte)(byArray[n5] & 0xF)) * d2;
            }
            d2 *= 10.0;
            bl = !bl;
        }
        switch (byArray[n4] & 0xF) {
            case 11: 
            case 13: {
                d *= -1.0;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new NumberFormatException("Byte sequence not valid for packed decimal (" + n4 + ": " + (byArray[n4] & 0xF) + ").");
            }
        }
        return d;
    }

    public static final byte[] doubleToPackedDecimal(double d, int n, int n2) {
        byte[] byArray = new byte[n / 2 + 1];
        Conv.doubleToPackedDecimal(d, byArray, 0, n, n2);
        return byArray;
    }

    public static final void doubleToPackedDecimal(double d, byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        double d2 = Math.abs(d);
        if (d2 > 9.223372036854776E18) {
            throw new NumberFormatException("Double value is too big: " + d);
        }
        long l = (long)d2;
        int n6 = n3 > 15 ? 15 : n3;
        long l2 = Math.round((d2 - (double)l) * Math.pow(10.0, n6));
        int n7 = n2 / 2;
        int n8 = n + n7;
        boolean bl = true;
        int n9 = n3 - n6;
        for (n5 = 1; n5 <= n9; ++n5) {
            if (bl) {
                int n10 = n8--;
                byArray[n10] = (byte)(byArray[n10] & 0xF);
            } else {
                int n11 = n8;
                byArray[n11] = (byte)(byArray[n11] & 0xFFFFFFF0);
            }
            bl = !bl;
        }
        for (n4 = 1; n4 <= n6; ++n4) {
            n5 = (int)(l2 % 10L);
            if (bl) {
                int n12 = n8;
                byArray[n12] = (byte)(byArray[n12] & 0xF);
                int n13 = n8--;
                byArray[n13] = (byte)(byArray[n13] | (byte)n5 << 4);
            } else {
                int n14 = n8;
                byArray[n14] = (byte)(byArray[n14] & 0xFFFFFFF0);
                int n15 = n8;
                byArray[n15] = (byte)(byArray[n15] | (byte)n5);
            }
            bl = !bl;
            l2 /= 10L;
        }
        n4 = n2 - n3;
        for (int i = 1; i <= n4; ++i) {
            n5 = (int)(l % 10L);
            if (bl) {
                int n16 = n8;
                byArray[n16] = (byte)(byArray[n16] & 0xF);
                int n17 = n8--;
                byArray[n17] = (byte)(byArray[n17] | (byte)n5 << 4);
            } else {
                int n18 = n8;
                byArray[n18] = (byte)(byArray[n18] & 0xFFFFFFF0);
                int n19 = n8;
                byArray[n19] = (byte)(byArray[n19] | (byte)n5);
            }
            bl = !bl;
            l /= 10L;
        }
        while (n8 >= n) {
            if (bl) {
                int n20 = n8--;
                byArray[n20] = (byte)(byArray[n20] & 0xF);
            } else {
                int n21 = n8;
                byArray[n21] = (byte)(byArray[n21] & 0xFFFFFFF0);
            }
            bl = !bl;
        }
        int n22 = n8 = n + n7;
        byArray[n22] = (byte)(byArray[n22] & 0xFFFFFFF0);
        int n23 = n8;
        byArray[n23] = (byte)(byArray[n23] | (byte)(d >= 0.0 ? 15 : 13));
        if (l > 0L) {
            throw new NumberFormatException("Double value " + d + " too big for output array.");
        }
    }

    public static final byte[] stringToPackedDecimal(String string, int n) {
        byte[] byArray = new byte[n / 2 + 1];
        Conv.stringToPackedDecimal(string, n, byArray, 0);
        return byArray;
    }

    public static final void stringToPackedDecimal(String string, int n, byte[] byArray, int n2) {
        int n3 = n / 2 + 1;
        boolean bl = string != null && string.length() > 0 && string.charAt(0) == '-';
        int n4 = n2 + n3 - 1;
        byArray[n4] = bl ? 13 : 15;
        int n5 = bl ? 1 : 0;
        boolean bl2 = true;
        if (string != null) {
            for (int i = string.length() - 1; i >= n5; --i) {
                char c = string.charAt(i);
                if (c == '.') continue;
                int n6 = c - 48;
                if (n6 < 0 || n6 > 9) {
                    throw new NumberFormatException("Invalid character " + c);
                }
                if (bl2) {
                    int n7 = n4--;
                    byArray[n7] = (byte)(byArray[n7] | CHAR_HIGH[n6]);
                    bl2 = false;
                    continue;
                }
                byArray[n4] = CHAR_LOW[n6];
                bl2 = true;
            }
        }
    }

    public static final String zonedDecimalToString(byte[] byArray, int n, int n2, int n3) {
        int n4 = byArray[n + n2 - 1] >> 4 & 0xF;
        boolean bl = n4 == 11 || n4 == 13;
        char[] cArray = new char[n2 + (n3 > 0 ? 1 : 0) + (bl ? 1 : 0)];
        return Conv.zonedDecimalToString(byArray, n, n2, n3, cArray);
    }

    public static final String zonedDecimalToString(byte[] byArray, int n, int n2, int n3, char[] cArray) {
        int n4;
        int n5;
        int n6 = byArray[n + n2 - 1] >> 4 & 0xF;
        boolean bl = n6 == 11 || n6 == 13;
        int n7 = 0;
        boolean bl2 = false;
        if (bl) {
            cArray[n7++] = 45;
        }
        int n8 = n2 - n3;
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = byArray[n++] & 0xF;
            if (!bl2 && n4 == 0) continue;
            cArray[n7++] = NUM[n4];
            bl2 = true;
        }
        if (n7 == 0 || bl && n7 == 1) {
            cArray[n7++] = 48;
        }
        if (n3 > 0) {
            cArray[n7++] = 46;
        }
        for (n5 = n8; n5 < n2; ++n5) {
            n4 = byArray[n++] & 0xF;
            cArray[n7++] = NUM[n4];
        }
        return new String(cArray, 0, n7);
    }

    public static final long zonedDecimalToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        if (n2 <= 0) {
            return l;
        }
        int n3 = n + n2 - 1;
        for (int i = n; i <= n3; ++i) {
            l = l * 10L + (long)(byArray[i] & 0xF);
        }
        switch (byArray[n3] & 0xF0) {
            case 176: 
            case 208: {
                l = -l;
                break;
            }
            case 160: 
            case 192: 
            case 224: 
            case 240: {
                break;
            }
            default: {
                throw new NumberFormatException("Byte sequence not valid for zoned decimal (" + n3 + ": " + (byArray[n3] & 0xFF) + ").");
            }
        }
        return l;
    }

    public static final int zonedDecimalToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (n2 <= 0) {
            return n3;
        }
        int n4 = n + n2 - 1;
        for (int i = n; i <= n4; ++i) {
            n3 = n3 * 10 + (byArray[i] & 0xF);
        }
        switch (byArray[n4] & 0xF0) {
            case 176: 
            case 208: {
                n3 = -n3;
                break;
            }
            case 160: 
            case 192: 
            case 224: 
            case 240: {
                break;
            }
            default: {
                throw new NumberFormatException("Byte sequence not valid for zoned decimal (" + n4 + ": " + (byArray[n4] & 0xFF) + ").");
            }
        }
        return n3;
    }

    public static final double zonedDecimalToDouble(byte[] byArray, int n, int n2, int n3) {
        long l = 0L;
        double d = 0.0;
        double d2 = Math.pow(10.0, n3);
        int n4 = n + n2 - 1;
        for (int i = n; i <= n4; ++i) {
            l = l * 10L + (long)((byte)(byArray[i] & 0xF));
        }
        d = (double)l / d2;
        switch (byArray[n4] & 0xF0) {
            case 176: 
            case 208: {
                d *= -1.0;
                break;
            }
            case 160: 
            case 192: 
            case 224: 
            case 240: {
                break;
            }
            default: {
                throw new NumberFormatException("Byte sequence not valid for zoned decimal (" + n4 + ": " + (byArray[n4] & 0xFF) + ").");
            }
        }
        return d;
    }

    public static final byte[] doubleToZonedDecimal(double d, int n, int n2) {
        byte[] byArray = new byte[n];
        Conv.doubleToZonedDecimal(d, byArray, 0, n, n2);
        return byArray;
    }

    public static final void doubleToZonedDecimal(double d, byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        double d2 = Math.abs(d);
        if (d2 > 9.223372036854776E18) {
            throw new NumberFormatException("Double value is too big: " + d);
        }
        long l = (long)d2;
        int n7 = n3 > 15 ? 15 : n3;
        long l2 = Math.round((d2 - (double)l) * Math.pow(10.0, n7));
        int n8 = n + n2 - 1;
        int n9 = n8 - (n3 - n7);
        for (n6 = n8; n6 > n9; --n6) {
            byArray[n6] = -16;
        }
        n6 = n8 - n3;
        for (n5 = n9; n5 > n6; --n5) {
            n4 = (int)(l2 % 10L);
            byArray[n5] = (byte)(0xF0 | n4);
            l2 /= 10L;
        }
        for (n5 = n6; n5 >= n; --n5) {
            n4 = (int)(l % 10L);
            byArray[n5] = (byte)(0xF0 | n4);
            l /= 10L;
        }
        if (d < 0.0) {
            byArray[n8] = (byte)(byArray[n8] & 0xDF);
        }
        if (l > 0L) {
            throw new NumberFormatException("Double value " + d + " too big for output array.");
        }
    }

    public static final void longToZonedDecimal(long l, byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        boolean bl = l < 0L;
        for (int i = n3; i >= n; --i) {
            int n4 = (int)(l % 10L);
            byArray[i] = (byte)(0xF0 | n4);
            l /= 10L;
        }
        if (bl) {
            byArray[n3] = (byte)(byArray[n3] & 0xDF);
        }
        if (l != 0L) {
            throw new NumberFormatException("Long value too big for ZONED(" + n2 + ",0).");
        }
    }

    public static final byte[] stringToZonedDecimal(String string, int n) {
        byte[] byArray = new byte[n];
        Conv.stringToZonedDecimal(string, n, byArray, 0);
        return byArray;
    }

    public static final void stringToZonedDecimal(String string, int n, byte[] byArray, int n2) {
        int n3;
        int n4 = n2 + n - 1;
        boolean bl = string != null && string.length() > 0 && string.charAt(0) == '-';
        int n5 = n3 = bl ? 1 : 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= n3; --i) {
                char c = string.charAt(i);
                if (c == '.') continue;
                int n6 = c - 48;
                if (n6 < 0 || n6 > 9) {
                    throw new NumberFormatException("Invalid character " + c);
                }
                byArray[n4--] = (byte)(CHAR_LOW[n6] | 0xF0);
            }
        }
        if (bl) {
            byArray[n2 + n - 1] = (byte)(byArray[n2 + n - 1] & 0xF | 0xFFFFFFD0);
        }
    }

    public static String getDefaultNLV() {
        if (localeNlvMap_ == null) {
            localeNlvMap_ = new Hashtable(100);
            localeNlvMap_.put("ar", "2954");
            localeNlvMap_.put("ar_SA", "2954");
            localeNlvMap_.put("be", "2979");
            localeNlvMap_.put("bg", "2974");
            localeNlvMap_.put("ca", "2931");
            localeNlvMap_.put("cs", "2975");
            localeNlvMap_.put("da", "2926");
            localeNlvMap_.put("de", "2929");
            localeNlvMap_.put("de_CH", "2939");
            localeNlvMap_.put("de_DE", "2929");
            localeNlvMap_.put("el", "2957");
            localeNlvMap_.put("en", "2924");
            localeNlvMap_.put("en_BE", "2909");
            localeNlvMap_.put("en_CN", "2984");
            localeNlvMap_.put("en_JP", "2938");
            localeNlvMap_.put("en_KR", "2984");
            localeNlvMap_.put("en_SG", "2984");
            localeNlvMap_.put("en_TW", "2984");
            localeNlvMap_.put("es", "2931");
            localeNlvMap_.put("es_ES", "2931");
            localeNlvMap_.put("et", "2902");
            localeNlvMap_.put("fa", "2998");
            localeNlvMap_.put("fi", "2925");
            localeNlvMap_.put("fr", "2928");
            localeNlvMap_.put("fr_BE", "2966");
            localeNlvMap_.put("fr_CA", "2981");
            localeNlvMap_.put("fr_CH", "2940");
            localeNlvMap_.put("fr_FR", "2928");
            localeNlvMap_.put("hr", "2912");
            localeNlvMap_.put("hu", "2976");
            localeNlvMap_.put("is", "2958");
            localeNlvMap_.put("it", "2932");
            localeNlvMap_.put("it_CH", "2942");
            localeNlvMap_.put("iw", "2961");
            localeNlvMap_.put("ja", "2962");
            localeNlvMap_.put("ji", "2961");
            localeNlvMap_.put("ka", "2979");
            localeNlvMap_.put("kk", "2979");
            localeNlvMap_.put("ko", "2986");
            localeNlvMap_.put("ko_KR", "2986");
            localeNlvMap_.put("lo", "2906");
            localeNlvMap_.put("lt", "2903");
            localeNlvMap_.put("lv", "2904");
            localeNlvMap_.put("mk", "2913");
            localeNlvMap_.put("nl", "2923");
            localeNlvMap_.put("nl_BE", "2963");
            localeNlvMap_.put("nl_NL", "2923");
            localeNlvMap_.put("no", "2933");
            localeNlvMap_.put("pl", "2978");
            localeNlvMap_.put("pt", "2996");
            localeNlvMap_.put("pt_BR", "2980");
            localeNlvMap_.put("pt_PT", "2922");
            localeNlvMap_.put("ro", "2992");
            localeNlvMap_.put("ru", "2979");
            localeNlvMap_.put("sh", "2912");
            localeNlvMap_.put("sk", "2994");
            localeNlvMap_.put("sl", "2911");
            localeNlvMap_.put("sq", "2995");
            localeNlvMap_.put("sr", "2914");
            localeNlvMap_.put("sv", "2937");
            localeNlvMap_.put("sv_SE", "2937");
            localeNlvMap_.put("th", "2972");
            localeNlvMap_.put("th_TH", "2972");
            localeNlvMap_.put("tr", "2956");
            localeNlvMap_.put("uk", "2979");
            localeNlvMap_.put("uz", "2979");
            localeNlvMap_.put("vi", "2905");
            localeNlvMap_.put("zh", "2989");
            localeNlvMap_.put("zh_CN", "2989");
            localeNlvMap_.put("zh_HK", "2987");
            localeNlvMap_.put("zh_SG", "2989");
            localeNlvMap_.put("zh_TW", "2987");
            localeNlvMap_.put("cht", "2987");
            localeNlvMap_.put("cht_CN", "2987");
        }
        String string = null;
        try {
            int n;
            String string2;
            Locale locale = Locale.getDefault();
            if (locale != null && (string = (String)localeNlvMap_.get(string2 = locale.toString())) == null && (n = string2.indexOf(95)) > 0) {
                string2 = string2.substring(0, n);
                string = (String)localeNlvMap_.get(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = "2924";
        }
        return string;
    }

    static {
        int n;
        NUM = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        CHAR_HIGH = new byte[10];
        CHAR_LOW = new byte[10];
        for (n = 0; n <= 9; ++n) {
            int n2 = n;
            Conv.CHAR_HIGH[n] = (byte)(n2 << 4);
            Conv.CHAR_LOW[n] = (byte)n2;
        }
        CONV_TO_37 = new byte[65536];
        INIT_TO_37 = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -70, -32, -69, -80, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, 74, -79, -97, -78, 106, -75, -67, -76, -102, -118, 95, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        CONV_FROM_37 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\u0085', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '^', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '[', ']', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        CACHE_FROM_37 = new String[256];
        System.arraycopy(INIT_TO_37, 0, CONV_TO_37, 0, INIT_TO_37.length);
        for (n = INIT_TO_37.length; n < CONV_TO_37.length; ++n) {
            Conv.CONV_TO_37[n] = 63;
        }
        Object object = new char[1];
        Object object2 = new byte[1];
        for (int i = 0; i < CACHE_FROM_37.length; ++i) {
            object2[0] = (byte)i;
            Conv.CACHE_FROM_37[i] = Conv.ebcdicByteArrayToString(object2, 0, 1, (char[])object);
        }
        cacheFrom37Init_ = true;
        encodingCcsid_ = new HashMap();
        ccsidEncoding_ = new HashMap();
        encodings_ = new String[65536];
        encodingCcsid_.put("ASCII", "367");
        encodingCcsid_.put("Cp1252", "1252");
        encodingCcsid_.put("ISO8859_1", "819");
        encodingCcsid_.put("Unicode", "13488");
        encodingCcsid_.put("UnicodeBig", "13488");
        encodingCcsid_.put("UnicodeLittle", "1202");
        encodingCcsid_.put("UTF8", "1208");
        encodingCcsid_.put("UTF-8", "1208");
        encodingCcsid_.put("UTF-16BE", "1200");
        encodingCcsid_.put("Big5", "950");
        encodingCcsid_.put("CNS11643", "964");
        encodingCcsid_.put("Cp037", "37");
        encodingCcsid_.put("Cp256", "256");
        encodingCcsid_.put("Cp273", "273");
        encodingCcsid_.put("Cp277", "277");
        encodingCcsid_.put("Cp278", "278");
        encodingCcsid_.put("Cp280", "280");
        encodingCcsid_.put("Cp284", "284");
        encodingCcsid_.put("Cp285", "285");
        encodingCcsid_.put("Cp290", "290");
        encodingCcsid_.put("Cp297", "297");
        encodingCcsid_.put("Cp420", "420");
        encodingCcsid_.put("Cp423", "423");
        encodingCcsid_.put("Cp424", "424");
        encodingCcsid_.put("Cp437", "437");
        encodingCcsid_.put("Cp500", "500");
        encodingCcsid_.put("Cp737", "737");
        encodingCcsid_.put("Cp775", "775");
        encodingCcsid_.put("Cp833", "833");
        encodingCcsid_.put("Cp838", "838");
        encodingCcsid_.put("Cp850", "850");
        encodingCcsid_.put("Cp852", "852");
        encodingCcsid_.put("Cp855", "855");
        encodingCcsid_.put("Cp856", "856");
        encodingCcsid_.put("Cp857", "857");
        encodingCcsid_.put("Cp858", "858");
        encodingCcsid_.put("Cp860", "860");
        encodingCcsid_.put("Cp861", "861");
        encodingCcsid_.put("Cp862", "862");
        encodingCcsid_.put("Cp863", "863");
        encodingCcsid_.put("Cp864", "864");
        encodingCcsid_.put("Cp865", "865");
        encodingCcsid_.put("Cp866", "866");
        encodingCcsid_.put("Cp868", "868");
        encodingCcsid_.put("Cp869", "869");
        encodingCcsid_.put("Cp870", "870");
        encodingCcsid_.put("Cp871", "871");
        encodingCcsid_.put("Cp874", "874");
        encodingCcsid_.put("Cp875", "875");
        encodingCcsid_.put("Cp880", "880");
        encodingCcsid_.put("Cp905", "905");
        encodingCcsid_.put("Cp918", "918");
        encodingCcsid_.put("Cp921", "921");
        encodingCcsid_.put("Cp922", "922");
        encodingCcsid_.put("Cp923", "923");
        encodingCcsid_.put("Cp924", "924");
        encodingCcsid_.put("Cp930", "930");
        encodingCcsid_.put("Cp933", "933");
        encodingCcsid_.put("Cp935", "935");
        encodingCcsid_.put("Cp937", "937");
        encodingCcsid_.put("Cp939", "939");
        encodingCcsid_.put("Cp942", "942");
        encodingCcsid_.put("Cp943", "943");
        encodingCcsid_.put("Cp948", "948");
        encodingCcsid_.put("Cp949", "949");
        encodingCcsid_.put("Cp950", "950");
        encodingCcsid_.put("Cp964", "964");
        encodingCcsid_.put("Cp970", "970");
        encodingCcsid_.put("Cp1006", "1006");
        encodingCcsid_.put("Cp1025", "1025");
        encodingCcsid_.put("Cp1026", "1026");
        encodingCcsid_.put("Cp1027", "1027");
        encodingCcsid_.put("Cp1046", "1046");
        encodingCcsid_.put("Cp1097", "1097");
        encodingCcsid_.put("Cp1098", "1098");
        encodingCcsid_.put("Cp1112", "1112");
        encodingCcsid_.put("Cp1122", "1122");
        encodingCcsid_.put("Cp1123", "1123");
        encodingCcsid_.put("Cp1124", "1124");
        encodingCcsid_.put("Cp1130", "1130");
        encodingCcsid_.put("Cp1132", "1132");
        encodingCcsid_.put("Cp1137", "1137");
        encodingCcsid_.put("Cp1140", "1140");
        encodingCcsid_.put("Cp1141", "1141");
        encodingCcsid_.put("Cp1142", "1142");
        encodingCcsid_.put("Cp1143", "1143");
        encodingCcsid_.put("Cp1144", "1144");
        encodingCcsid_.put("Cp1145", "1145");
        encodingCcsid_.put("Cp1146", "1146");
        encodingCcsid_.put("Cp1147", "1147");
        encodingCcsid_.put("Cp1148", "1148");
        encodingCcsid_.put("Cp1149", "1149");
        encodingCcsid_.put("Cp1153", "1153");
        encodingCcsid_.put("Cp1154", "1154");
        encodingCcsid_.put("Cp1155", "1155");
        encodingCcsid_.put("Cp1156", "1156");
        encodingCcsid_.put("Cp1157", "1157");
        encodingCcsid_.put("Cp1158", "1158");
        encodingCcsid_.put("Cp1160", "1160");
        encodingCcsid_.put("Cp1164", "1164");
        encodingCcsid_.put("Cp1250", "1250");
        encodingCcsid_.put("Cp1251", "1251");
        encodingCcsid_.put("Cp1253", "1253");
        encodingCcsid_.put("Cp1254", "1254");
        encodingCcsid_.put("Cp1255", "1255");
        encodingCcsid_.put("Cp1256", "1256");
        encodingCcsid_.put("Cp1257", "1257");
        encodingCcsid_.put("Cp1258", "1258");
        encodingCcsid_.put("Cp1364", "1364");
        encodingCcsid_.put("Cp1381", "1381");
        encodingCcsid_.put("Cp1383", "1383");
        encodingCcsid_.put("Cp1388", "1388");
        encodingCcsid_.put("Cp1399", "1399");
        encodingCcsid_.put("Cp4971", "4971");
        encodingCcsid_.put("Cp5123", "5123");
        encodingCcsid_.put("Cp9030", "9030");
        encodingCcsid_.put("Cp13121", "13121");
        encodingCcsid_.put("Cp13124", "13124");
        encodingCcsid_.put("Cp28709", "28709");
        encodingCcsid_.put("Cp33722", "33722");
        encodingCcsid_.put("EUC_CN", "1383");
        encodingCcsid_.put("EUC_JP", "33722");
        encodingCcsid_.put("EUC_KR", "970");
        encodingCcsid_.put("EUC_TW", "964");
        encodingCcsid_.put("GB2312", "1381");
        encodingCcsid_.put("GB18030", "1392");
        encodingCcsid_.put("GBK", "1386");
        encodingCcsid_.put("ISO2022JP", "5054");
        encodingCcsid_.put("ISO2022KR", "25546");
        encodingCcsid_.put("ISO8859_2", "912");
        encodingCcsid_.put("ISO8859_3", "913");
        encodingCcsid_.put("ISO8859_4", "914");
        encodingCcsid_.put("ISO8859_5", "915");
        encodingCcsid_.put("ISO8859_6", "1089");
        encodingCcsid_.put("ISO8859_7", "813");
        encodingCcsid_.put("ISO8859_8", "916");
        encodingCcsid_.put("ISO8859_9", "920");
        encodingCcsid_.put("JIS0201", "897");
        encodingCcsid_.put("JIS0208", "952");
        encodingCcsid_.put("JIS0212", "953");
        encodingCcsid_.put("Johab", "1363");
        encodingCcsid_.put("KOI8_R", "878");
        encodingCcsid_.put("KSC5601", "949");
        encodingCcsid_.put("MS874", "874");
        encodingCcsid_.put("MS932", "943");
        encodingCcsid_.put("MS936", "1386");
        encodingCcsid_.put("MS949", "949");
        encodingCcsid_.put("MS950", "950");
        encodingCcsid_.put("MacCentralEurope", "1282");
        encodingCcsid_.put("MacCroatian", "1284");
        encodingCcsid_.put("MacCyrillic", "1283");
        encodingCcsid_.put("MacGreek", "1280");
        encodingCcsid_.put("MacIceland", "1286");
        encodingCcsid_.put("MacRoman", "1275");
        encodingCcsid_.put("MacRomania", "1285");
        encodingCcsid_.put("MacTurkish", "1281");
        encodingCcsid_.put("SJIS", "932");
        encodingCcsid_.put("TIS620", "874");
        object = encodingCcsid_.keySet().iterator();
        while (object.hasNext()) {
            object2 = object.next();
            ccsidEncoding_.put(encodingCcsid_.get(object2), object2);
        }
        ccsidEncoding_.put("13488", "UTF-16BE");
        ccsidEncoding_.put("61952", "UTF-16BE");
        ccsidEncoding_.put("17584", "UTF-16BE");
        object = ccsidEncoding_.keySet().iterator();
        while (object.hasNext()) {
            object2 = (String)object.next();
            String string = (String)ccsidEncoding_.get(object2);
            int n3 = new Integer((String)object2);
            Conv.encodings_[n3] = string;
        }
        TEN_RADIX_MAGNITUDE = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};
    }
}

