/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

public final class ByteArrayKey {
    private byte[] key_;
    private int offset_;
    private int length_;
    private int hash_;

    public ByteArrayKey() {
    }

    public ByteArrayKey(byte[] byArray) {
        this.key_ = byArray;
        this.offset_ = 0;
        this.length_ = byArray.length;
        this.hash_ = ByteArrayKey.computeHash(byArray, 0, byArray.length);
    }

    private static final int computeHash(byte[] byArray, int n, int n2) {
        return byArray[n] + byArray[n + n2 - 1] + byArray[n + (n2 >> 1)];
    }

    public void setHashData(byte[] byArray, int n, int n2) {
        this.key_ = byArray;
        this.offset_ = n;
        this.length_ = n2;
        this.hash_ = ByteArrayKey.computeHash(byArray, n, n2);
    }

    public int hashCode() {
        return this.hash_;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ByteArrayKey) {
            ByteArrayKey byteArrayKey = (ByteArrayKey)object;
            return this.matches(byteArrayKey.key_, byteArrayKey.offset_, byteArrayKey.length_);
        }
        return false;
    }

    public byte[] getKey() {
        return this.key_;
    }

    public int getOffset() {
        return this.offset_;
    }

    public int getLength() {
        return this.length_;
    }

    public boolean matches(byte[] byArray, int n, int n2) {
        if (this.length_ != n2) {
            return false;
        }
        for (int i = 0; i < this.length_; ++i) {
            if (this.key_[this.offset_ + i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }
}

