/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template;

import java.util.ArrayList;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.template.TemplateVariableProposal;
import miworkplace.ui.themes.Colors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TemplateDialog
extends TitleAreaDialog {
    private static final String[] CONTEXTS = new String[]{"CL", "ILEDocs", "RPG", "Snippets", "Other"};
    private static final String[] CATEGORIES = new String[]{"CL", "RPG", "Other"};
    private Template template;
    private Combo comboCategory;
    private Combo comboContext;
    private Text txtName;
    private Text txtDescription;
    private SourceViewer txtTemplate;

    public TemplateDialog(Shell shell, Template template) {
        super(shell);
        this.template = template;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.template.getName() == null) {
            this.setTitle(Messages.editor_template_dialog_new_title);
            this.setMessage(Messages.editor_template_dialog_new_desc);
            parent.getShell().setText(Messages.editor_template_dialog_new_title);
        } else {
            this.setTitle(Messages.editor_template_dialog_edit_title);
            this.setMessage(String.format(Messages.editor_template_dialog_edit_desc, this.template.getName()));
            parent.getShell().setText(Messages.editor_template_dialog_edit_title);
        }
        this.setTitleImage(new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/template-wizard.png")));
        Composite p = (Composite)super.createDialogArea(parent);
        Composite controls = this.buildControls(p);
        this.initializeControls();
        return controls;
    }

    private void initializeControls() {
        this.txtTemplate.setDocument((IDocument)new Document());
        if (this.template.getName() != null) {
            this.txtName.setText(this.template.getName());
            this.txtDescription.setText(this.template.getDescription());
            this.txtTemplate.getDocument().set(this.template.getCode());
            if (this.template.getContext() != null) {
                this.comboContext.select(this.comboContext.indexOf(this.template.getContext()));
            }
            if (this.template.getCategory() != null) {
                this.comboCategory.setEnabled(true);
                this.comboCategory.select(this.comboCategory.indexOf(this.template.getCategory()));
            }
        }
    }

    private Composite buildControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite controls = new Composite(parent, 0);
        controls.setLayoutData((Object)new GridData(4, 4, true, true));
        FormLayout parentLayout = new FormLayout();
        parentLayout.marginHeight = 15;
        parentLayout.marginWidth = 15;
        controls.setLayout((Layout)parentLayout);
        FormData formData = new FormData();
        Label lblName = new Label(controls, 0);
        lblName.setText(Messages.editor_template_dialog_form_name);
        lblName.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)lblName, 125, 16384);
        formData.bottom = new FormAttachment((Control)lblName, 0, 0x1000000);
        formData.right = new FormAttachment(100);
        this.txtName = new Text(controls, 2048);
        this.txtName.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblName, 25);
        Label lblContext = new Label(controls, 0);
        lblContext.setLayoutData((Object)formData);
        lblContext.setText(Messages.editor_template_dialog_form_context);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.txtName, 0, 16384);
        formData.bottom = new FormAttachment((Control)lblContext, 0, 0x1000000);
        this.comboContext = new Combo(controls, 8);
        this.comboContext.setItems(CONTEXTS);
        this.comboContext.setLayoutData((Object)formData);
        this.comboContext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateDialog.this.comboContext.getText().equals("Snippets")) {
                    TemplateDialog.this.comboCategory.setEnabled(true);
                } else {
                    TemplateDialog.this.comboCategory.setEnabled(false);
                }
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblContext, 25);
        Label lblCategory = new Label(controls, 0);
        lblCategory.setText(Messages.editor_template_dialog_form_category);
        lblCategory.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.txtName, 0, 16384);
        formData.bottom = new FormAttachment((Control)lblCategory, 0, 0x1000000);
        this.comboCategory = new Combo(controls, 8);
        this.comboCategory.setItems(CATEGORIES);
        this.comboCategory.setEnabled(false);
        this.comboCategory.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblCategory, 25);
        Label lblDescription = new Label(controls, 0);
        lblDescription.setText(Messages.editor_template_dialog_form_desc);
        lblDescription.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.txtName, 0, 16384);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)lblDescription, 0, 0x1000000);
        this.txtDescription = new Text(controls, 2048);
        this.txtDescription.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblDescription, 25);
        Label lblTemplate = new Label(controls, 0);
        lblTemplate.setText(Messages.editor_template_dialog_form_template);
        lblTemplate.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblTemplate, 0, 128);
        formData.left = new FormAttachment((Control)this.txtName, 0, 16384);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100);
        this.txtTemplate = this.buildViewer(controls);
        this.txtTemplate.getTextWidget().setLayoutData((Object)formData);
        return controls;
    }

    private SourceViewer buildViewer(Composite parent) {
        final SourceViewer viewer = new SourceViewer(parent, null, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getTextFont());
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant ca = new ContentAssistant();
                ca.setContentAssistProcessor((IContentAssistProcessor)new TemplateVariableProcessor(), "__dftl_partition_content_type");
                ca.setInformationControlCreator(new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        return new DefaultInformationControl(parent);
                    }
                });
                ca.setProposalSelectorForeground(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
                ca.setProposalSelectorBackground(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
                return ca;
            }
        };
        viewer.configure(configuration);
        viewer.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.character == ' ') {
                    if (viewer.canDoOperation(13)) {
                        viewer.doOperation(13);
                    }
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    protected void okPressed() {
        if (this.isValid()) {
            this.applyValues();
            super.okPressed();
        }
    }

    private void applyValues() {
        this.template.setName(this.txtName.getText());
        this.template.setDescription(this.txtDescription.getText());
        this.template.setContext(this.comboContext.getText());
        this.template.setCategory(!this.comboCategory.isEnabled() ? null : this.comboCategory.getText());
        this.template.setCode(this.txtTemplate.getDocument().get());
    }

    private boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.txtName.getText())) {
            this.setErrorMessage(Messages.editor_template_dialog_error_noname);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.txtTemplate.getTextWidget().getText())) {
            this.setErrorMessage(Messages.editor_template_dialog_error_notext);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.comboContext.getText())) {
            this.setErrorMessage(Messages.editor_template_dialog_error_noctx);
            return false;
        }
        return true;
    }

    protected boolean isResizable() {
        return true;
    }

    class TemplateVariableProcessor
    implements IContentAssistProcessor {
        private List<ICompletionProposal> availableProposals = new ArrayList<ICompletionProposal>();

        public TemplateVariableProcessor() {
            this.availableProposals.add(new TemplateVariableProposal("${cursor}", Messages.editor_template_dialog_proposal_cursor));
            this.availableProposals.add(new TemplateVariableProposal("${line_selection}", Messages.editor_template_dialog_proposal_line));
            this.availableProposals.add(new TemplateVariableProposal("${word_selection}", Messages.editor_template_dialog_proposal_word));
            this.availableProposals.add(new TemplateVariableProposal("${date}", Messages.editor_template_dialog_proposal_date));
            this.availableProposals.add(new TemplateVariableProposal("${user}", Messages.editor_template_dialog_proposal_user));
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            return this.availableProposals.toArray(new ICompletionProposal[this.availableProposals.size()]);
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }
    }
}

