/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.pref;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.pref.ContentTypesPreferenceNode;
import miworkplace.ui.editor.pref.TaskTagsPreferenceNode;
import miworkplace.ui.editor.pref.TemplatesPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceProvider;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.IValidator;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.ValidationException;

public class EditorPreferenceProvider
implements IPreferenceProvider {
    private List<IPreferenceNode> preferenceNodes = new LinkedList<IPreferenceNode>();
    private IPreferencesService service;
    private IContentTypeRegistry registry;
    private ITemplateService templateService;

    public void bindTemplateService(ITemplateService service) {
        this.templateService = service;
    }

    public void unbindTemplateService(ITemplateService service) {
        this.templateService = null;
    }

    void activate() {
        PreferenceNode editorNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.editor").setName(Messages.editor_pref_editor_title);
        editorNode.setPreferences(this.buildEditorPreferences());
        this.preferenceNodes.add((IPreferenceNode)editorNode);
        this.preferenceNodes.add((IPreferenceNode)new ContentTypesPreferenceNode(this.registry));
        this.preferenceNodes.add((IPreferenceNode)new TemplatesPreferenceNode(this.templateService));
        this.preferenceNodes.add((IPreferenceNode)new TaskTagsPreferenceNode());
        if (this.service != null) {
            for (IPreferenceNode n : this.preferenceNodes) {
                this.service.add(n);
            }
        }
    }

    private Set<Preference> buildEditorPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.editor.highlight");
        preference.setType(Boolean.class);
        preference.setName(Messages.editor_pref_editor_highlight);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(1));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.linenumbers");
        preference.setType(Boolean.class);
        preference.setName(Messages.editor_pref_editor_linenumbers);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(2));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.spacesfortabs");
        preference.setType(Boolean.class);
        preference.setName(Messages.editor_pref_editor_spaces);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(3));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.tabwidth");
        preference.setType(Integer.class);
        preference.setName(Messages.editor_pref_editor_tab);
        preference.setValue("4");
        preference.setOrder(Integer.valueOf(4));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.printmargin");
        preference.setType(Boolean.class);
        preference.setName(Messages.editor_pref_editor_print);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(5));
        preference.setDescription(Messages.editor_pref_editor_print_desc);
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.printmarginvalue");
        preference.setType(Integer.class);
        preference.setName(Messages.editor_pref_editor_margin);
        preference.setValue("80");
        preference.setOrder(Integer.valueOf(6));
        preference.setDescription(Messages.editor_pref_editor_margin_desc);
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.line.number.incrementation");
        preference.setType(String.class);
        preference.setName(Messages.editor_pref_editor_inc);
        preference.setValue("1.00");
        preference.setOrder(Integer.valueOf(7));
        preference.addValidator(new IValidator(){

            public void validate(String value) throws ValidationException {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    throw new ValidationException(Messages.editor_pref_editor_inc_error + value, (Exception)nfe);
                }
            }
        });
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.endjob.delay");
        preference.setType(Integer.class);
        preference.setName(Messages.editor_pref_editor_endjob);
        preference.setValue("30");
        preference.setOrder(Integer.valueOf(8));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.editor.retain5250sourcecoloring");
        preference.setType(Boolean.class);
        preference.setName(Messages.EditorPreferenceProvider_retain_5250_colr);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(9));
        preferences.add(preference);
        return preferences;
    }

    public void bindPreferenceService(IPreferencesService service) {
        this.service = service;
        if (!this.preferenceNodes.isEmpty()) {
            for (IPreferenceNode n : this.preferenceNodes) {
                service.add(n);
            }
        }
    }

    public void unbindPreferenceService(IPreferencesService service) {
        this.service = null;
    }

    public void bindContentTypeRegistry(IContentTypeRegistry registry) {
        this.registry = registry;
    }

    public void unbindContentTypeRegistry(IContentTypeRegistry registry) {
        this.registry = null;
    }
}

