/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.include;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import miworkplace.ast.rpg.AST;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.ui.editor.ConnectionJobRule;
import miworkplace.ui.editor.include.IIncludeService;
import miworkplace.ui.editor.include.IncludeData;
import miworkplace.ui.editor.include.IncludeLoader;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Include;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;

public class IncludePathLoadingStarter
implements EventHandler {
    private Cache<String, IncludeData> startedLoaders = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
    private IConnectionManager connectionManager;
    private LogService logger;
    private IJobChangeListener jobListener = new IncludeLoaderListener();
    private IIncludeService includeService;

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public void bindConnectionManager(IConnectionManager connManager) {
        this.connectionManager = connManager;
    }

    public void unbindConnectionManager(IConnectionManager connManager) {
        this.connectionManager = null;
    }

    public void bindIncludeService(IIncludeService includeService) {
        this.includeService = includeService;
    }

    public void unbindIncludeService(IIncludeService includeService) {
        this.includeService = null;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/editor/reconciled")) {
            Object ast = event.getProperty("org.eclipse.e4.data");
            String inputUri = event.getProperty("inputUri").toString();
            String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
            String ifsPath = EditorInputUriUtil.getMemberPath((String)inputUri);
            if (ast instanceof Ast || ast instanceof AST) {
                IncludeData includeData = new IncludeData();
                includeData.setConnectionName(connectionName);
                includeData.setUnqualifiedIncludePath(ifsPath);
                includeData.setQualifiedIncludePath(ifsPath);
                includeData.setData(event.getProperty("content").toString());
                includeData.setType(IncludeData.Type.Rpg);
                this.includeService.addIncludeData(ifsPath, includeData);
                this.processIncludes(ast, inputUri, connectionName);
            }
        } else if (event.getTopic().equals("miworkplace/editor/cache/clear")) {
            String inputUri = event.getProperty("org.eclipse.e4.data").toString();
            Object ast = event.getProperty("ast");
            if (ast != null) {
                String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
                String ifsPath = EditorInputUriUtil.getMemberPath((String)inputUri);
                List<String> includePaths = this.getIncludePaths(ast);
                for (String path : includePaths) {
                    this.includeService.setIncludeDataExpired(connectionName, ifsPath, path);
                    this.processIncludes(ast, inputUri, connectionName);
                }
            }
        }
    }

    private void processIncludes(Object data, String inputUri, String connectionName) {
        if (data instanceof Ast) {
            this.processFreeRpgModel((Ast)data, inputUri, connectionName);
        } else if (data instanceof AST) {
            this.processFixedRpgModel((AST)data, inputUri, connectionName);
        }
    }

    private List<String> getIncludePaths(Object ast) {
        ArrayList<String> includePaths = new ArrayList<String>();
        if (ast instanceof Ast) {
            List includes = ((Ast)ast).listIncludes();
            for (Include include : includes) {
                includePaths.add(include.getFileUnquoted());
            }
        }
        return includePaths;
    }

    private void processFixedRpgModel(AST ast, String inputUri, String connectionName) {
        miworkplace.ast.rpg.token.Include[] includes;
        miworkplace.ast.rpg.token.Include[] includeArray = includes = ast.getIncludes();
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            miworkplace.ast.rpg.token.Include include = includeArray[n2];
            String includeFilename = StringUtils.strip((String)include.getIncludedFile(), (String)"'");
            String includeInputUri = EditorInputUriUtil.buildInputUri((String)connectionName, (String)includeFilename);
            this.loadIncludeFile(inputUri, connectionName, includeFilename, includeInputUri, null);
            ++n2;
        }
    }

    protected void processFreeRpgModel(Ast ast, String inputUri, String connectionName) {
        List includes = ast.listIncludes();
        for (Include include : includes) {
            String includeFilename = include.getFileUnquoted();
            String includeInputUri = EditorInputUriUtil.buildInputUri((String)connectionName, (String)includeFilename);
            this.loadIncludeFile(inputUri, connectionName, includeFilename, includeInputUri, include.getQualifiedPath());
        }
    }

    protected void loadIncludeFile(String inputUri, String connectionName, String includeFilename, String includeInputUri, String qualifiedIncludePath) {
        if (StringUtils.isEmpty((CharSequence)qualifiedIncludePath)) {
            return;
        }
        try {
            String sourcePath = EditorInputUriUtil.getMemberPath((String)inputUri);
            IConnection connection = this.connectionManager.get(connectionName);
            if (this.includeService.containsInclude(connectionName, sourcePath, includeFilename)) {
                this.logger.log(4, "Already loaded include " + includeFilename);
                return;
            }
            if (this.startedLoaders.asMap().containsKey(includeInputUri)) {
                this.logger.log(4, "Already loading include " + includeFilename);
                return;
            }
            IncludeLoader job = new IncludeLoader(connection, qualifiedIncludePath, this.logger);
            job.setProperty(new QualifiedName(null, "includeUri"), includeInputUri);
            job.setProperty(new QualifiedName(null, "inputUri"), inputUri);
            job.setRule(new ConnectionJobRule(connection.getName()));
            job.addJobChangeListener(this.jobListener);
            job.schedule();
            IncludeData includeData = new IncludeData();
            includeData.setConnectionName(connectionName);
            includeData.setUnqualifiedIncludePath(includeFilename);
            includeData.setQualifiedIncludePath(qualifiedIncludePath);
            this.startedLoaders.put((Object)includeInputUri, (Object)includeData);
        }
        catch (Exception e) {
            this.logger.log(1, "Could not start include loader for " + includeFilename, (Throwable)e);
        }
    }

    class IncludeLoaderListener
    extends JobChangeAdapter {
        IncludeLoaderListener() {
        }

        public void done(IJobChangeEvent event) {
            Job job = event.getJob();
            String includeUri = job.getProperty(new QualifiedName(null, "includeUri")).toString();
            String inputUri = job.getProperty(new QualifiedName(null, "inputUri")).toString();
            String sourcePath = EditorInputUriUtil.getMemberPath((String)inputUri);
            String includeCode = ((IncludeLoader)job).getIncludeCode();
            IncludeData includeData = (IncludeData)IncludePathLoadingStarter.this.startedLoaders.asMap().get(includeUri);
            includeData.setData(includeCode);
            includeData.setType(IncludeData.Type.Rpg);
            IncludePathLoadingStarter.this.includeService.addIncludeData(sourcePath, includeData);
            IncludePathLoadingStarter.this.startedLoaders.invalidate((Object)includeUri);
        }
    }
}

