/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.include;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SequentialFile;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import miworkplace.common.model.IConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.log.LogService;

public class IncludeLoader
extends Job {
    private IConnection connection;
    private String includePath;
    private String includeCode;
    private LogService logger;

    public IncludeLoader(IConnection connection, String includePath, LogService logger) {
        super("Loading include " + includePath);
        this.connection = connection;
        this.includePath = includePath;
        this.logger = logger;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.includeCode = this.includePath.toUpperCase().startsWith("/QSYS.LIB/") ? this.loadSourceMember() : this.loadStreamFile();
        }
        catch (Exception e) {
            this.logger.log(1, "Could not load include file " + this.includePath, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private String loadSourceMember() throws Exception {
        StringBuilder content = new StringBuilder();
        try (SequentialFile file = new SequentialFile(this.connection.getSystem(), this.includePath);){
            file.setRecordFormat();
            Record[] records = file.readAll();
            int i = 0;
            while (i < records.length) {
                content.append(StringUtils.stripEnd((String)records[i].getField(2).toString().replaceAll("\\s+$", ""), null) + "\n");
                ++i;
            }
        }
        return content.toString();
    }

    protected String loadStreamFile() throws Exception {
        IFSFile remoteStreamFile = new IFSFile(this.connection.getSystem(), this.includePath);
        if (!remoteStreamFile.exists()) {
            this.logger.log(3, "Include file does not exist: " + this.includePath);
        } else if (!remoteStreamFile.canRead()) {
            this.logger.log(3, "Include file not readable: " + this.includePath);
        } else {
            List lines;
            try (BufferedReader in = new BufferedReader((Reader)new IFSFileReader(remoteStreamFile));){
                lines = IOUtils.readLines((Reader)in);
            }
            StringBuilder sb = new StringBuilder(4096);
            int i = 0;
            while (i < lines.size()) {
                sb.append((String)lines.get(i));
                if (i < lines.size() - 1) {
                    sb.append("\n");
                }
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    public String getIncludeCode() {
        return this.includeCode;
    }
}

