/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.iledocs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.iledocs.model.Constant;
import miworkplace.iledocs.model.Procedure;
import miworkplace.iledocs.model.Program;
import miworkplace.iledocs.model.Variable;
import miworkplace.ui.editor.ILEDocsProvider;
import miworkplace.ui.editor.iledocs.CompositeKey;

public class InMemoryILEDocsProvider
implements ILEDocsProvider {
    private Map<CompositeKey, Program> contentMap = new HashMap<CompositeKey, Program>();

    @Override
    public void add(String connectionName, String ifsPath, Program iledocsModel) {
        this.contentMap.put(new CompositeKey(connectionName, ifsPath), iledocsModel);
    }

    @Override
    public Program get(String connectionName, String ifsPath) {
        return this.contentMap.get(new CompositeKey(connectionName, ifsPath));
    }

    @Override
    public Procedure getProcedure(String connectionName, String ifsPath, String procedureName, List<String> nestedIncludePaths) {
        Program iledocs = this.get(connectionName, ifsPath);
        if (iledocs == null) {
            return null;
        }
        for (Procedure procedure : iledocs.getProcedures()) {
            if (!procedure.getName().equalsIgnoreCase(procedureName)) continue;
            return procedure;
        }
        for (String nestedIncludePath : nestedIncludePaths) {
            iledocs = this.get(connectionName, nestedIncludePath);
            if (iledocs == null) continue;
            for (Procedure procedure : iledocs.getProcedures()) {
                if (!procedure.getName().equalsIgnoreCase(procedureName)) continue;
                return procedure;
            }
        }
        return null;
    }

    @Override
    public Constant getConstant(String connectionName, String ifsPath, String constantName, List<String> nestedIncludePaths) {
        Program iledocs = this.get(connectionName, ifsPath);
        if (iledocs == null) {
            return null;
        }
        for (Constant constant : iledocs.getConstants()) {
            if (!constant.getName().equalsIgnoreCase(constantName)) continue;
            return constant;
        }
        for (String nestedIncludePath : nestedIncludePaths) {
            iledocs = this.get(connectionName, nestedIncludePath);
            if (iledocs == null) continue;
            for (Constant constant : iledocs.getConstants()) {
                if (!constant.getName().equalsIgnoreCase(constantName)) continue;
                return constant;
            }
        }
        return null;
    }

    @Override
    public Variable getVariable(String connectionName, String ifsPath, String variableName, List<String> nestedIncludePaths) {
        Program iledocs = this.get(connectionName, ifsPath);
        if (iledocs == null) {
            return null;
        }
        for (Variable variable : iledocs.getVariables()) {
            if (!variable.getName().equalsIgnoreCase(variableName)) continue;
            return variable;
        }
        for (String nestedIncludePath : nestedIncludePaths) {
            iledocs = this.get(connectionName, nestedIncludePath);
            if (iledocs == null) continue;
            for (Variable variable : iledocs.getVariables()) {
                if (!variable.getName().equalsIgnoreCase(variableName)) continue;
                return variable;
            }
        }
        return null;
    }
}

