/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.history;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URL;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.history.LocalHistoryWizardPage;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class LocalHistoryWizard
extends Wizard {
    @Inject
    private IEclipseContext context;
    private LocalHistoryWizardPage wizPage = null;
    private IRemoteObject remoteObject;

    public LocalHistoryWizard() {
        this.setWindowTitle(Messages.common_replace_with);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/icons/local-history-wizard.png")));
    }

    @PostConstruct
    public void postConstruct(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IRemoteObject) {
            this.remoteObject = (IRemoteObject)element;
        }
    }

    public boolean performFinish() {
        return this.wizPage.getSelectedSourceCode() != null;
    }

    public IRemoteObject getTarget() {
        return this.remoteObject;
    }

    public String getLocalHistoryCode() {
        return this.wizPage.getSelectedSourceCode();
    }

    public void addPages() {
        IEclipseContext wizardContext = this.context.createChild();
        wizardContext.set(IRemoteObject.class, (Object)this.remoteObject);
        this.wizPage = (LocalHistoryWizardPage)((Object)ContextInjectionFactory.make(LocalHistoryWizardPage.class, (IEclipseContext)wizardContext));
        this.addPage((IWizardPage)this.wizPage);
    }
}

