/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.history;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.TreeMap;
import miworkplace.common.model.IConnection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class LocalHistoryPersistenceService {
    private static final int MAXIMUM_NUMBER_LOCAL_HISTORY_FILES = 20;
    private static final String BASE_FOLDER = "local_history";
    private IPath bundleStateLocation;
    private LogService logger;

    public LocalHistoryPersistenceService() {
        Bundle bundle = Platform.getBundle((String)"miworkplace.ui.editor");
        this.bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
    }

    public void save(IConnection connection, String ifsPath, String code) {
        try {
            File historyFile = this.getHistoryFileHandle(connection, ifsPath);
            if (historyFile == null) {
                this.logger.log(1, "Could not get file handle for local history for " + connection.getName() + ": " + ifsPath + ".");
                return;
            }
            historyFile.createNewFile();
            FileWriter out = new FileWriter(historyFile);
            IOUtils.write((String)code, (Writer)out);
            ((Writer)out).close();
        }
        catch (Exception e) {
            this.logger.log(1, "Error during saving local history file for " + ifsPath, (Throwable)e);
        }
    }

    public File[] listHistoryFiles(IConnection connection, String ifsPath) {
        Path historyPath = new Path(this.bundleStateLocation.append(BASE_FOLDER).append(connection.getName()).toString() + ifsPath);
        if (!historyPath.toFile().exists()) {
            return new File[0];
        }
        File[] historyFiles = historyPath.toFile().listFiles();
        return historyFiles;
    }

    private File getHistoryFileHandle(IConnection conn, String ifsPath) throws Exception {
        File histFile = null;
        String histFileBaseName = FilenameUtils.getName((String)ifsPath);
        Path historyPath = new Path(this.bundleStateLocation.append(BASE_FOLDER).append(conn.getName()).toString() + ifsPath);
        if (!historyPath.toFile().exists() && !historyPath.toFile().mkdirs()) {
            throw new RuntimeException("Could not create directory structure for history file. " + historyPath.toOSString());
        }
        File[] histFiles = historyPath.toFile().listFiles();
        TreeMap<Integer, File> histFileMap = new TreeMap<Integer, File>();
        int i = 0;
        while (i < histFiles.length) {
            if (histFiles[i].isFile()) {
                histFileMap.put(Integer.parseInt(FilenameUtils.getExtension((String)histFiles[i].getName())), histFiles[i]);
            }
            ++i;
        }
        if (!histFileMap.isEmpty()) {
            int suffix = (Integer)histFileMap.lastKey();
            histFile = historyPath.append(histFileBaseName + "." + String.valueOf(++suffix)).toFile();
        } else {
            histFile = historyPath.append(histFileBaseName + ".1").toFile();
        }
        while (histFileMap.size() >= 20) {
            File firstFile = (File)histFileMap.get(histFileMap.firstKey());
            try {
                firstFile.delete();
            }
            catch (Exception e) {
                this.logger.log(1, "Could not delete local history file " + firstFile.getAbsolutePath() + ".", (Throwable)e);
            }
            histFileMap.remove(histFileMap.firstKey());
        }
        return histFile;
    }

    void bindLogService(LogService logger) {
        this.logger = logger;
    }

    void unbindLogService(LogService logger) {
        this.logger = null;
    }
}

