/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.osgi.service.log.LogService;

public class JoinLinesHandler {
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        Point selectedRange = viewer.getSelectedRange();
        try {
            IDocument document = viewer.getDocument();
            int currentLine = document.getLineOfOffset(selectedRange.x + selectedRange.y);
            if (document.getNumberOfLines() > currentLine + 1) {
                IRegion nextLineInfo = document.getLineInformation(currentLine + 1);
                String nextLine = document.get(nextLineInfo.getOffset(), nextLineInfo.getLength());
                int x = this.indexOfFirstNonWhitespace(nextLine);
                if (x == -1) {
                    int lineLength = document.getLineLength(currentLine + 1);
                    viewer.getTextWidget().replaceTextRange(nextLineInfo.getOffset(), lineLength, "");
                } else {
                    if ("//".equals(document.get(nextLineInfo.getOffset() + x, 2))) {
                        int additionalOffset = this.indexOfFirstNonWhitespace(nextLine.substring(x += 2));
                        x += additionalOffset;
                    }
                    IRegion currentLineInfo = document.getLineInformation(currentLine);
                    String line = document.get(currentLineInfo.getOffset(), currentLineInfo.getLength());
                    int offsetModifier = this.indexOfLastNonWhitespace(line);
                    viewer.getTextWidget().replaceTextRange(nextLineInfo.getOffset() - 1 - offsetModifier, x + 1 + offsetModifier, " ");
                }
            }
        }
        catch (BadLocationException e) {
            this.logger.log(4, "Could not join lines. Cause: " + e.getMessage());
        }
    }

    private int indexOfFirstNonWhitespace(String nextLine) {
        int i = 0;
        while (i < nextLine.length()) {
            if (!Character.isWhitespace(nextLine.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfLastNonWhitespace(String line) {
        int i = line.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return (i + 1 - line.length()) * -1;
            }
            --i;
        }
        return 0;
    }
}

