/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.editor.RemoteEditor;
import miworkplace.ui.editor.handler.NumberRangeValidator;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class GoToLineHandler {
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IRemoteEditor;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        RemoteEditor editor;
        InputDialog dialog;
        Object value = part.getObject();
        if (value instanceof RemoteEditor && (dialog = new InputDialog(shell, Messages.editor_handler_goto_title, this.buildMessage((editor = (RemoteEditor)value).getDocument().getNumberOfLines()), null, (IInputValidator)new NumberRangeValidator(editor.getDocument().getNumberOfLines()))).open() == 0) {
            int targetLineNumber = Integer.parseInt(dialog.getValue());
            targetLineNumber = targetLineNumber == 0 ? 1 : targetLineNumber;
            IDocument document = editor.getDocument();
            try {
                int lineOffset = document.getLineOffset(targetLineNumber - 1);
                editor.getViewer().revealRange(lineOffset, 1);
                editor.getViewer().setSelectedRange(lineOffset, 0);
            }
            catch (BadLocationException e) {
                this.logger.log(1, "Could not go to line " + targetLineNumber + ". Error: " + e.getMessage());
            }
        }
    }

    private String buildMessage(int numberOfLines) {
        return "Enter line number (1.." + String.valueOf(numberOfLines) + "):";
    }
}

