/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.osgi.service.log.LogService;

public class DuplicateLineHandler {
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        Point selectedRange = viewer.getSelectedRange();
        try {
            int startLine = viewer.getDocument().getLineOfOffset(selectedRange.x);
            int lineStartOffset = viewer.getDocument().getLineOffset(startLine);
            int lineLength = viewer.getDocument().getLineLength(startLine);
            Object text = viewer.getDocument().get(lineStartOffset, lineLength);
            if (!((String)text).endsWith("\n")) {
                text = (String)text + "\n";
                ++lineLength;
            }
            int insertOffset = lineStartOffset + lineLength;
            viewer.getDocument().replace(insertOffset, 0, (String)text);
            int newCursorPosition = selectedRange.x + lineLength;
            viewer.setSelectedRange(newCursorPosition, 0);
            viewer.revealRange(newCursorPosition, 1);
        }
        catch (BadLocationException e) {
            this.logger.log(1, "Could not duplicate line.", (Throwable)e);
        }
    }
}

