/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.diff.myers;

import java.lang.reflect.Array;
import java.util.List;
import miworkplace.ui.editor.diff.ChangeDelta;
import miworkplace.ui.editor.diff.Chunk;
import miworkplace.ui.editor.diff.DeleteDelta;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.DiffAlgorithm;
import miworkplace.ui.editor.diff.InsertDelta;
import miworkplace.ui.editor.diff.Patch;
import miworkplace.ui.editor.diff.myers.DiffNode;
import miworkplace.ui.editor.diff.myers.DifferentiationFailedException;
import miworkplace.ui.editor.diff.myers.PathNode;
import miworkplace.ui.editor.diff.myers.Snake;

public class MyersDiff
implements DiffAlgorithm {
    @Override
    public Patch diff(List<?> original, List<?> revised) {
        return this.diff(original.toArray(), revised.toArray());
    }

    @Override
    public Patch diff(Object[] orig, Object[] rev) {
        try {
            PathNode path = MyersDiff.buildPath(orig, rev);
            return MyersDiff.buildRevision(path, orig, rev);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            return new Patch();
        }
    }

    public static PathNode buildPath(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int N = orig.length;
        int M = rev.length;
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        int d = 0;
        while (d < MAX) {
            int k = -d;
            while (k <= d) {
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                if (k == -d || k != d && diagonal[kminus].i < diagonal[kplus].i) {
                    i = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                int j = i - k;
                PathNode node = new DiffNode(i, j, prev);
                while (i < N && j < M && orig[i].equals(rev[j])) {
                    ++i;
                    ++j;
                }
                if (i > node.i) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i >= N && j >= M) {
                    return diagonal[kmiddle];
                }
                k += 2;
            }
            diagonal[middle + d - 1] = null;
            ++d;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public static Patch buildRevision(PathNode path, Object[] orig, Object[] rev) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Patch patch = new Patch();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i;
            int j = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Chunk original = new Chunk(ianchor, MyersDiff.copyOfRange(orig, ianchor, i));
            Chunk revised = new Chunk(janchor, MyersDiff.copyOfRange(rev, janchor, j));
            Delta delta = null;
            delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta(original, revised) : new ChangeDelta(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return patch;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return MyersDiff.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

