/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.diff;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.DeltaComparator;
import miworkplace.ui.editor.diff.PatchFailedException;

public class Patch {
    private List<Delta> deltas = new LinkedList<Delta>();

    public List<?> applyTo(List<?> target) throws PatchFailedException {
        LinkedList<Object> result = new LinkedList<Object>(target);
        ListIterator<Delta> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public List<?> restore(List<?> target) {
        LinkedList<Object> result = new LinkedList<Object>(target);
        ListIterator<Delta> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta delta = it.previous();
            delta.restore(result);
        }
        return result;
    }

    public void addDelta(Delta delta) {
        this.deltas.add(delta);
    }

    public List<Delta> getDeltas() {
        Collections.sort(this.deltas, DeltaComparator.INSTANCE);
        return this.deltas;
    }
}

