/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.composites;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.nebula.widgets.progresscircle.ProgressCircle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LoadingComposite
extends Composite {
    private ProgressCircle fCircle;
    private int fTicks = 1;
    private int fDone = 0;
    private static int LOADINGDELAY = 500;
    private long fStart;
    private boolean fIsCircleVisible;

    public LoadingComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.fCircle = new ProgressCircle(composite, 0);
        this.fCircle.setTextPattern("%d%%");
        this.fCircle.setMinimum(0);
        this.fCircle.setMaximum(100);
        this.fCircle.setSelection(0);
        this.fCircle.setThickness(20);
        this.fCircle.setCircleSize(200);
        this.fCircle.setShowText(true);
        this.fCircle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.fCircle.setVisible(false);
    }

    public LoadingComposite setTicks(int ticks) {
        this.fTicks = ticks;
        if (this.fTicks <= 0) {
            this.fTicks = 100;
        }
        this.fStart = System.currentTimeMillis();
        return this;
    }

    public LoadingComposite setWorkDone(int ticks) {
        this.fDone += ticks;
        if (this.makeProgressVisible()) {
            this.getDisplay().syncExec(() -> {
                int percent = this.fDone * 100 / this.fTicks;
                if (this.fCircle.getSelection() < percent && Math.floorMod(percent, 5) == 0) {
                    this.fCircle.setSelection(percent);
                }
            });
        }
        return this;
    }

    private boolean makeProgressVisible() {
        if (this.fIsCircleVisible) {
            return true;
        }
        long timePassed = System.currentTimeMillis() - this.fStart;
        if (timePassed < (long)LOADINGDELAY) {
            return false;
        }
        this.fIsCircleVisible = true;
        this.getDisplay().syncExec(() -> {
            this.fCircle.setBackground(this.getBackground());
            this.fCircle.setVisible(true);
        });
        return true;
    }

    protected void checkSubclass() {
    }

    public IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor(){

            public void beginTask(String pName, int pTotalWork) {
                LoadingComposite.this.setTicks(pTotalWork);
                super.beginTask(pName, pTotalWork);
            }

            public void worked(int pWork) {
                LoadingComposite.this.setWorkDone(pWork);
            }
        };
    }
}

