/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SequentialFile;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.ILockService;
import miworkplace.ui.editor.IDocumentReceiver;
import miworkplace.ui.editor.ISourceCodeReceiver;
import miworkplace.ui.editor.SourceUtil;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class SourceContentLoader
implements IRunnableWithProgress,
Runnable {
    private static final String NEWLINE = "\n";
    private static final String SRCDTA = "SRCDTA";
    private static final String DIALOG_TITLE = Messages.editor_memberloader_notify;
    private Debug logger = Debug.getInstance();
    @Inject
    private UISynchronize sync;
    @Inject
    private ILockService lockService;
    @Inject
    private IConnection connection;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    private IDocumentReceiver receiver;
    @Inject
    @Optional
    private ISourceCodeReceiver sourceCodeReceiver;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    @Named(value="miworkplace.editor.readonly")
    private Boolean readOnly;
    @Inject
    @Preference(nodePath="miworkplace.application")
    protected IEclipsePreferences fApplicationPreferences;
    private IStatus fStatus;

    @Override
    public void run() {
        this.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void run(IProgressMonitor pMonitor) {
        boolean retain5250Colors = this.fApplicationPreferences.getBoolean("miworkplace.ui.editor.retain5250sourcecoloring", false);
        final String memberPath = EditorInputUriUtil.getMemberPath((String)this.inputUri);
        StringBuilder content = new StringBuilder();
        SequentialFile file = new SequentialFile(this.getConnection().getSystem(), memberPath);
        IStatus status = this.acquireLock(memberPath);
        if (!status.isOK()) {
            this.setResult(status);
            return;
        }
        try {
            file.setRecordFormat();
            file.open(0, 100, 3);
            Record record = file.readLast();
            int size = record == null ? 0 : record.getRecordNumber();
            ArrayList<Record> records = new ArrayList<Record>(size);
            if (size > 0) {
                pMonitor.beginTask(MessageFormat.format(Messages.reading_x_rcrds, size), size);
                record = file.readFirst();
                FieldDescription fieldDescription = record.getRecordFormat().getFieldDescription(2);
                while (record != null) {
                    Object line = null;
                    line = retain5250Colors ? SourceUtil.convertToString(record.getFieldAsBytes(2), fieldDescription) : record.getField(2).toString().stripTrailing() + NEWLINE;
                    content.append((String)line);
                    pMonitor.worked(1);
                    records.add(record);
                    record = file.readNext();
                }
            }
            file.close();
            pMonitor.subTask(Messages.writing_local);
            String code = content.toString();
            SourceMember member = (SourceMember)this.workspaceStore.get(this.connection, memberPath);
            IResource localResource = member.getLocalResource();
            File localFile = localResource.getLocation().toFile();
            this.createFile(localFile);
            FileWriter out = new FileWriter(localFile);
            IOUtils.write((String)code, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
            int maxRecordLength = file.getRecordFormat().getFieldDescription(SRCDTA).getLength();
            Document document = new Document(code);
            this.sync.asyncExec(() -> this.lambda$0((IDocument)document));
            if (this.sourceCodeReceiver != null) {
                this.sourceCodeReceiver.setSourceCode(records.toArray(new Record[0]), maxRecordLength);
            }
            this.setResult(Status.OK_STATUS);
        }
        catch (Exception e) {
            String message = MessageFormat.format("Error during loading of source code from member {0}.", memberPath);
            this.setResult((IStatus)new Status(2, this.getClass(), message, (Throwable)e));
            this.logger.error(message, (Throwable)e);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)DIALOG_TITLE, (String)String.format(Messages.editor_memberloader_error, memberPath));
                }
            });
        }
    }

    private void setResult(IStatus pStatus) {
        this.fStatus = pStatus;
    }

    public IStatus getResult() {
        return this.fStatus;
    }

    private IStatus acquireLock(String memberPath) {
        try {
            if (!this.readOnly.booleanValue()) {
                this.lockService.lockMember(this.connection, memberPath);
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format("Unable to lock member during loading of {0}.", memberPath);
            this.logger.error(message, (Throwable)e);
            return new Status(2, this.getClass(), message, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void createFile(File f) {
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format(Messages.editor_memberloader_local, f.getAbsolutePath()), e);
            }
        }
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
    }

    public String getInputUri() {
        return this.inputUri;
    }

    public void setInputUri(String inputUri) {
        this.inputUri = inputUri;
    }

    private /* synthetic */ void lambda$0(IDocument iDocument) {
        this.receiver.receiveDocument(iDocument);
    }
}

