/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.Arrays;
import java.util.List;
import miworkplace.ui.editor.WordBoundaryFinder;
import org.eclipse.jface.text.Region;

public class RpgWordBoundaryFinder
implements WordBoundaryFinder {
    List<Character> boundaryChars = Arrays.asList(Character.valueOf(' '), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('\''), Character.valueOf('='));

    @Override
    public Region findBoundary(String s, int offset) throws Exception {
        char c;
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        if (offset >= s.length()) {
            return null;
        }
        int left = offset;
        int right = offset;
        if (offset > 0) {
            int x = offset;
            while (x >= 0) {
                c = s.charAt(x);
                if (this.boundaryChars.contains(Character.valueOf(c))) {
                    Character.valueOf(c);
                    left = x + 1;
                    break;
                }
                if (x == 0) {
                    left = 0;
                }
                --x;
            }
        }
        int length = s.length();
        int x = offset;
        while (x < length) {
            c = s.charAt(x);
            if (this.boundaryChars.contains(Character.valueOf(c))) {
                Character.valueOf(c);
                right = x - 1;
                break;
            }
            if (x == length - 1) {
                right = length - 1;
            }
            ++x;
        }
        return new Region(left, right - left + 1);
    }
}

