/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import miworkplace.common.model.LineType;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class FormatLineProvider {
    private String defaultFormatLine = "....................................................................................................";
    private final HashMap<LineType, String> formatStrings = new HashMap();
    private LogService logger;

    public void activate() {
        this.load();
    }

    void bindLogService(LogService logger) {
        this.logger = logger;
    }

    void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public String getFormatLine(LineType type) {
        if (this.formatStrings.containsKey(type)) {
            return this.formatStrings.get(type);
        }
        return this.defaultFormatLine;
    }

    private void load() {
        PreferenceStore prefs = new PreferenceStore();
        try {
            Bundle yourBundle = Platform.getBundle((String)"miworkplace.ui.editor");
            Path relativePathToBundle = new Path("/formatlines.properties");
            InputStream in = FileLocator.openStream((Bundle)yourBundle, (IPath)relativePathToBundle, (boolean)false);
            prefs.load(in);
            in.close();
            this.formatStrings.put(LineType.CompilerDirective, prefs.getString("rpg.compilerDirective"));
            this.formatStrings.put(LineType.Copy, prefs.getString("rpg.compilerDirective"));
            this.formatStrings.put(LineType.Include, prefs.getString("rpg.compilerDirective"));
            this.formatStrings.put(LineType.FreeFormStart, prefs.getString("rpg.compilerDirective"));
            this.formatStrings.put(LineType.FreeFormEnd, prefs.getString("rpg.compilerDirective"));
            this.formatStrings.put(LineType.Header, prefs.getString("rpg.H"));
            this.formatStrings.put(LineType.File, prefs.getString("rpg.F"));
            this.formatStrings.put(LineType.Declaration, prefs.getString("rpg.D"));
            this.formatStrings.put(LineType.Input, prefs.getString("rpg.I"));
            this.formatStrings.put(LineType.Calculation, prefs.getString("rpg.C"));
            this.formatStrings.put(LineType.Output, prefs.getString("rpg.O"));
            this.formatStrings.put(LineType.Procedure, prefs.getString("rpg.P"));
            this.formatStrings.put(LineType.Record, prefs.getString("dds.record"));
            this.formatStrings.put(LineType.RecordEntry, prefs.getString("dds.recordentry"));
            this.formatStrings.put(LineType.FileLevel, prefs.getString("dds.filelevel"));
            this.defaultFormatLine = prefs.getString("default");
        }
        catch (IOException ioe) {
            this.logger.log(1, "Could not load properties for format lines.", (Throwable)ioe);
        }
        catch (NullPointerException nullPointerException) {
            this.logger.log(1, "No format lines in properties file.");
        }
    }
}

