/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.ibm.as400.access.QSYSObjectPathName;
import java.util.ArrayList;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IFileDescriptionService;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.File;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FileDescriptionEventReceiver
implements EventHandler {
    private IFileDescriptionService fileDescService;
    private IConnectionManager connManager;

    public void bindFileDescService(IFileDescriptionService service) {
        this.fileDescService = service;
    }

    public void unbindFileDescService(IFileDescriptionService service) {
        this.fileDescService = null;
    }

    public void bindConnectionManager(IConnectionManager service) {
        this.connManager = service;
    }

    public void unbindConnectionManager(IConnectionManager service) {
        this.connManager = null;
    }

    public void handleEvent(Event event) {
        String inputUri = event.getProperty("org.eclipse.e4.data").toString();
        String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
        IConnection connection = this.connManager.get(connectionName);
        List<String> filePaths = this.getFilePaths(event.getProperty("ast"));
        for (String path : filePaths) {
            this.fileDescService.clearFileDescription(connection, path);
        }
    }

    private List<String> getFilePaths(Object objectAst) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (objectAst instanceof Ast) {
            Ast ast = (Ast)objectAst;
            for (File file : ast.listFiles()) {
                try {
                    String ifsPath = QSYSObjectPathName.toPath((String)file.getExternalDescriptionLibrary(), (String)file.getExternalDescriptionFile(), (String)"FILE");
                    filePaths.add(ifsPath);
                }
                catch (Exception exception) {}
            }
        }
        return filePaths;
    }
}

