/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.remainsoftware.common.util.ServiceUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.services.api.IDoubleClickServiceProvider;
import miworkplace.ui.editor.handler.OpenWithDefaultEditorHandler;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.urischeme.IUriSchemeHandler;

public class EditUriSchemeHandler
implements IUriSchemeHandler {
    public void handle(String pUri) {
        try {
            URI uri = new URI(pUri);
            IConnection connection = this.getConnection(uri.getHost());
            if (connection == null) {
                MessageDialog.openError(null, (String)"Connection not found.", (String)MessageFormat.format("A connection with host '''{0}''' does not exist.", uri.getHost()));
                return;
            }
            if (!connection.isConnected()) {
                this.login(connection);
            }
            IWorkspaceStore store = this.getWorkspaceStore();
            String ifs = uri.getPath().toUpperCase();
            boolean readOnly = "readonly".equals(uri.getQuery());
            IRemoteObject remoteObject = store.get(connection, ifs);
            if (remoteObject instanceof SourceMember) {
                SourceMember member = (SourceMember)remoteObject;
                String commandId = OpenWithDefaultEditorHandler.getCommandId((SourceMember)member, (IContentTypeRegistry)this.getContentTypeRegistry());
                OpenWithDefaultEditorHandler.open((SourceMember)member, (String)commandId, (boolean)readOnly, (EHandlerService)this.getHandlerService(), (ECommandService)this.getCommandService(), (Debug)this.getLogger());
            } else {
                boolean cfr_ignored_0 = remoteObject instanceof StreamFile;
            }
        }
        catch (URISyntaxException e) {
            MessageDialog.openError(null, (String)"Could not open member", (String)MessageFormat.format("The editor could not be opened.\n\nThe URI was: '''{0}'''.\n\nThe Message was '''{1}'''", pUri, e.getMessage()));
            e.printStackTrace();
        }
    }

    private void login(IConnection pConnection) {
        IDoubleClickServiceProvider dbc = (IDoubleClickServiceProvider)ServiceUtils.getOSGiService(this.getClass(), IDoubleClickServiceProvider.class);
        dbc.get((Object)pConnection);
    }

    private Debug getLogger() {
        return Debug.getInstance();
    }

    private ECommandService getCommandService() {
        return (ECommandService)this.getApplication().getContext().get(ECommandService.class);
    }

    private MApplication getApplication() {
        IWorkbench workbench = (IWorkbench)ServiceUtils.getOSGiService(this.getClass(), IWorkbench.class);
        MApplication mApplication = workbench.getApplication();
        return mApplication;
    }

    private EHandlerService getHandlerService() {
        return (EHandlerService)this.getApplication().getContext().get(EHandlerService.class);
    }

    private IContentTypeRegistry getContentTypeRegistry() {
        return (IContentTypeRegistry)ServiceUtils.getOSGiService(this.getClass(), IContentTypeRegistry.class);
    }

    private IWorkspaceStore getWorkspaceStore() {
        return (IWorkspaceStore)ServiceUtils.getOSGiService(this.getClass(), IWorkspaceStore.class);
    }

    private IConnection getConnection(String pHost) {
        IConnectionManager manager = (IConnectionManager)ServiceUtils.getOSGiService(this.getClass(), IConnectionManager.class);
        List list = manager.list();
        for (IConnection connection : list) {
            if (!connection.getSystemName().equalsIgnoreCase(pHost)) continue;
            return connection;
        }
        return null;
    }
}

