/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.inject.Inject;
import miworkplace.ui.editor.DefaultCompletionProcessor;
import miworkplace.ui.editor.HoverInformationControl;
import miworkplace.ui.themes.Colors;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DefaultSourceViewerConfiguration
extends SourceViewerConfiguration {
    @Inject
    private IEclipseContext context;

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new RuleBasedScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        ca.enableColoredLabels(true);
        ca.enableAutoInsert(true);
        ca.setContentAssistProcessor((IContentAssistProcessor)ContextInjectionFactory.make(DefaultCompletionProcessor.class, (IEclipseContext)this.context), "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        ca.setProposalSelectorForeground(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
        ca.setProposalSelectorBackground(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
        return ca;
    }

    public IInformationControlCreator getInformationControlCreator(final ISourceViewer sourceViewer) {
        if (BrowserInformationControl.isAvailable((Composite)sourceViewer.getTextWidget())) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    HoverInformationControl informationControl = new HoverInformationControl(parent, null, true);
                    informationControl.setForegroundColor(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
                    informationControl.setBackgroundColor(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
                    return informationControl;
                }
            };
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                DefaultInformationControl informationControl = new DefaultInformationControl(sourceViewer.getTextWidget().getShell());
                informationControl.setForegroundColor(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
                informationControl.setBackgroundColor(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
                return informationControl;
            }
        };
    }
}

