/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.HashMap;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.osgi.service.log.LogService;

public class DefaultDoubleClickExecutor
implements IDoubleClickExecutor {
    private LogService logger;

    void bindLogService(LogService logger) {
        this.logger = logger;
    }

    void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public void bindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.register((IDoubleClickExecutor)this);
    }

    public void unbindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.deregister((IDoubleClickExecutor)this);
    }

    public void execute(Object obj, EHandlerService handlerService, ECommandService commandService) {
        if (obj instanceof SourceMember || obj instanceof StreamFile) {
            IRemoteObject remoteObject = (IRemoteObject)obj;
            if (obj instanceof StreamFile && ((StreamFile)obj).isDirectory()) {
                return;
            }
            Command command = this.determineCommand(remoteObject, commandService);
            if (command.isDefined()) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("miworkplace.ui.editor.command.parameter.selection", remoteObject.getPath());
                parameters.put("miworkplace.ui.editor.command.parameter.connection", remoteObject.getConnection().getName());
                parameters.put("miworkplace.ui.editor.command.parameter.readonly", Boolean.FALSE.toString());
                ParameterizedCommand cmd = commandService.createCommand(command.getId(), parameters);
                if (handlerService.canExecute(cmd)) {
                    this.logger.log(4, "Opening source " + remoteObject.getPath() + " with the command " + command.getId());
                    handlerService.executeHandler(cmd);
                } else {
                    this.logger.log(1, "Cannot execute command open source member. Command Id: " + command.getId());
                }
            } else {
                this.logger.log(1, "Command for opening source member is not defined. Command Id: " + command.getId());
            }
        }
    }

    private Command determineCommand(IRemoteObject sourceObject, ECommandService commandService) {
        String commandId = null;
        if (sourceObject instanceof SourceMember) {
            commandId = "miworkplace.ui.editor.command.open.with.default";
        } else if (sourceObject instanceof StreamFile) {
            commandId = "miworkplace.ui.editor.command.ifs.open.with.default";
        }
        Command command = commandService.getCommand(commandId);
        return command;
    }

    public boolean canExecute(ECommandService commandService, Object object) {
        if (object instanceof SourceMember || object instanceof StreamFile) {
            if (object instanceof StreamFile && ((StreamFile)object).isDirectory()) {
                return false;
            }
            Command command = this.determineCommand((IRemoteObject)object, commandService);
            return command.isDefined();
        }
        return false;
    }

    public Integer getRanking() {
        return 100;
    }
}

